/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply.dto;

import com.kuaike.skynet.logic.service.reply.dto.resp.ChatroomRespDto;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @title RobotToRoomDto
 * @author yanmaoyuan
 * @date 2020年2月18日
 * @version 1.0
 */
@Data
public class RobotToRoomDto implements Serializable{

    private static final long serialVersionUID = 1L;

    /**
     * 发送入群邀请的机器人微信id
     */
    private String wechatId; 
    
    /**
     * 用于显示的机器人昵称
     */
    private String nickName;

    /**
     * 用于显示的机器人微信号
     */
    private String alias;

    /**
     * 加群卡片对应的群ID
     */
    private List<String> chatroomIds;

    /**
     * 用于显示的群信息
     */
    private List<ChatroomRespDto> chatroomList;
}