package com.kuaike.skynet.logic.service.reply.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Collection;

/**
 * @author ：qiucheng
 * @date ：Created in 2019/6/20 下午7:55
 * @description：
 */
@Data
public class MarketWordReplyDto implements Serializable {

    private static final long serialVersionUID = -1942798077691646313L;

    /**
     * 关键词
     */
    private String word;

    /**
     * 问题描述
     */
    private String request;

    /**
     * 匹配类型：1全匹配，2半匹配
     */
    private Integer type;

    /**
     * 素材id
     * 
     * @deprecated 营销方案自动回复需要支持多个回复内容
     */
    @Deprecated
    private Long materialId;

    /**
     * 回复内容
     */
    private Collection<AutoReplyMessageDto> replyMessage;
}
