package com.kuaike.skynet.logic.service.reply.dto;

import com.kuaike.skynet.logic.service.common.dto.Operator;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;

import com.google.common.base.Preconditions;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 自动回复对象的公共结构
 * 
 * @title LogicReplyDto
 * @author yanmaoyuan
 * @date 2020年8月2日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LogicReplyDto extends Operator implements Serializable{
    private static final long serialVersionUID = 2435515479616290480L;
    /** 自动回复id 用于修改 */
    private Long id;
    /** 标题 */
    private String title;
    /** 问题 */
    private String request;
    /** 回复消息 */
    private Collection<AutoReplyMessageDto> replyMessage;
    /** 关系类型 */
    private Integer relationType;
    /** 回复类型 */
    private Integer replyType;

    // 群内设置的回复机器人
    private List<LogicReplyWechatDto> roomWechatDtos;

    public LogicReplyDto (Integer relationType, Integer replyType) {
        this.relationType = relationType;
        this.replyType = replyType;
    }

    public LogicReplyDto (AutoReplyRelationType relationTypeEnum, AutoReplyType replyTypeEnum) {
        this.relationType = relationTypeEnum.getValue();
        this.replyType = replyTypeEnum.getValue();
    }

    public void validate() {
        Preconditions.checkArgument(this.getNodeId() != null, "nodeId不能为空");
        Preconditions.checkArgument(this.getBusinessCustomerId() != null, "businessCustomerId不能为空");
        Preconditions.checkArgument(this.getOperatorId() != null, "operatorId不能为空");
        Preconditions.checkArgument(this.getReplyType() != null, "replyType不能为空");
        Preconditions.checkArgument(this.getRelationType() != null, "relationType不能为空");
    }
}
