package com.kuaike.skynet.logic.service.reply;

import com.kuaike.skynet.logic.service.common.dto.resp.WechatResp;
import com.kuaike.skynet.logic.service.reply.dto.label.*;

import java.util.Set;


/**
 * @description:
 * @author: liuguohong
 * @create: 2021/02/28 17:52
 */

public interface FriendKeywordTagLabelService {

    /**
     * 私聊关键词打标签
     *
     * @param params
     * @return 操作成功，返回主键ID
     */
    void add(FriendKeywordLabelReq params);

    /**
     * 修改微信好友私聊关键词回复
     * @param params
     */
    void modify(FriendKeywordLabelReq params);

    /**
     * 查询好友私聊关键词回复列表
     * @param params
     * @return 返回查询结果
     */
    FriendKeywordLabelListResp list(FriendKeywordLabelListReq params);

    /**
     * 查询自动回复的详细信息
     *
     * @param params
     * @return 返回详细结果
     */
    FriendKeywordLabelDetailResp detail(FriendKeywordLabelIdReqDto params);

    /**
     * 删除微信好友私聊关键词回复
     *
     * @param params
     */
    void delete(FriendKeywordLabelIdReqDto params);

    /**
     * 检查微信号中是否有已经设置的
     * @param req
     * @return Set<WechatResp> 已经设置过微信号的详情
     */
    Set<WechatResp> check(FriendKeywordLabelCheckReq req);
}
