/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply;

import com.kuaike.skynet.logic.service.reply.dto.req.FriendKeywordReplyCheckReq;
import com.kuaike.skynet.logic.service.reply.dto.req.FriendKeywordReplyIdReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.FriendKeywordReplyListReq;
import com.kuaike.skynet.logic.service.reply.dto.req.FriendKeywordReplyReq;
import com.kuaike.skynet.logic.service.reply.dto.resp.FriendKeywordReplyDetailResp;
import com.kuaike.skynet.logic.service.reply.dto.resp.FriendKeywordReplyListResp;

import java.util.List;

/**
 * 微信好友私聊关键词回复接口
 * 
 * @title FriendKeywordReplyService
 * @author yanmaoyuan
 * @date 2019年12月16日
 * @version 1.0
 */
public interface FriendKeywordReplyService {

    /**
     * 添加微信好友私聊关键词回复
     * 
     * @param params
     * @return 操作成功，返回主键ID
     */
    Long add(FriendKeywordReplyReq params);

    /**
     * 批量添加微信好友私聊关键词回复
     * 
     * @param list
     */
    void addAll(List<FriendKeywordReplyReq> list);

    /**
     * 修改微信好友私聊关键词回复
     * @param params
     */
    void modify(FriendKeywordReplyReq params);

    /**
     * 检测微信好友私聊关键词是否已经被使用
     * 
     * @param params
     * @return 返回已经设置过该关键词的微信ID
     */
    List<String> check(FriendKeywordReplyCheckReq params);

    /**
     * 查询好友私聊关键词回复列表
     * @param params
     * @return 返回查询结果
     */
    FriendKeywordReplyListResp list(FriendKeywordReplyListReq params);
    
    /**
     * 查询自动回复的详细信息
     * 
     * @param params
     * @return 返回详细结果
     */
    FriendKeywordReplyDetailResp detail(FriendKeywordReplyIdReqDto params);

    /**
     * 删除微信好友私聊关键词回复
     * 
     * @param params
     */
    void delete(FriendKeywordReplyIdReqDto params);
}