/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.skynet.logic.service.reply;

import com.kuaike.skynet.logic.service.reply.dto.req.AutoReplyReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.JoinGroupReplyListReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyIdReqDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListResp;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListRespDto;

/**
 * 批量群聊答复
 * 
 * 一批微信群共用关键词回复内容，编辑时会同时应用到所有群上。
 * 
 * @title BatchGroupKeywordReplyService
 * @author yanmaoyuan
 * @date 2020年4月15日
 * @version 1.0
 */
public interface BatchGroupKeywordReplyService {

    /**
     * 添加
     * 
     * @param params
     */
    void add(AutoReplyReqDto params);

    /**
     * 编辑
     * 
     * @param params
     */
    void modify(AutoReplyReqDto params);

    /**
     * 删除
     * 
     * @param params
     */
    void delete(ReplyIdReqDto params);

    /**
     * 检查回复关键词是否重复
     * 
     * @param params
     * @return
     */
    boolean check(AutoReplyReqDto params);

    /**
     * 查询详情
     * 
     * @param params
     * @return
     */
    ReplyListResp detail(ReplyIdReqDto params);

    /**
     * 查询列表
     * 
     * @param params
     * @return
     */
    ReplyListRespDto list(JoinGroupReplyListReqDto params);

}