package com.kuaike.skynet.logic.service.common.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @description: 通用消息类
 * @author: liuguohong
 * @create: 2019/06/22 17:36
 */
@Data
public class CommonMessage implements Serializable {

    private static final long serialVersionUID = 7323145440299880873L;
    /**
     * 消息编号，第几条消息
     */
    private Integer seq;

    /**
     * 延迟发送
     */
    private Integer delay;

    /**
     * 消息类型 ReplyMessageType
     */
    private Integer type;
    /**
     * 消息内容
     */
    private String content;

    /**
     * 获取消息延迟发送的时间(单位:秒)
     * 
     * 为了防止异常，这里会有默认值0。
     * @return
     */
    public int getDelay() {
        if (delay == null || delay < 0) {
            return 0;
        }
        
        return delay;
    }

    /**
     * 设置延迟发送时间
     * 
     * @param delay
     */
    public void setDelay(Integer delay) {
        if (delay == null) {
            delay = 0;
        }
        this.delay = delay;
    }
}
