/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.wechat.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.skynet.logic.dal.reply.dto.AutoRemarkFriendConfigDto;
import com.kuaike.skynet.logic.dal.reply.dto.AutoRemarkFriendListParams;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoRemarkFriendConfig;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoRemarkFriendConfigMapper;
import com.kuaike.skynet.logic.dal.user.entity.User;
import com.kuaike.skynet.logic.dal.user.mapper.UserMapper;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatAccount;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatAccountMapper;
import com.kuaike.skynet.logic.service.common.dto.resp.OperatorResp;
import com.kuaike.skynet.logic.service.common.dto.resp.WechatResp;
import com.kuaike.skynet.logic.service.wechat.WechatAutoRemarkFriendService;
import com.kuaike.skynet.logic.service.wechat.dto.req.AutoRemarkFriendDetailReq;
import com.kuaike.skynet.logic.service.wechat.dto.req.AutoRemarkFriendEditReq;
import com.kuaike.skynet.logic.service.wechat.dto.req.AutoRemarkFriendListReq;
import com.kuaike.skynet.logic.service.wechat.dto.req.AutoRemarkFriendToggleReq;
import com.kuaike.skynet.logic.service.wechat.dto.resp.AutoRemarkFriendDetailRespDto;
import com.kuaike.skynet.logic.service.wechat.dto.resp.AutoRemarkFriendListResp;
import com.kuaike.skynet.logic.service.wechat.dto.resp.AutoRemarkFriendResp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WechatAutoRemarkFriendServiceImpl
implements WechatAutoRemarkFriendService {
    private static final Logger log = LoggerFactory.getLogger(WechatAutoRemarkFriendServiceImpl.class);
    @Autowired
    private WechatAccountMapper wechatAccountMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private LogicAutoRemarkFriendConfigMapper logicAutoRemarkFriendConfigMapper;

    @Transactional(rollbackFor={Exception.class})
    public Long addOrMod(AutoRemarkFriendEditReq params) {
        log.info("addOrMod WechatAutoRemarkFriend with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getWechatId()}), (Object)"wechatId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getFormat()}), (Object)"format\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getFormat().length() <= 128 ? 1 : 0) != 0, (Object)"\u5907\u6ce8\u4fe1\u606f\u4e0d\u53ef\u8d85\u8fc7128\u4e2a\u5b57\u7b26");
        Date now = new Date();
        LogicAutoRemarkFriendConfig config = this.logicAutoRemarkFriendConfigMapper.queryByWechatId(params.getBusinessCustomerId(), params.getWechatId());
        if (config == null) {
            config = new LogicAutoRemarkFriendConfig();
            config.setBusinessCustomerId(params.getBusinessCustomerId());
            config.setCreateBy(params.getOperatorId());
            config.setCreateTime(now);
            config.setWechatId(params.getWechatId());
        }
        if (params.getEnabled() != null) {
            config.setEnabled(Integer.valueOf(params.getEnabled() != false ? 1 : 0));
        }
        if (params.getEnabled() == null) {
            config.setEnabled(Integer.valueOf(1));
        }
        config.setStartTime(params.getStartTime());
        config.setEndTime(params.getEndTime());
        config.setFormat(params.getFormat());
        config.setUpdateBy(params.getOperatorId());
        config.setUpdateTime(now);
        if (config.getId() != null) {
            this.logicAutoRemarkFriendConfigMapper.updateByPrimaryKey((Object)config);
        } else {
            this.logicAutoRemarkFriendConfigMapper.insert((Object)config);
        }
        return config.getId();
    }

    public AutoRemarkFriendListResp list(AutoRemarkFriendListReq params) {
        log.info("query WechatAutoRemarkFriend list with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u53ef\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)params.getUserIds())) {
            log.info("\u64cd\u4f5c\u8005\u7ba1\u8f96\u7684\u7528\u6237id\u96c6\u5408\u4e3a\u7a7a\uff0c\u65e0\u8fd4\u56de\u6570\u636e\u3002");
            return this.emptyAutoRemarkFriendListResp();
        }
        AutoRemarkFriendListParams queryParams = new AutoRemarkFriendListParams();
        queryParams.setUserIds(params.getUserIds());
        queryParams.setBusinessCustomerId(params.getBusinessCustomerId());
        queryParams.setWechatId(params.getWechatId());
        queryParams.setEffectiveStartTime(params.getEffectiveStartTime());
        queryParams.setEffectiveEndTime(params.getEffectiveEndTime());
        queryParams.setUserId(params.getUserId());
        queryParams.setUpdateStartTime(params.getUpdateStartTime());
        queryParams.setUpdateEndTime(params.getUpdateEndTime());
        queryParams.setTimeSort(params.getTimeSort());
        queryParams.setPageDto(params.getPageDto());
        queryParams.setQuery(params.getQuery());
        int count = this.logicAutoRemarkFriendConfigMapper.countList(queryParams);
        if (count <= 0) {
            log.info("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u67e5\u8be2\u7ed3\u679c");
            return this.emptyAutoRemarkFriendListResp();
        }
        List configs = this.logicAutoRemarkFriendConfigMapper.queryList(queryParams);
        ArrayList list = Lists.newArrayListWithCapacity((int)configs.size());
        for (AutoRemarkFriendConfigDto dto : configs) {
            list.add(this.newWechatAutoRemarkFriendDto(dto));
        }
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(count));
            params.getPageDto().setCurPageCount(Integer.valueOf(configs.size()));
        }
        AutoRemarkFriendListResp result = new AutoRemarkFriendListResp();
        result.setList((List)list);
        result.setPageDto(params.getPageDto());
        return result;
    }

    private AutoRemarkFriendListResp emptyAutoRemarkFriendListResp() {
        AutoRemarkFriendListResp resp = new AutoRemarkFriendListResp();
        resp.setList(Collections.emptyList());
        resp.setPageDto(new PageDto());
        return resp;
    }

    public AutoRemarkFriendDetailRespDto detail(AutoRemarkFriendDetailReq params) {
        log.info("get WechatAutoRemarkFriend detail with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"businessCustomerId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getWechatId()}), (Object)"wechatId\u4e0d\u53ef\u4e3a\u7a7a");
        LogicAutoRemarkFriendConfig config = this.logicAutoRemarkFriendConfigMapper.queryByWechatId(params.getBusinessCustomerId(), params.getWechatId());
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"\u8be5\u5fae\u4fe1\u53f7\u6ca1\u6709\u53ef\u7528\u7684\u914d\u7f6e\uff0c\u8bf7\u5148\u521b\u5efa");
        WechatAccount account = this.wechatAccountMapper.queryByWechatId(config.getWechatId());
        Preconditions.checkArgument((account != null ? 1 : 0) != 0, (Object)"\u8be5\u5fae\u4fe1\u53f7\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        User user = (User)this.userMapper.selectByPrimaryKey((Object)config.getUpdateBy());
        return this.newWechatAutoRemarkFriendDto(config, account, user);
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean toggle(AutoRemarkFriendToggleReq params) {
        log.info("toggle WechatAutoRemarkFriend with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getWechatId()}), (Object)"wechatId\u4e0d\u53ef\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getEnabled() != null ? 1 : 0) != 0, (Object)"enabled\u4e0d\u53ef\u4e3a\u7a7a");
        LogicAutoRemarkFriendConfig config = this.logicAutoRemarkFriendConfigMapper.queryByWechatId(params.getBusinessCustomerId(), params.getWechatId());
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"\u8be5\u5fae\u4fe1\u53f7\u6ca1\u6709\u53ef\u7528\u7684\u914d\u7f6e\uff0c\u8bf7\u5148\u521b\u5efa");
        config.setEnabled(Integer.valueOf(params.getEnabled() != false ? 1 : 0));
        config.setUpdateBy(params.getOperatorId());
        config.setUpdateTime(new Date());
        this.logicAutoRemarkFriendConfigMapper.updateByPrimaryKeySelective((Object)config);
        return params.getEnabled();
    }

    private AutoRemarkFriendDetailRespDto newWechatAutoRemarkFriendDto(LogicAutoRemarkFriendConfig config, WechatAccount account, User user) {
        WechatResp wechat = new WechatResp();
        wechat.setId(config.getWechatId());
        if (account != null) {
            wechat.setAlias(account.getAlias());
            wechat.setNickname(account.getNickName());
        }
        AutoRemarkFriendResp content = new AutoRemarkFriendResp();
        content.setEnabled(Boolean.valueOf(config.getEnabled() != 0));
        content.setFormat(config.getFormat());
        content.setId(config.getId());
        content.setStartTime(config.getStartTime());
        content.setEndTime(config.getEndTime());
        OperatorResp updator = new OperatorResp();
        updator.setId(config.getUpdateBy());
        updator.setOperateTime(config.getUpdateTime());
        if (user != null) {
            updator.setNickname(user.getNickName());
            updator.setUsername(user.getName());
        }
        AutoRemarkFriendDetailRespDto result = new AutoRemarkFriendDetailRespDto();
        result.setWechat(wechat);
        result.setContent(content);
        result.setUpdator(updator);
        return result;
    }

    private AutoRemarkFriendDetailRespDto newWechatAutoRemarkFriendDto(AutoRemarkFriendConfigDto config) {
        WechatResp wechat = new WechatResp();
        wechat.setId(config.getWechatId());
        wechat.setAlias(config.getWechatAlias());
        wechat.setNickname(config.getWechatNickname());
        AutoRemarkFriendResp content = null;
        if (config.getId() != null) {
            content = new AutoRemarkFriendResp();
            content.setId(config.getId());
            content.setEnabled(Boolean.valueOf(config.getEnabled() != 0));
            content.setFormat(config.getFormat());
            content.setStartTime(config.getStartTime());
            content.setEndTime(config.getEndTime());
        }
        OperatorResp updator = null;
        if (config.getUpdateBy() != null) {
            updator = new OperatorResp();
            updator.setId(config.getUpdateBy());
            updator.setOperateTime(config.getUpdateTime());
            updator.setNickname(config.getUserNickname());
            updator.setUsername(config.getUsername());
        }
        AutoRemarkFriendDetailRespDto result = new AutoRemarkFriendDetailRespDto();
        result.setWechat(wechat);
        result.setContent(content);
        result.setUpdator(updator);
        return result;
    }
}

