/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.reply.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.skynet.logic.dal.reply.dto.ExistGroupKeywordDto;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWord;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWechatRoomMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWordMapper;
import com.kuaike.skynet.logic.service.cache.GroupKeywordCacheService;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.reply.BatchGroupKeywordReplyService;
import com.kuaike.skynet.logic.service.reply.CommonReplyService;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyWordDto;
import com.kuaike.skynet.logic.service.reply.dto.req.AutoReplyReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.JoinGroupReplyListReqDto;
import com.kuaike.skynet.logic.service.reply.dto.req.ReplyIdReqDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListResp;
import com.kuaike.skynet.logic.service.reply.dto.resp.ReplyListRespDto;
import com.kuaike.skynet.logic.service.reply.dto.resp.RoomToRobotDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;
import com.kuaike.skynet.logic.service.reply.enums.KeywordMatchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BatchGroupKeywordReplyServiceImpl
implements BatchGroupKeywordReplyService {
    private static final Logger log = LoggerFactory.getLogger(BatchGroupKeywordReplyServiceImpl.class);
    @Autowired
    private GroupKeywordCacheService groupKeywordCacheService;
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;
    @Autowired
    private CommonReplyService commonReplyService;
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicAutoReplyWordMapper logicAutoReplyWordMapper;
    @Autowired
    private LogicAutoReplyWechatRoomMapper logicAutoReplyWechatRoomMapper;

    private void validate(AutoReplyReqDto params) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getTitle()), (Object)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getChatRooms()), (Object)"\u6240\u9009\u7fa4\u4e0d\u80fd\u4e3a\u7a7a");
        Set<String> chatRoomIds = this.commonReplyService.getChatRoomIds(params.getChatRooms());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(chatRoomIds), (Object)"\u6240\u9009\u7fa4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)this.commonReplyService.validateChatRoomIds(params.getChatRooms()), (Object)"\u6240\u9009\u7fa4\u4e0d\u53ef\u91cd\u590d");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getKeyWordList()), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet keyWordSet = Sets.newHashSet();
        params.getKeyWordList().forEach(keyWord -> {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)keyWord.getRequest()), (Object)"\u95ee\u9898\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)keyWord.getReplyMessage()), (Object)"\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)keyWord.getWord()), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((keyWord.getType() != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u5339\u914d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            if (keyWord.getType().intValue() == KeywordMatchType.ACCURATE.getValue()) {
                Preconditions.checkArgument((boolean)keyWordSet.add(keyWord.getWord()), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u91cd\u590d");
            } else {
                this.commonReplyService.validateFuzzyKeyword(keyWord.getWord());
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(AutoReplyReqDto params) {
        log.info("Add batch group keyword reply with params={}, operatorId={}", (Object)JacksonUtil.obj2Str((Object)params), (Object)params.getOperatorId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        this.validate(params);
        LogicAutoReply reply = this.newLogicAutoReply(params);
        reply.setNodeId(params.getNodeId());
        reply.setMerchantId(params.getBusinessCustomerId());
        reply.setCreateBy(params.getOperatorId());
        this.logicAutoReplyMapper.insertSelective((Object)reply);
        params.setId(reply.getId());
        this.commonReplyService.addOrModReplyChatRoom(params.getChatRooms(), reply.getId(), params.getOperatorId(), null);
        this.insertKeyWords(params);
        this.clear(params);
        this.groupKeywordCacheService.newVersion();
    }

    @Transactional(rollbackFor={Exception.class})
    public void modify(AutoReplyReqDto params) {
        log.info("Modify batch group keyword reply with params={}, operatorId={}", (Object)JacksonUtil.obj2Str((Object)params), (Object)params.getOperatorId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        this.validate(params);
        LogicAutoReply reply = this.newLogicAutoReply(params);
        reply.setId(params.getId());
        this.logicAutoReplyMapper.updateByPrimaryKeySelective((Object)reply);
        this.commonReplyService.addOrModReplyChatRoom(params.getChatRooms(), params.getId(), params.getOperatorId(), null);
        this.insertKeyWords(params);
        this.clear(params);
        this.groupKeywordCacheService.newVersion();
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(ReplyIdReqDto params) {
        log.info("Delete batch group keyword reply with params={}, operatorId={}", (Object)params, (Object)params.getOperatorId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u56de\u590did\u4e0d\u80fd\u4e3a\u7a7a");
        List<Long> autoReplyIds = Collections.singletonList(params.getId());
        Long operatorId = params.getOperatorId();
        Date updateTime = new Date();
        this.logicAutoReplyMapper.logicDeleteByPrimaryKeys(autoReplyIds, operatorId, updateTime);
        this.logicAutoReplyWordMapper.logicDeleteByAutoReplyIds(autoReplyIds, operatorId, updateTime);
        this.logicAutoReplyWechatRoomMapper.logicDeleteByAutoReplyIds(autoReplyIds, operatorId, updateTime);
        this.groupKeywordCacheService.newVersion();
    }

    public ReplyListResp detail(ReplyIdReqDto params) {
        log.info("Query batch group keyword reply detail with params={}, operatorId={}", (Object)params, (Object)params.getOperatorId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        LogicAutoReply existReply = (LogicAutoReply)this.logicAutoReplyMapper.selectByPrimaryKey((Object)params.getId());
        List chatRoomList = this.logicAutoReplyWechatRoomMapper.queryByReplyIds(Collections.singletonList(existReply.getId()));
        List chatRooms = chatRoomList.stream().map(it -> new RoomToRobotDto(it.getWechatRoomName(), it.getWechatId())).collect(Collectors.toList());
        List wordList = this.logicAutoReplyWordMapper.selectByAutoReplyIds(Collections.singletonList(params.getId()));
        ArrayList messageDtoList = Lists.newArrayList();
        ArrayList autoReplyWordDtoList = null;
        if (CollectionUtils.isNotEmpty((Collection)wordList)) {
            autoReplyWordDtoList = Lists.newArrayList();
            for (LogicAutoReplyWord word : wordList) {
                AutoReplyWordDto wordDto = new AutoReplyWordDto();
                wordDto.setWord(word.getKeyWord());
                wordDto.setRequest(word.getRequest());
                wordDto.setType(word.getType());
                List<AutoReplyMessageDto> replyMessage = this.replyMessageDtoService.parseAutoReplyMessageDtoList(word.getMessage());
                wordDto.setReplyMessage(replyMessage);
                messageDtoList.addAll(replyMessage);
                autoReplyWordDtoList.add(wordDto);
            }
        }
        this.replyMessageDtoService.fillAutoReplyMessageDtoList(messageDtoList);
        ReplyListResp resp = (ReplyListResp)BeanUtil.convert((Object)existReply, ReplyListResp.class, (String[])new String[0]);
        resp.setEnabled(Integer.valueOf(existReply.getEnabled() == null ? 0 : existReply.getEnabled()));
        resp.setChatRooms(chatRooms);
        resp.setKeyWordList((List)autoReplyWordDtoList);
        return resp;
    }

    public ReplyListRespDto list(JoinGroupReplyListReqDto params) {
        return this.commonReplyService.list(params);
    }

    public boolean check(AutoReplyReqDto params) {
        log.info("Check batch group keyword reply with params={}, operatorId={}", (Object)JacksonUtil.obj2Str((Object)params), (Object)params.getOperatorId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBusinessCustomerId() != null ? 1 : 0) != 0, (Object)"merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        Set<String> chatRoomIds = this.commonReplyService.getChatRoomIds(params.getChatRooms());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(chatRoomIds), (Object)"\u6240\u9009\u7fa4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)params.getKeyWordList()), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet keyWordSet = Sets.newHashSet();
        params.getKeyWordList().forEach(keyWord -> {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)keyWord.getWord()), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((keyWord.getType() != null ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u5339\u914d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            if (keyWord.getType().intValue() == KeywordMatchType.ACCURATE.getValue()) {
                Preconditions.checkArgument((boolean)keyWordSet.add(keyWord.getWord()), (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u91cd\u590d");
            } else {
                this.commonReplyService.validateFuzzyKeyword(keyWord.getWord());
            }
        });
        boolean flag = false;
        ArrayList relationTypes = Lists.newArrayList((Object[])new Integer[]{AutoReplyRelationType.CHAT_ROOM_GROUP.getValue(), AutoReplyRelationType.CHAT_ROOM.getValue()});
        List keyWordDtoList = params.getKeyWordList();
        Long replyId = params.getId();
        for (AutoReplyWordDto keyword : keyWordDtoList) {
            List existKeywords;
            if (keyword.getType().intValue() != KeywordMatchType.ACCURATE.getValue() || !CollectionUtils.isNotEmpty((Collection)(existKeywords = this.logicAutoReplyWechatRoomMapper.queryExistGroupKeywords(keyword.getWord(), chatRoomIds, replyId, Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()), (Collection)relationTypes, params.getBusinessCustomerId())))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private LogicAutoReply newLogicAutoReply(AutoReplyReqDto replyDto) {
        LogicAutoReply reply = new LogicAutoReply();
        reply.setReplyType(Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()));
        reply.setRelationType(Integer.valueOf(AutoReplyRelationType.CHAT_ROOM_GROUP.getValue()));
        reply.setTitle(replyDto.getTitle());
        reply.setRequest("");
        reply.setMessage("");
        reply.setDigest("");
        reply.setUpdateBy(replyDto.getOperatorId());
        reply.setUpdateTime(new Date());
        return reply;
    }

    private LogicAutoReplyWord newLogicAutoReplyWord(AutoReplyReqDto replyDto, AutoReplyWordDto wordDto) {
        LogicAutoReplyWord word = new LogicAutoReplyWord();
        word.setAutoReplyId(replyDto.getId());
        word.setMerchantId(replyDto.getBusinessCustomerId());
        word.setNodeId(replyDto.getNodeId());
        word.setCreateBy(replyDto.getOperatorId());
        word.setUpdateBy(replyDto.getOperatorId());
        word.setType(wordDto.getType());
        word.setKeyWord(wordDto.getWord());
        word.setRequest(wordDto.getRequest());
        String message = this.replyMessageDtoService.toReplyMessageStr(wordDto.getReplyMessage());
        word.setMessage(message);
        String digest = SHA1Utils.digest((String)message);
        word.setDigest(digest);
        return word;
    }

    private List<LogicAutoReplyWord> insertKeyWords(AutoReplyReqDto params) {
        ArrayList list = Lists.newArrayList();
        List dtoList = params.getKeyWordList();
        for (AutoReplyWordDto wordDto : dtoList) {
            LogicAutoReplyWord word = this.newLogicAutoReplyWord(params, wordDto);
            list.add(word);
        }
        this.logicAutoReplyWordMapper.logicDeleteByAutoReplyIds(Collections.singleton(params.getId()), params.getOperatorId(), new Date());
        this.logicAutoReplyWordMapper.batchInsert((List)list);
        return list;
    }

    private void clear(AutoReplyReqDto params) {
        Set<String> selectedChatRoomIds = this.commonReplyService.getChatRoomIds(params.getChatRooms());
        Long operatorId = params.getOperatorId();
        Long merchantId = params.getBusinessCustomerId();
        Long replyId = params.getId();
        ArrayList relationTypes = Lists.newArrayList((Object[])new Integer[]{AutoReplyRelationType.CHAT_ROOM_GROUP.getValue(), AutoReplyRelationType.CHAT_ROOM.getValue()});
        List keyWordDtoList = params.getKeyWordList();
        for (AutoReplyWordDto keyword : keyWordDtoList) {
            List existKeywords;
            if (keyword.getType().intValue() != KeywordMatchType.ACCURATE.getValue() || CollectionUtils.isEmpty((Collection)(existKeywords = this.logicAutoReplyWechatRoomMapper.queryExistGroupKeywords(keyword.getWord(), selectedChatRoomIds, replyId, Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()), (Collection)relationTypes, merchantId)))) continue;
            this.clear(existKeywords, operatorId);
        }
    }

    private void clear(List<ExistGroupKeywordDto> existKeywords, Long operatorId) {
        Date now = new Date();
        Set existRoomIds = existKeywords.stream().map(it -> it.getAutoReplyRoomId()).collect(Collectors.toSet());
        this.logicAutoReplyWechatRoomMapper.logicDeleteByPrimaryKeys(existRoomIds, operatorId, now);
        Set existReplyIds = existKeywords.stream().map(it -> it.getAutoReplyId()).collect(Collectors.toSet());
        Map existRoomCountMap = this.logicAutoReplyWechatRoomMapper.queryExistChatRoomCount(existReplyIds);
        HashSet toDel = Sets.newHashSet();
        for (Long id : existReplyIds) {
            Integer count = existRoomCountMap.getOrDefault(id, 0);
            if (count != 0) continue;
            toDel.add(id);
        }
        if (CollectionUtils.isNotEmpty((Collection)toDel)) {
            this.logicAutoReplyMapper.logicDeleteByPrimaryKeys((Collection)toDel, operatorId, now);
            this.logicAutoReplyWordMapper.logicDeleteByAutoReplyIds((Collection)toDel, operatorId, now);
        }
    }
}

