/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.cache.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.skynet.logic.dal.label.entity.LogicAutoWechatLabel;
import com.kuaike.skynet.logic.dal.label.entity.LogicAutoWechatLabelWord;
import com.kuaike.skynet.logic.dal.label.entity.LogicAutoWechatLabelWordCriteria;
import com.kuaike.skynet.logic.dal.label.mapper.LogicAutoWechatLabelMapper;
import com.kuaike.skynet.logic.dal.label.mapper.LogicAutoWechatLabelWordMapper;
import com.kuaike.skynet.logic.service.cache.FriendKeywordTagLabelCacheService;
import com.kuaike.skynet.logic.service.cache.dto.CachedTagLabelData;
import com.kuaike.skynet.logic.service.cache.dto.MatchedResult;
import com.kuaike.skynet.logic.service.common.VersionedCache;
import com.kuaike.skynet.logic.service.reply.dto.label.LabelItemDto;
import com.kuaike.skynet.logic.service.reply.enums.FriendMsgReplyType;
import com.kuaike.skynet.logic.service.reply.enums.KeywordMatchType;
import com.kuaike.skynet.logic.service.util.KeywordUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class FriendKeywordTagLabelCacheServiceImpl
extends VersionedCache
implements FriendKeywordTagLabelCacheService {
    private static final Logger log = LoggerFactory.getLogger(FriendKeywordTagLabelCacheServiceImpl.class);
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.friendTagLabelVersion:friend_tag_label_version}")
    private String versionRedisKey;
    @Autowired
    private LogicAutoWechatLabelWordMapper logicAutoWechatLabelWordMapper;
    @Autowired
    private LogicAutoWechatLabelMapper logicAutoWechatLabelMapper;
    protected Map<Long, Map<String, CachedTagLabelData>> cachedData = Maps.newConcurrentMap();

    @Override
    public void newVersion() {
        super.reset();
    }

    @Scheduled(fixedRate=5000L)
    public void refresh() {
        super.refresh();
    }

    protected String getVersionRedisKey() {
        return this.versionRedisKey;
    }

    protected Long getExpiredInSecond() {
        return 300L;
    }

    @Override
    public Map<String, CachedTagLabelData> getCache(Long businessCustomerId) {
        if (businessCustomerId == null) {
            return null;
        }
        return this.cachedData.get(businessCustomerId);
    }

    @Override
    public CachedTagLabelData getCache(Long businessCustomerId, String key) {
        if (businessCustomerId == null || key == null) {
            return null;
        }
        Map<String, CachedTagLabelData> cache = this.cachedData.get(businessCustomerId);
        if (cache != null) {
            return cache.get(key);
        }
        return null;
    }

    @Override
    public MatchedResult match(Long businessCustomerId, String key, String message) {
        log.info("Matching {} keyword with businessCustomerId:{}, key:{}, text:{}", new Object[]{this.getClass().getSimpleName(), businessCustomerId, key, message});
        CachedTagLabelData cache = this.getCache(businessCustomerId, key);
        if (cache == null) {
            log.info("Cache not found for {} businessCustomerId:{}, key:{}", new Object[]{this.getClass().getSimpleName(), businessCustomerId, key});
            return MatchedResult.EMPTY;
        }
        return cache.match(message);
    }

    protected void initialize() {
        ConcurrentMap merchantDataMap = Maps.newConcurrentMap();
        LogicAutoWechatLabelWordCriteria criteria = new LogicAutoWechatLabelWordCriteria();
        criteria.createCriteria().andIsDeletedEqualTo(Integer.valueOf(0));
        List wordList = this.logicAutoWechatLabelWordMapper.selectByExample((Object)criteria);
        LogicAutoWechatLabel example = new LogicAutoWechatLabel();
        example.setIsDeleted(Integer.valueOf(0));
        Map bizIdWechatMap = this.logicAutoWechatLabelMapper.select((Object)example).stream().filter(t -> KeywordUtil.strToIdsStr((String)t.getRtypesStr()).stream().collect(Collectors.toSet()).contains(FriendMsgReplyType.KEYWORD.getValue() + "")).collect(Collectors.groupingBy(LogicAutoWechatLabel::getMerchantId, Collectors.toMap(LogicAutoWechatLabel::getWechatId, Function.identity(), (u, v) -> v)));
        for (LogicAutoWechatLabelWord it : wordList) {
            Long businessCustomerId = it.getMerchantId();
            Map wechatIdMap = bizIdWechatMap.getOrDefault(businessCustomerId, Maps.newHashMap());
            LogicAutoWechatLabel wechatLabel = (LogicAutoWechatLabel)wechatIdMap.get(it.getWechatId());
            if (Objects.isNull(wechatLabel)) {
                log.warn("not config wechatId keyword:{}", (Object)JSON.toJSONString((Object)it));
                continue;
            }
            Map cachedReplyData = merchantDataMap.computeIfAbsent(businessCustomerId, t -> Maps.newHashMap());
            merchantDataMap.put(businessCustomerId, cachedReplyData);
            List labelItemDtos = JSONArray.parseArray((String)wechatLabel.getLabelIds(), LabelItemDto.class);
            if (CollectionUtils.isEmpty((Collection)labelItemDtos)) continue;
            HashMap accurateMatch = Maps.newHashMap();
            HashMap fuzzyMatchedMap = Maps.newHashMap();
            HashSet dict = Sets.newHashSet();
            HashMap<Long, Set<LabelItemDto>> idToMap = new HashMap<Long, Set<LabelItemDto>>();
            idToMap.put(wechatLabel.getId(), labelItemDtos.stream().collect(Collectors.toSet()));
            String keyword = it.getKeyWord();
            Integer type = it.getType();
            if (type.intValue() == KeywordMatchType.ACCURATE.getValue()) {
                for (String w : KeywordUtil.strToIdsStr((String)keyword)) {
                    accurateMatch.put(w, wechatLabel.getId());
                }
            } else {
                for (String w : KeywordUtil.strToIdsStr((String)keyword)) {
                    dict.add(w);
                    fuzzyMatchedMap.put(w, wechatLabel.getId());
                }
            }
            String wechatId = wechatLabel.getWechatId();
            CachedTagLabelData cache = cachedReplyData.computeIfAbsent(wechatId, t -> new CachedTagLabelData());
            cachedReplyData.put(wechatId, cache);
            cache.merge(accurateMatch, dict, fuzzyMatchedMap, idToMap);
        }
        this.cachedData = merchantDataMap;
    }
}

