/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.cache.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWord;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWordMapper;
import com.kuaike.skynet.logic.service.cache.FissionKeywordCacheService;
import com.kuaike.skynet.logic.service.cache.dto.CachedReplyData;
import com.kuaike.skynet.logic.service.cache.dto.CachedReplyMsg;
import com.kuaike.skynet.logic.service.cache.impl.AbstractKeywordCache;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;
import com.kuaike.skynet.logic.service.reply.enums.KeywordMatchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class FissionKeywordCacheServiceImpl
extends AbstractKeywordCache<Long>
implements FissionKeywordCacheService {
    private static final Logger log = LoggerFactory.getLogger(FissionKeywordCacheServiceImpl.class);
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicAutoReplyWordMapper logicAutoReplyWordMapper;
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.fissionReplyVersion:fission_reply_version}")
    private String versionRedisKey;

    @Override
    public void newVersion() {
        super.reset();
    }

    @Scheduled(fixedRate=5000L)
    public void refresh() {
        super.refresh();
    }

    protected String getVersionRedisKey() {
        return this.versionRedisKey;
    }

    protected Long getExpiredInSecond() {
        return 300L;
    }

    protected void initialize() {
        ConcurrentMap cachedReplyData = Maps.newConcurrentMap();
        LogicAutoReply example = new LogicAutoReply();
        example.setReplyType(Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()));
        example.setRelationType(Integer.valueOf(AutoReplyRelationType.FISSION_PLAN.getValue()));
        example.setEnabled(Integer.valueOf(1));
        example.setIsDeleted(Integer.valueOf(0));
        List replyList = this.logicAutoReplyMapper.select((Object)example);
        List ids = replyList.stream().map(it -> it.getId()).collect(Collectors.toList());
        List wordList = this.logicAutoReplyWordMapper.selectByAutoReplyIds(ids);
        Map<Long, List<LogicAutoReplyWord>> wordMap = wordList.stream().collect(Collectors.groupingBy(LogicAutoReplyWord::getAutoReplyId));
        ArrayList uselessIds = Lists.newArrayList();
        for (LogicAutoReply it2 : replyList) {
            Long id = it2.getId();
            List<LogicAutoReplyWord> replyWordList = wordMap.get(id);
            if (CollectionUtils.isEmpty(replyWordList)) {
                uselessIds.add(id);
                continue;
            }
            Long marketPlanId = it2.getMarketPlanId();
            HashMap accurateMatch = Maps.newHashMap();
            HashSet dict = Sets.newHashSet();
            HashMap wordToReplyIds = Maps.newHashMap();
            HashMap<String, CachedReplyMsg> idToReplyMap = new HashMap<String, CachedReplyMsg>();
            CachedReplyMsg reply = new CachedReplyMsg();
            reply.setReplyId(id);
            reply.setDesc(it2.getRequest());
            reply.setMsg(it2.getMessage());
            reply.setUpdateTime(it2.getUpdateTime().getTime());
            if (StringUtils.isNotBlank((CharSequence)it2.getDigest())) {
                reply.setDigest(it2.getDigest());
            } else {
                reply.setDigest(SHA1Utils.digest((String)it2.getMessage()));
            }
            idToReplyMap.put(reply.getId(), reply);
            for (LogicAutoReplyWord replyWord : replyWordList) {
                String[] words;
                String keyword = replyWord.getKeyWord();
                Integer type = replyWord.getType();
                if (type.intValue() == KeywordMatchType.ACCURATE.getValue()) {
                    accurateMatch.put(keyword, reply.getId());
                    continue;
                }
                for (String w : words = StringUtils.split((String)keyword, (String)",")) {
                    dict.add(w);
                    ArrayList<String> list = (ArrayList<String>)wordToReplyIds.get(w);
                    if (list == null) {
                        list = new ArrayList<String>();
                        wordToReplyIds.put(w, list);
                    }
                    list.add(reply.getId());
                }
            }
            CachedReplyData cache = (CachedReplyData)cachedReplyData.get(marketPlanId);
            if (cache == null) {
                cache = new CachedReplyData();
                cachedReplyData.put(marketPlanId, cache);
            }
            cache.merge(accurateMatch, dict, wordToReplyIds, idToReplyMap);
        }
        this.cachedReplyData = cachedReplyData;
        if (CollectionUtils.isNotEmpty((Collection)uselessIds)) {
            log.warn("Useless reply ids={}", (Object)uselessIds);
        }
    }
}

