/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.cache.impl;

import com.google.common.collect.Maps;
import com.kuaike.skynet.logic.service.cache.KeywordCache;
import com.kuaike.skynet.logic.service.cache.dto.CachedReplyData;
import com.kuaike.skynet.logic.service.cache.dto.MatchedResult;
import com.kuaike.skynet.logic.service.common.VersionedCache;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeywordCache<T>
extends VersionedCache
implements KeywordCache<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractKeywordCache.class);
    protected Map<T, CachedReplyData> cachedReplyData = Maps.newConcurrentMap();

    @Override
    public Map<T, CachedReplyData> getCache() {
        return this.cachedReplyData;
    }

    @Override
    public CachedReplyData getCache(T key) {
        return this.cachedReplyData.get(key);
    }

    @Override
    public MatchedResult match(T key, String message) {
        log.info("Matching {} keyword with key:{}, text:{}", new Object[]{this.getClass().getSimpleName(), key, message});
        CachedReplyData cache = this.cachedReplyData.get(key);
        if (cache == null) {
            log.info("Cache not found for {} key:{}", (Object)this.getClass().getSimpleName(), key);
            return MatchedResult.EMPTY;
        }
        return cache.match(message);
    }
}

