/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.cache.dto;

import com.google.common.collect.Maps;
import com.kuaike.skynet.logic.service.cache.dto.MatchedResult;
import com.kuaike.skynet.logic.service.reply.dto.label.LabelItemDto;
import com.kuaike.skynet.logic.wechat.utils.WordTree;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CachedTagLabelData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Long> fuzzyMatched = Maps.newConcurrentMap();
    private Map<String, Long> accurateMatched = Maps.newConcurrentMap();
    private Map<Long, Set<LabelItemDto>> idToMap = Maps.newConcurrentMap();
    private WordTree fuzzyDict = new WordTree();

    public synchronized void clear() {
        this.fuzzyMatched = Maps.newConcurrentMap();
        this.accurateMatched = Maps.newConcurrentMap();
        this.idToMap = Maps.newConcurrentMap();
        this.fuzzyDict = new WordTree();
    }

    public void merge(Map<String, Long> accurateMatchedMap, Set<String> dict, Map<String, Long> fuzzyMatchedMap, Map<Long, Set<LabelItemDto>> idToMap) {
        this.accurateMatched.putAll(accurateMatchedMap);
        this.fuzzyMatched.putAll(fuzzyMatchedMap);
        this.fuzzyDict.addWords(dict);
        this.idToMap.putAll(idToMap);
    }

    public MatchedResult match(String message) {
        Set<LabelItemDto> r;
        MatchedResult result = new MatchedResult();
        Long matchId = this.accurateMatched.get(message);
        if (matchId != null && (r = this.idToMap.get(matchId)) != null) {
            result.add(message, r);
            return result;
        }
        if (!this.fuzzyDict.isContaintWord(message)) {
            return MatchedResult.EMPTY;
        }
        List words = this.fuzzyDict.getMatchedWords(message);
        for (String w : words) {
            Set<LabelItemDto> r2;
            Long matched = this.fuzzyMatched.get(w);
            if (!Objects.nonNull(matched) || !Objects.nonNull(r2 = this.idToMap.get(matched))) continue;
            result.add(w, r2);
        }
        return result;
    }

    public Map<String, Long> getFuzzyMatched() {
        return this.fuzzyMatched;
    }

    public Map<String, Long> getAccurateMatched() {
        return this.accurateMatched;
    }

    public Map<Long, Set<LabelItemDto>> getIdToMap() {
        return this.idToMap;
    }

    public WordTree getFuzzyDict() {
        return this.fuzzyDict;
    }

    public void setFuzzyMatched(Map<String, Long> fuzzyMatched) {
        this.fuzzyMatched = fuzzyMatched;
    }

    public void setAccurateMatched(Map<String, Long> accurateMatched) {
        this.accurateMatched = accurateMatched;
    }

    public void setIdToMap(Map<Long, Set<LabelItemDto>> idToMap) {
        this.idToMap = idToMap;
    }

    public void setFuzzyDict(WordTree fuzzyDict) {
        this.fuzzyDict = fuzzyDict;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachedTagLabelData)) {
            return false;
        }
        CachedTagLabelData other = (CachedTagLabelData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Long> this$fuzzyMatched = this.getFuzzyMatched();
        Map<String, Long> other$fuzzyMatched = other.getFuzzyMatched();
        if (this$fuzzyMatched == null ? other$fuzzyMatched != null : !((Object)this$fuzzyMatched).equals(other$fuzzyMatched)) {
            return false;
        }
        Map<String, Long> this$accurateMatched = this.getAccurateMatched();
        Map<String, Long> other$accurateMatched = other.getAccurateMatched();
        if (this$accurateMatched == null ? other$accurateMatched != null : !((Object)this$accurateMatched).equals(other$accurateMatched)) {
            return false;
        }
        Map<Long, Set<LabelItemDto>> this$idToMap = this.getIdToMap();
        Map<Long, Set<LabelItemDto>> other$idToMap = other.getIdToMap();
        if (this$idToMap == null ? other$idToMap != null : !((Object)this$idToMap).equals(other$idToMap)) {
            return false;
        }
        WordTree this$fuzzyDict = this.getFuzzyDict();
        WordTree other$fuzzyDict = other.getFuzzyDict();
        return !(this$fuzzyDict == null ? other$fuzzyDict != null : !this$fuzzyDict.equals(other$fuzzyDict));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CachedTagLabelData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Long> $fuzzyMatched = this.getFuzzyMatched();
        result = result * 59 + ($fuzzyMatched == null ? 43 : ((Object)$fuzzyMatched).hashCode());
        Map<String, Long> $accurateMatched = this.getAccurateMatched();
        result = result * 59 + ($accurateMatched == null ? 43 : ((Object)$accurateMatched).hashCode());
        Map<Long, Set<LabelItemDto>> $idToMap = this.getIdToMap();
        result = result * 59 + ($idToMap == null ? 43 : ((Object)$idToMap).hashCode());
        WordTree $fuzzyDict = this.getFuzzyDict();
        result = result * 59 + ($fuzzyDict == null ? 43 : $fuzzyDict.hashCode());
        return result;
    }

    public String toString() {
        return "CachedTagLabelData(fuzzyMatched=" + this.getFuzzyMatched() + ", accurateMatched=" + this.getAccurateMatched() + ", idToMap=" + this.getIdToMap() + ", fuzzyDict=" + this.getFuzzyDict() + ")";
    }
}

