/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.message.impl;

import com.google.common.collect.Range;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoom;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoomCriteria;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatAliasInfoMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomRelationMapper;
import com.kuaike.skynet.logic.service.message.WechatMsgService;
import com.kuaike.skynet.logic.service.message.dto.GroupSendConfigDto;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class WechatMsgServiceImpl
implements WechatMsgService {
    private static final Logger log = LoggerFactory.getLogger(WechatMsgServiceImpl.class);
    @Autowired
    private WechatChatRoomMapper wechatChatRoomMapper;
    @Autowired
    private WechatChatRoomRelationMapper wechatChatRoomRelationMapper;
    @Autowired
    private WechatAliasInfoMapper wechatAliasInfoMapper;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private RedisTemplate<String, String> redisTemplate2;
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.chatRoomOwnerFormat}")
    private String chatRoomOwnerFormat;
    @Value(value="${spring.redis.key.manager.prefix}${spring.redis.key.manager.wechat.startServiceTime}")
    private String wechatStartServiceTime;
    @Value(value="${spring.redis.key.manager.prefix}${spring.redis.key.manager.wechat.endServiceTime}")
    private String wechatEndServiceTime;
    @Value(value="${spring.redis.key.manager.prefix}${spring.redis.key.manager.wechat.groupSendDailyCount}")
    private String wechatGroupSendDailyCount;
    @Value(value="${spring.redis.key.manager.prefix}${spring.redis.key.manager.wechat.chatRoomPoolMaxSize}")
    private String wechatChatRoomPoolMaxSize;
    @Value(value="${start.service.time}")
    private String defaultStartServiceTimeStr;
    @Value(value="${end.service.time}")
    private String defaultEndServiceTimeStr;
    @Value(value="${daily.group.send.count}")
    private Integer defaultDailyGroupSendCount;
    @Value(value="${max.chatRoom.pool.size}")
    private Integer defaultChatRoomPoolMaxSize;

    @Override
    public GroupSendConfigDto getConfig() {
        String startServiceTime = this.getCachedString(this.wechatStartServiceTime, this.defaultStartServiceTimeStr);
        String endServiceTime = this.getCachedString(this.wechatEndServiceTime, this.defaultEndServiceTimeStr);
        Integer groupSendDailyCount = this.getCachedInteger(this.wechatGroupSendDailyCount, this.defaultDailyGroupSendCount);
        Integer chatRoomPoolMaxSize = this.getCachedInteger(this.wechatChatRoomPoolMaxSize, this.defaultChatRoomPoolMaxSize);
        GroupSendConfigDto groupSendConfigDto = new GroupSendConfigDto();
        groupSendConfigDto.setStartWechatServiceTime(startServiceTime);
        groupSendConfigDto.setEndWechatServiceTime(endServiceTime);
        groupSendConfigDto.setDailyMaxCount(groupSendDailyCount);
        groupSendConfigDto.setChatRoomPoolMaxSize(chatRoomPoolMaxSize);
        return groupSendConfigDto;
    }

    private String getCachedString(String key, String defVal) {
        String val = (String)this.redisTemplate2.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)val)) {
            return defVal;
        }
        return val;
    }

    private Integer getCachedInteger(String key, Integer defVal) {
        String val = (String)this.redisTemplate2.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)val)) {
            return defVal;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            log.error("Parse int failed. redisKey={}, val={}", new Object[]{key, val, e});
            return 0;
        }
    }

    @Override
    public boolean isServiceTime() {
        GroupSendConfigDto groupSendConfigDto = this.getConfig();
        log.info("serviceTime start={}, end={}", (Object)groupSendConfigDto.getStartWechatServiceTime(), (Object)groupSendConfigDto.getEndWechatServiceTime());
        return Range.closed((Comparable)((Object)groupSendConfigDto.getStartWechatServiceTime()), (Comparable)((Object)groupSendConfigDto.getEndWechatServiceTime())).contains((Comparable)((Object)DateFormatUtils.ISO_8601_EXTENDED_TIME_FORMAT.format(new Date())));
    }

    @Override
    public boolean isChatRoomOwner(WechatMessage wechatMessage) {
        String chatRoomOwner = null;
        String redisKey = this.getChatRoomOwnerRedisKey(wechatMessage.getTalkerId());
        Object redisObject = this.redisTemplate.opsForValue().get((Object)redisKey);
        if (redisObject == null) {
            WechatChatRoomCriteria criteria = new WechatChatRoomCriteria();
            criteria.createCriteria().andNameEqualTo(wechatMessage.getTalkerId()).andIsDeletedEqualTo(Boolean.valueOf(false));
            criteria.setOrderByClause("UPDATE_TIME DESC");
            List chatRoomList = this.wechatChatRoomMapper.selectByExample((Object)criteria);
            if (CollectionUtils.isNotEmpty((Collection)chatRoomList)) {
                chatRoomOwner = ((WechatChatRoom)chatRoomList.get(0)).getOwner();
            }
            if (chatRoomOwner != null) {
                this.cacheOwner(redisKey, chatRoomOwner);
            }
        } else {
            chatRoomOwner = redisObject.toString();
        }
        return wechatMessage.getWechatId().equals(chatRoomOwner);
    }

    private String getChatRoomOwnerRedisKey(String wechatRoom) {
        return String.format(this.chatRoomOwnerFormat, wechatRoom);
    }

    private void cacheOwner(String redisKey, String wechatId) {
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)wechatId, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void onBecomeOwnerEvent(String wechatId, String chatroomId, Date createTime) {
        log.info("onBecomeOwnerEvent, wechatId={}, chatroomId={}, createTime={}", new Object[]{wechatId, chatroomId, createTime});
        if (StringUtils.isBlank((CharSequence)wechatId)) {
            log.warn("wechatId is blank.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)chatroomId)) {
            log.warn("chatroomId is blank.");
            return;
        }
        if (createTime == null) {
            log.warn("createTime is null.");
            return;
        }
        String redisKey = this.getChatRoomOwnerRedisKey(chatroomId);
        WechatChatRoom chatroom = this.wechatChatRoomMapper.queryByName(chatroomId);
        if (chatroom != null) {
            log.info("current chatroomId={}, owner={}, updateTime={}", new Object[]{chatroomId, chatroom.getOwner(), chatroom.getUpdateTime()});
            Date updateTime = chatroom.getUpdateTime();
            if (createTime.after(updateTime)) {
                log.info("update chatroom owner with BecomeOwnerEvent, chatroomId={}, wechatId={}", (Object)chatroomId, (Object)wechatId);
                this.cacheOwner(redisKey, wechatId);
            } else {
                this.cacheOwner(redisKey, chatroom.getOwner());
            }
        } else {
            log.warn("Chatroom not found with chatroomId={}, while wechatId={} become owner on createTime={}", new Object[]{chatroomId, wechatId, createTime});
            this.cacheOwner(redisKey, wechatId);
            return;
        }
    }

    @Override
    public String removeAtMembers(String text, String chatroomId, List<String> atUsers) {
        if (CollectionUtils.isEmpty(atUsers)) {
            return text;
        }
        Map nickMap = this.wechatAliasInfoMapper.queryNicknameByWechatIds(atUsers);
        Map remarkMap = this.wechatChatRoomRelationMapper.queryRemarkByWechatIds(chatroomId, atUsers);
        for (String wechatId : atUsers) {
            text = this.remove(text, (String)remarkMap.get(wechatId));
            text = this.remove(text, (String)nickMap.get(wechatId));
        }
        return text;
    }

    private String remove(String text, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return text;
        }
        String atMember = "@" + value;
        int atLength = atMember.length();
        int length = text.length();
        int headIndex = text.indexOf(atMember);
        while (headIndex >= 0) {
            char c;
            int tailIndex = headIndex + atLength;
            if (tailIndex < length && ((c = text.charAt(tailIndex)) == '\u2005' || c == ' ')) {
                ++tailIndex;
            }
            StringBuffer sb = new StringBuffer();
            if (headIndex > 0) {
                sb.append(text.substring(0, headIndex));
            }
            if (tailIndex < length) {
                sb.append(text.substring(tailIndex));
            }
            text = sb.toString();
            length = text.length();
            headIndex = text.indexOf(atMember);
        }
        return text;
    }
}

