/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.message.impl;

import com.alibaba.fastjson.JSON;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.service.convert.dto.ResolvedAmrBasicInfoDto;
import com.kuaike.skynet.logic.service.message.EsMessageService;
import java.io.IOException;
import java.util.HashMap;
import org.apache.http.Header;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EsMessageServiceImpl
implements EsMessageService {
    private static final Logger log = LoggerFactory.getLogger(EsMessageServiceImpl.class);
    @Autowired
    private RestHighLevelClient client;
    @Value(value="${elasticsearch.index.wechat_message}")
    private String index;

    @Override
    public WechatMessage getByRequestId(String requestId) throws Exception {
        log.info("query wechatMessage with requestId={}", (Object)requestId);
        WechatMessage wechatMessage = null;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{"doc"}).addIds(new String[]{requestId}));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, new Header[0]);
        SearchHits hits = searchResponse.getHits();
        if (hits.getTotalHits() > 0L) {
            SearchHit hit = hits.getAt(0);
            wechatMessage = (WechatMessage)JacksonUtil.str2Obj((String)JacksonUtil.obj2Str((Object)hit.getSourceAsMap()), WechatMessage.class);
        } else {
            log.warn("WechatMessage with requestId={} is not found.", (Object)requestId);
        }
        return wechatMessage;
    }

    @Override
    public boolean updateMessage(String requestId, ResolvedAmrBasicInfoDto resolvedAmrBasicInfoDto) {
        log.info("updateMessage with requestId={}, resolvedAmrBasicInfoDto={}", (Object)requestId, (Object)JSON.toJSONString((Object)resolvedAmrBasicInfoDto));
        boolean flag = false;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{"doc"}).addIds(new String[]{requestId}));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        String realIndex = "";
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, new Header[0]);
            SearchHits hits = searchResponse.getHits();
            if (hits.getTotalHits() <= 0L) {
                return flag;
            }
            realIndex = hits.getHits()[0].getIndex();
        }
        catch (Exception e) {
            log.error("\u6839\u636erequestId\u67e5\u8be2es\u5931\u8d25\uff0crequestId={}", (Object)requestId, (Object)e);
        }
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("transcodeFileUrl", resolvedAmrBasicInfoDto.getResolvedPath());
        jsonMap.put("duration", resolvedAmrBasicInfoDto.getDuration());
        UpdateRequest updateRequest = new UpdateRequest(realIndex, "doc", requestId).doc(jsonMap);
        try {
            UpdateResponse updateResponse = this.client.update(updateRequest, new Header[0]);
            if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                flag = true;
                log.info("updateMessage success requestId:{}", (Object)requestId);
            }
        }
        catch (IOException e) {
            log.error("updateMessage failed, requestId={}, resolvedAmrBasicInfoDto={}", new Object[]{requestId, JSON.toJSONString((Object)resolvedAmrBasicInfoDto), e});
            e.printStackTrace();
        }
        return flag;
    }
}

