/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.material.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.skynet.logic.dal.material.entity.MaterialCriteria;
import com.kuaike.skynet.logic.dal.material.entity.MaterialRecycleCriteria;
import com.kuaike.skynet.logic.dal.material.mapper.MaterialMapper;
import com.kuaike.skynet.logic.dal.material.mapper.MaterialRecycleMapper;
import com.kuaike.skynet.logic.service.common.enums.MaterialTypeEnum;
import com.kuaike.skynet.logic.service.material.MaterialService;
import com.kuaike.skynet.logic.service.material.dto.MaterialDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialServiceImpl
implements MaterialService {
    private static final Logger log = LoggerFactory.getLogger(MaterialServiceImpl.class);
    @Autowired
    private MaterialMapper materialMapper;
    @Autowired
    private MaterialRecycleMapper materialRecycleMapper;

    @Override
    public List<MaterialDto> getMaterials(List<Long> ids) {
        log.info("query materials with ids={}", ids);
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        HashSet urlList = Sets.newHashSet();
        ArrayList materialDtoList = Lists.newArrayList();
        MaterialCriteria materialCriteria = new MaterialCriteria();
        materialCriteria.createCriteria().andIdIn(ids);
        List materials = this.materialMapper.selectByExample((Object)materialCriteria);
        materials.forEach(e -> {
            MaterialDto materialDto = new MaterialDto();
            materialDto.setId(e.getId());
            materialDto.setType(e.getmType());
            materialDto.setTitle(e.getTitle());
            if (MaterialTypeEnum.TXT.getValue().equals(e.getmType())) {
                materialDto.setContent(e.getContent());
            } else {
                materialDto.setContent(e.getUrl());
                if (MaterialTypeEnum.VOICE.getValue().equals(e.getmType()) || MaterialTypeEnum.VIDEO.getValue().equals(e.getmType())) {
                    urlList.add(e.getUrl());
                }
            }
            materialDtoList.add(materialDto);
        });
        MaterialRecycleCriteria materialRecycleCriteria = new MaterialRecycleCriteria();
        materialRecycleCriteria.createCriteria().andIdIn(ids);
        List materialRecycles = this.materialRecycleMapper.selectByExample((Object)materialRecycleCriteria);
        materialRecycles.forEach(e -> {
            MaterialDto materialDto = new MaterialDto();
            materialDto.setId(e.getId());
            materialDto.setType(e.getmType());
            materialDto.setTitle(e.getTitle());
            if (MaterialTypeEnum.TXT.getValue().equals(e.getmType())) {
                materialDto.setContent(e.getContent());
            } else {
                materialDto.setContent(e.getUrl());
                if (MaterialTypeEnum.VOICE.getValue().equals(e.getmType()) || MaterialTypeEnum.VIDEO.getValue().equals(e.getmType())) {
                    urlList.add(e.getUrl());
                }
            }
            materialDtoList.add(materialDto);
        });
        if (CollectionUtils.isNotEmpty((Collection)urlList)) {
            Map<String, String> urlMd5Map = urlList.stream().collect(Collectors.toMap(it -> it, url -> MD5Utils.MD5Encode8((String)url)));
            Map durationMap = this.materialMapper.getDurationByUrlMd5List(urlMd5Map.values());
            materialDtoList.forEach(e -> {
                if (MaterialTypeEnum.VOICE.getValue().equals(e.getType()) || MaterialTypeEnum.VIDEO.getValue().equals(e.getType())) {
                    String url = e.getContent();
                    String md5 = (String)urlMd5Map.get(url);
                    if (md5 == null) {
                        e.setDuration(0);
                        return;
                    }
                    Integer duration = durationMap.getOrDefault(md5, 0);
                    e.setDuration(duration);
                }
            });
        }
        return materialDtoList;
    }

    @Override
    public int getDurationByUrl(String url) {
        String urlMd5 = MD5Utils.MD5Encode8((String)url);
        Integer duration = this.materialMapper.getDurationByUrlMd5(urlMd5);
        if (duration == null) {
            log.warn("Failed getting duration by url={}, md5={}", (Object)url, (Object)urlMd5);
            return -1;
        }
        return duration;
    }
}

