/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.debug.impl;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.skynet.link.service.PushService;
import com.kuaike.skynet.link.service.common.BaseResponse;
import com.kuaike.skynet.link.service.dto.WechatStatusInfo;
import com.kuaike.skynet.logic.dal.wechat.dto.ChatRoomMember;
import com.kuaike.skynet.logic.dal.wechat.dto.WechatAccountDto;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoom;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomRelationMapper;
import com.kuaike.skynet.logic.service.cache.WechatAccountCacheService;
import com.kuaike.skynet.logic.service.debug.DebugService;
import com.kuaike.skynet.logic.service.debug.dto.DebugResult;
import com.kuaike.skynet.logic.service.debug.dto.MemPrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChatroomDebugService
implements DebugService {
    private static final Logger log = LoggerFactory.getLogger(ChatroomDebugService.class);
    private static final String NOTHING_FOUND = "Nothing found";
    private static final int MIN_SIZE = 10;
    private static final int MAX_SIZE = 30;
    private static final int PAGE = 1;
    private static final int SIZE = 10;
    private final Options options = new Options();
    @Autowired
    private WechatChatRoomMapper wechatChatRoomMapper;
    @Autowired
    private WechatChatRoomRelationMapper wechatChatRoomRelationMapper;
    @Autowired
    private WechatAccountCacheService wechatAccountCacheService;
    @Autowired
    private PushService pushService;

    public ChatroomDebugService() {
        this.options.addOption("h", "help", false, "\u5e2e\u52a9");
        this.options.addOption("p", "page", true, "\u9875\u7801 [1, +)");
        this.options.addOption("s", "size", true, "\u6bcf\u9875\u5927\u5c0f [10, 30]");
        this.options.addOption("q", "query", true, "\u6839\u636e\u7fa4\u540d\u67e5\u8be2\u5f53\u524d\u673a\u5668\u4eba\u6240\u5728\u7684\u7fa4");
        this.options.addOption("m", "member", true, "\u67e5\u8be2\u7fa4\u6210\u5458");
        this.options.addOption("g", "get", true, "\u6839\u636eID\u67e5\u8be2\u7fa4\u4fe1\u606f");
        this.options.addOption("a", "all", false, "\u5217\u51fa\u6240\u6709\u673a\u5668\u4eba\u7684\u7fa4\uff0c\u4e0d\u4ec5\u9650\u4e8e\u5f53\u524d\u673a\u5668\u4eba\u3002");
    }

    @Override
    public String getCmd() {
        return "chatroom";
    }

    @Override
    public DebugResult process(String wechatId, String talkerId, String ... args) {
        String v;
        CommandLine cmd;
        log.info("process chatroom cmd with wechatId={}, args={}", (Object)wechatId, (Object)Arrays.toString(args));
        if (args == null || args.length == 0) {
            return DebugResult.help(this.getCmd(), this.options);
        }
        int page = 1;
        int size = 10;
        boolean listAll = false;
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            return DebugResult.error(2, e.getMessage());
        }
        if (cmd.hasOption("h")) {
            return DebugResult.help(this.getCmd(), this.options);
        }
        if (cmd.hasOption("p")) {
            v = cmd.getOptionValue("p");
            try {
                page = Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                return DebugResult.error(-1, e.getMessage());
            }
            if (page < 1) {
                page = 1;
            }
        }
        if (cmd.hasOption("s")) {
            v = cmd.getOptionValue("s");
            try {
                size = Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                return DebugResult.error(-1, e.getMessage());
            }
            if (size < 10) {
                size = 10;
            }
            if (size > 30) {
                size = 30;
            }
        }
        if (cmd.hasOption("g")) {
            v = cmd.getOptionValue("g");
            return this.get(v);
        }
        if (cmd.hasOption("a")) {
            listAll = true;
        }
        if (cmd.hasOption("q")) {
            v = cmd.getOptionValue("q");
            if (listAll) {
                return this.query(null, v, page, size);
            }
            return this.query(wechatId, v, page, size);
        }
        if (cmd.hasOption("m")) {
            v = cmd.getOptionValue("m");
            if (CollectionUtils.isEmpty((Collection)cmd.getArgList())) {
                return this.member(v, null, page, size);
            }
            return this.member(v, (String)cmd.getArgList().get(0), page, size);
        }
        return DebugResult.help(this.getCmd(), this.options);
    }

    private DebugResult query(String wechatId, String query, int page, int size) {
        int count = this.wechatChatRoomMapper.countByWechatIdNickName(wechatId, query);
        if (count == 0) {
            return DebugResult.ok(NOTHING_FOUND);
        }
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(Integer.valueOf(size));
        pageDto.setPageNum(Integer.valueOf(page));
        pageDto.setCount(Integer.valueOf(count));
        List list = this.wechatChatRoomMapper.queryByWechatIdNickName(wechatId, query, pageDto);
        pageDto.setCurPageCount(Integer.valueOf(list.size()));
        MemPrintStream out = new MemPrintStream();
        out.getPrintWriter().println("\u7fa4\u673a\u5668\u4eba, ID, \u7fa4\u540d(\u4eba\u6570)");
        for (WechatChatRoom room : list) {
            out.getPrintWriter().printf("%s, %s, %s(%d)\n", room.getWechatId(), room.getName(), room.getNickName(), room.getMemberCount());
        }
        out.getPrintWriter().printf("\u9875\u7801 %d/%d \u5f53\u524d\u6570\u91cf:%d", page, pageDto.getTotalPageNum(), pageDto.getCurPageCount());
        return DebugResult.ok(out.toString());
    }

    private DebugResult get(String chatroomId) {
        List list = this.wechatChatRoomMapper.queryListByChatroomIds(null, Collections.singletonList(chatroomId));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return DebugResult.ok(NOTHING_FOUND);
        }
        WechatChatRoom room = (WechatChatRoom)list.get(0);
        ChatRoomMember owner = this.wechatChatRoomRelationMapper.getChatRoomMember(chatroomId, room.getOwner());
        MemPrintStream out = new MemPrintStream();
        out.getPrintWriter().printf("\u7fa4\u540d: %s(%d)\n", room.getNickName(), room.getMemberCount());
        out.getPrintWriter().printf("\u7fa4\u4e3b: %s %s\n", room.getOwner(), owner == null ? "" : owner.getNickname() + "(" + owner.getAlias() + ")");
        out.getPrintWriter().print("\u7fa4\u5185\u673a\u5668\u4eba(ID, \u6635\u79f0, \u5546\u6237ID, \u5728\u7ebf\u72b6\u6001):\n");
        if (CollectionUtils.isEmpty((Collection)list)) {
            out.getPrintWriter().print("\u6539\u7fa4\u5185\u6b64\u65f6\u6ca1\u6709\u673a\u5668\u4eba\n");
        } else {
            List<String> wechatIds = list.stream().map(it -> it.getWechatId()).collect(Collectors.toList());
            List<WechatStatusInfo> statusList = this.queryWechatStatus(wechatIds);
            Map<String, WechatStatusInfo> statusMap = statusList.stream().collect(Collectors.toMap(it -> it.getWId(), it -> it));
            for (WechatChatRoom r : list) {
                String wechatId = r.getWechatId();
                WechatAccountDto ac = this.wechatAccountCacheService.getAccount(wechatId);
                WechatStatusInfo status = statusMap.get(ac.getWechatId());
                String ip = status != null && status.getIp() != null ? status.getIp() : "\u79bb\u7ebf";
                out.getPrintWriter().printf("%s, %s(%s), %d, %s\n", ac.getWechatId(), ac.getNickname(), ac.getAlias(), ac.getBusinessCustomerId(), ip);
            }
        }
        out.getPrintWriter().printf("\u7fa4\u4e8c\u7ef4\u7801: %s", room.getQrcode());
        return DebugResult.ok(out.toString());
    }

    private DebugResult member(String chatroomId, String query, int page, int size) {
        int count = this.wechatChatRoomRelationMapper.countMembers(chatroomId, query);
        if (count == 0) {
            return DebugResult.ok(NOTHING_FOUND);
        }
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(page));
        pageDto.setPageSize(Integer.valueOf(size));
        pageDto.setCount(Integer.valueOf(count));
        List list = this.wechatChatRoomRelationMapper.queryMembers(chatroomId, query, pageDto);
        MemPrintStream out = new MemPrintStream();
        out.getPrintWriter().printf("ID, \u6635\u79f0, \u5fae\u4fe1\u53f7, \u7fa4\u540d\u7247\n", new Object[0]);
        for (ChatRoomMember member : list) {
            out.getPrintWriter().printf("%s, %s, %s, %s\n", member.getMemberId(), member.getNickname(), member.getAlias(), member.getMemberRemark());
        }
        out.getPrintWriter().printf("\u9875\u7801 %d/%d \u5f53\u524d\u6570\u91cf:%d", page, pageDto.getTotalPageNum(), list.size());
        return DebugResult.ok(out.toString());
    }

    public List<WechatStatusInfo> queryWechatStatus(List<String> wechatIds) {
        if (CollectionUtils.isEmpty(wechatIds)) {
            return Collections.emptyList();
        }
        BaseResponse resp = this.pushService.queryWechatsStatus(wechatIds);
        if (resp.getCode() != 0L) {
            log.warn("query wechat status failed. wechatIds={}, resp={}", wechatIds, (Object)resp);
            return Collections.emptyList();
        }
        return (List)resp.getData();
    }
}

