/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.client.impl;

import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.link.service.WechatOpService;
import com.kuaike.skynet.link.service.common.BaseResponse;
import com.kuaike.skynet.link.service.dto.InviteToRoomRequestS;
import com.kuaike.skynet.logic.service.client.WechatService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatServiceImpl
implements WechatService {
    private static final Logger log = LoggerFactory.getLogger(WechatServiceImpl.class);
    @Autowired
    private WechatOpService wechatOpService;

    @Override
    public void inviteToRoom(String wechatId, List<String> memberIds, String chatroomId) {
        log.info("wechat={} invite members={} to chatroom={}", new Object[]{wechatId, memberIds, chatroomId});
        InviteToRoomRequestS req = new InviteToRoomRequestS();
        req.setWId(wechatId);
        req.setTargetIds(memberIds);
        req.setTargetRoomId(chatroomId);
        req.setForceCard(true);
        req.setControl(true);
        BaseResponse resp = this.wechatOpService.inviteToRoom(req);
        if (resp.getCode() != 0L) {
            log.warn("\u9080\u8bf7\u5165\u7fa4\u5931\u8d25, req={}, resp={}", (Object)JacksonUtil.obj2Str((Object)req), (Object)JacksonUtil.obj2Str((Object)resp));
        } else {
            log.info("\u9080\u8bf7\u5165\u7fa4\u6210\u529f, req={}, resp={}", (Object)JacksonUtil.obj2Str((Object)req), (Object)JacksonUtil.obj2Str((Object)resp));
        }
    }
}

