/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.client.impl;

import com.alibaba.fastjson.JSONObject;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.link.service.PushService;
import com.kuaike.skynet.link.service.common.BaseResponse;
import com.kuaike.skynet.link.service.dto.PushMessageRequestS;
import com.kuaike.skynet.link.service.dto.WechatStatusInfo;
import com.kuaike.skynet.link.service.dto.push.TextPushMessage;
import com.kuaike.skynet.logic.dal.material.entity.SmallRoutine;
import com.kuaike.skynet.logic.dal.material.mapper.SmallRoutineMapper;
import com.kuaike.skynet.logic.dal.official.dto.OfficialNewsMaterialDto;
import com.kuaike.skynet.logic.dal.official.entity.OfficialActi;
import com.kuaike.skynet.logic.dal.official.mapper.OfficialActiMapper;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoom;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatContact;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatContactMapper;
import com.kuaike.skynet.logic.service.client.PushMsgService;
import com.kuaike.skynet.logic.service.client.WechatService;
import com.kuaike.skynet.logic.service.client.utils.PushMsgBuilder;
import com.kuaike.skynet.logic.service.common.enums.MaterialTypeEnum;
import com.kuaike.skynet.logic.service.marketing.DrainagePlanService;
import com.kuaike.skynet.logic.service.marketing.FissionPlanService;
import com.kuaike.skynet.logic.service.material.MaterialService;
import com.kuaike.skynet.logic.service.material.NewsMaterialCommonService;
import com.kuaike.skynet.logic.service.material.dto.MaterialDto;
import com.kuaike.skynet.logic.service.reply.dto.BcardDto;
import com.kuaike.skynet.logic.service.reply.dto.ContactBcardDto;
import com.kuaike.skynet.logic.service.reply.dto.FileDto;
import com.kuaike.skynet.logic.service.reply.dto.ReplyJoinGroupCardDto;
import com.kuaike.skynet.logic.service.reply.dto.RobotToRoomDto;
import com.kuaike.skynet.logic.service.reply.dto.ShareLinkDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyMessageType;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushMsgServiceImpl
implements PushMsgService {
    private static final Logger log = LoggerFactory.getLogger(PushMsgServiceImpl.class);
    @Autowired
    private PushService pushService;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private WechatContactMapper wechatContactMapper;
    @Autowired
    private MaterialService materialService;
    @Autowired
    private FissionPlanService fissionPlanService;
    @Autowired
    private DrainagePlanService drainagePlanService;
    @Autowired
    private NewsMaterialCommonService newsMaterialCommonService;
    @Autowired
    private SmallRoutineMapper smallRoutineMapper;
    @Autowired
    private OfficialActiMapper officialActiMapper;
    @Autowired
    private WechatChatRoomMapper wechatChatRoomMapper;

    @Override
    public boolean pushMessage(String wId, String to, Integer type, String message, List<String> memberIds) {
        log.info("push message, from={}, to={}, type={}, message={}, notifyMemberIds={}", new Object[]{wId, to, type, message, memberIds});
        AutoReplyMessageType msgType = AutoReplyMessageType.getType((Integer)type);
        if (msgType == null) {
            log.warn("\u672a\u77e5\u7684\u6d88\u606f\u7c7b\u578b\uff0c\u65e0\u6cd5\u63a8\u9001\u3002 type={}", (Object)type);
            return false;
        }
        PushMessageRequestS req = null;
        switch (msgType) {
            case MATERIAL: {
                Long materialId = NumberUtils.toLong((String)message, (long)-1L);
                req = this.material(materialId);
                break;
            }
            case TEXT: {
                req = PushMsgBuilder.builder().text(message).build();
                break;
            }
            case IMAGE: {
                req = PushMsgBuilder.builder().image(message).build();
                break;
            }
            case VIDEO: {
                req = PushMsgBuilder.builder().video(message).build();
                break;
            }
            case VOICE: {
                int length = this.materialService.getDurationByUrl(message);
                req = PushMsgBuilder.builder().voice(message, length).build();
                break;
            }
            case B_CARD: {
                req = PushMsgBuilder.builder().businessCard(message).build();
                break;
            }
            case FILE: {
                req = this.file(message);
                break;
            }
            case LINK: {
                req = this.link(message);
                break;
            }
            case DRAINAGE: {
                req = this.drainage(message);
                break;
            }
            case FISSION: {
                req = this.fission(message);
                break;
            }
            case JOIN_GROUP_CARD: {
                return this.invite(wId, to, message);
            }
            case MINI_PROGRAM: {
                req = this.miniProgram(message);
                break;
            }
            case OWNER_BCARD: {
                String roomOwner = this.wechatChatRoomMapper.queryOwnerByName(to);
                if (StringUtils.isEmpty((CharSequence)roomOwner)) {
                    roomOwner = wId;
                }
                log.info("pushMessage rely roomOwner : {}", (Object)roomOwner);
                req = PushMsgBuilder.builder().businessCard(roomOwner).build();
                break;
            }
            case CONTACT_BCARD: {
                req = this.bcard(wId, to, message);
                break;
            }
            case OFFICIAL_NEWS: {
                req = this.officialNews(message);
                break;
            }
            case OFFICIAL_ACTI: {
                return this.officialActi(wId, to, memberIds, message);
            }
            default: {
                log.warn("\u672a\u77e5\u7684\u6d88\u606f\u7c7b\u578b, msgType={}", (Object)msgType);
                return false;
            }
        }
        if (req == null) {
            log.warn("\u672a\u80fd\u6b63\u786e\u751f\u6210\u63a8\u9001\u6d88\u606f\uff0c\u65e0\u6cd5\u63a8\u9001\u3002type={}, message={}", (Object)type, (Object)message);
            return false;
        }
        if (CollectionUtils.isNotEmpty(memberIds)) {
            TextPushMessage text = req.getTextPushMessage();
            if (text != null) {
                req = PushMsgBuilder.builder().atMembers(memberIds, text.getContent()).build();
            } else {
                PushMessageRequestS at = PushMsgBuilder.builder().atMembers(memberIds).wId(wId).to(to).control(false).build();
                this.pushMessage(at);
            }
        }
        req.setWId(wId);
        req.setTo(to);
        req.setControl(false);
        this.pushMessage(req);
        return true;
    }

    private PushMessageRequestS material(Long materialId) {
        List materialDtos = this.materialService.getMaterials(Collections.singletonList(materialId));
        if (materialDtos.size() == 0) {
            log.warn("\u627e\u4e0d\u5230id\u4e3a{}\u7684\u7d20\u6750", (Object)materialId);
            return null;
        }
        MaterialDto materialDto = (MaterialDto)materialDtos.get(0);
        MaterialTypeEnum materialType = MaterialTypeEnum.getType((String)materialDto.getType());
        if (materialType == null) {
            log.warn("\u672a\u77e5\u7684\u7d20\u6750\u7c7b\u578b, material={}", (Object)materialDto);
            return null;
        }
        PushMessageRequestS req = null;
        switch (materialType) {
            case TXT: {
                req = PushMsgBuilder.builder().text(materialDto.getContent()).build();
                break;
            }
            case IMAGE: {
                req = PushMsgBuilder.builder().image(materialDto.getContent()).build();
                break;
            }
            case VOICE: {
                String url = materialDto.getContent();
                int length = this.materialService.getDurationByUrl(url);
                req = PushMsgBuilder.builder().voice(url, length).build();
                break;
            }
            case VIDEO: {
                req = PushMsgBuilder.builder().video(materialDto.getContent()).build();
                break;
            }
            case FILE: {
                req = PushMsgBuilder.builder().file(materialDto.getTitle(), materialDto.getContent()).build();
                break;
            }
            default: {
                log.warn("\u4e0d\u652f\u6301\u7684\u7d20\u6750\u7c7b\u578b: materil={}", (Object)materialDto);
                return null;
            }
        }
        return req;
    }

    private PushMessageRequestS link(String message) {
        ShareLinkDto link = null;
        try {
            link = (ShareLinkDto)JacksonUtil.str2Obj((String)message, ShareLinkDto.class);
        }
        catch (IOException e) {
            log.error("\u89e3\u6790\u5206\u4eab\u94fe\u63a5\u5931\u8d25, content={}", (Object)message, (Object)e);
            e.printStackTrace();
            return null;
        }
        if (link == null) {
            log.warn("\u89e3\u6790\u94fe\u63a5\u5931\u8d25, message={}", (Object)message);
            return null;
        }
        return PushMsgBuilder.builder().link(link.getTitle(), link.getDesc(), link.getUrl(), link.getThumbUrl()).build();
    }

    private PushMessageRequestS file(String message) {
        FileDto file = null;
        try {
            file = (FileDto)JacksonUtil.str2Obj((String)message, FileDto.class);
        }
        catch (IOException e) {
            log.error("Failed parsing file, content={}", (Object)message, (Object)e);
            e.printStackTrace();
        }
        if (file == null) {
            log.warn("\u89e3\u6790\u94fe\u63a5\u5931\u8d25, message={}", (Object)message);
            return null;
        }
        String title = file.getTitle();
        String url = file.getUrl();
        if (StringUtils.endsWithIgnoreCase((CharSequence)url, (CharSequence)".png") || StringUtils.endsWithIgnoreCase((CharSequence)url, (CharSequence)".jpeg")) {
            return PushMsgBuilder.builder().image(url).build();
        }
        return PushMsgBuilder.builder().file(title, url).build();
    }

    private PushMessageRequestS drainage(String message) {
        Long drianagePlanId = NumberUtils.toLong((String)message, (long)-1L);
        String content = this.drainagePlanService.queryDrainageContentById(drianagePlanId);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.warn("\u672a\u627e\u5230id={}\u7684\u5fae\u4fe1/\u7fa4\u6f0f\u6597", (Object)message);
            return null;
        }
        return PushMsgBuilder.builder().text(content).build();
    }

    private PushMessageRequestS fission(String message) {
        Long fissionPlanId = NumberUtils.toLong((String)message, (long)-1L);
        String content = this.fissionPlanService.queryFissionContentById(fissionPlanId);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.warn("\u672a\u627e\u5230id={}\u7684\u5fae\u4fe1/\u7fa4\u88c2\u53d8", (Object)message);
            return null;
        }
        return PushMsgBuilder.builder().text(content).build();
    }

    private PushMessageRequestS miniProgram(String message) {
        Long miniProgramId = NumberUtils.toLong((String)message, (long)-1L);
        SmallRoutine miniProgram = (SmallRoutine)this.smallRoutineMapper.selectByPrimaryKey((Object)miniProgramId);
        if (miniProgram == null || miniProgram.getIsDeleted() != 0) {
            log.warn("\u672a\u627e\u5230id={}\u7684\u5c0f\u7a0b\u5e8f\u6d88\u606f", (Object)message);
            return null;
        }
        return PushMsgBuilder.builder().miniProgram(miniProgram.getUserName(), miniProgram.getNickName(), miniProgram.getUrl(), miniProgram.getPagePath(), miniProgram.getTitle(), miniProgram.getIconUrl(), miniProgram.getThumbIconUrl()).build();
    }

    private PushMessageRequestS officialNews(String message) {
        Long officialNewsId = NumberUtils.toLong((String)message, (long)-1L);
        List list = this.newsMaterialCommonService.queryOfficialMaterialInfoByIds(Collections.singletonList(officialNewsId));
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.warn("\u672a\u627e\u5230id={}\u7684\u516c\u4f17\u53f7\u56fe\u6587\u6d88\u606f", (Object)message);
            return null;
        }
        OfficialNewsMaterialDto news = (OfficialNewsMaterialDto)list.get(0);
        return PushMsgBuilder.builder().link(news.getTitle(), news.getDigest(), news.getUrl(), news.getCover()).build();
    }

    private boolean officialActi(String wId, String to, List<String> memberIds, String message) {
        Long officialActiId = NumberUtils.toLong((String)message, (long)-1L);
        OfficialActi acti = this.officialActiMapper.queryById(officialActiId);
        if (acti == null) {
            log.warn("\u672a\u627e\u5230id={}\u7684\u516c\u4f17\u53f7\u88c2\u53d8", (Object)message);
            return false;
        }
        String json = acti.getContent();
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        String content = jsonObject.getString("autoResp");
        PushMessageRequestS text = null;
        text = CollectionUtils.isEmpty(memberIds) ? PushMsgBuilder.builder().text(content).wId(wId).to(to).build() : PushMsgBuilder.builder().atMembers(memberIds, content).wId(wId).to(to).build();
        String url = acti.getCover();
        PushMessageRequestS image = PushMsgBuilder.builder().image(url).wId(wId).to(to).build();
        this.pushMessage(text);
        this.sleep(100L);
        this.pushMessage(image);
        return true;
    }

    @Override
    public void pushMessage(PushMessageRequestS req) {
        log.info("push message with req={}", (Object)JacksonUtil.obj2Str((Object)req));
        BaseResponse resp = this.pushService.push(req);
        if (resp.getCode() != 0L) {
            log.warn("\u63a8\u9001\u6d88\u606f\u5931\u8d25, req={}, resp={}", (Object)JacksonUtil.obj2Str((Object)req), (Object)JacksonUtil.obj2Str((Object)resp));
        } else {
            log.info("\u63a8\u9001\u6d88\u606f\u6210\u529f, req={}, resp={}", (Object)JacksonUtil.obj2Str((Object)req), (Object)JacksonUtil.obj2Str((Object)resp));
        }
    }

    private PushMessageRequestS bcard(String wid, String chatroomId, String message) {
        ContactBcardDto card = null;
        try {
            card = (ContactBcardDto)JacksonUtil.str2Obj((String)message, ContactBcardDto.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("\u89e3\u6790\u4e2a\u4eba\u540d\u7247\u5931\u8d25, json={}", (Object)message, (Object)e);
            return null;
        }
        if (card == null) {
            log.warn("\u89e3\u6790\u4e2a\u4eba\u540d\u7247\u5931\u8d25, json={}", (Object)message);
            return null;
        }
        BcardDto bcard = null;
        for (BcardDto it : card.getList()) {
            if (!chatroomId.equals(it.getChatroomId())) continue;
            bcard = it;
            break;
        }
        if (bcard == null) {
            log.warn("\u6ca1\u6709\u627e\u5230\u8fd9\u4e2a\u7fa4\u8bbe\u7f6e\u7684\u4e2a\u4eba\u540d\u7247, chatroomId={}, cards={}", (Object)chatroomId, (Object)card.getList());
            return null;
        }
        if (StringUtils.isBlank((CharSequence)bcard.getRobotId())) {
            log.warn("\u627e\u4e0d\u5230\u53d1\u9001\u540d\u7247\u7684\u673a\u5668\u4ebaID, chatroomId={}, bcard={}", (Object)chatroomId, (Object)bcard);
            return null;
        }
        if (!wid.equals(bcard.getRobotId())) {
            log.warn("\u5f53\u524d\u7fa4\u4e3b\u5df2\u7ecf\u4e0d\u662f\u56de\u590d\u8bbe\u7f6e\u65f6\u7684\u7fa4\u4e3b\u3002chatroomId={}, wid={}, bcard={}", new Object[]{chatroomId, wid, bcard});
            return null;
        }
        if (StringUtils.isBlank((CharSequence)bcard.getWechatId())) {
            log.warn("\u6ca1\u6709\u627e\u5230\u8fd9\u4e2a\u7fa4\u8bbe\u7f6e\u7684\u4e2a\u4eba\u540d\u7247, chatroomId={}, bcard={}", (Object)chatroomId, (Object)bcard);
            return null;
        }
        WechatContact contact = this.wechatContactMapper.getContact(wid, bcard.getWechatId());
        if (contact == null || contact.getIsDeleted().booleanValue()) {
            log.warn("\u8be5\u8054\u7cfb\u4eba\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664, wechatId={}, contactId={}", (Object)wid, (Object)bcard.getWechatId());
            return null;
        }
        return PushMsgBuilder.builder().businessCard(bcard.getWechatId()).build();
    }

    private boolean invite(String wechatId, String targetId, String message) {
        String chatroomId;
        ReplyJoinGroupCardDto card = null;
        try {
            card = (ReplyJoinGroupCardDto)JacksonUtil.str2Obj((String)message, ReplyJoinGroupCardDto.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u89e3\u6790\u52a0\u7fa4\u5361\u7247\u53c2\u6570\u5931\u8d25, json={}", (Object)message, (Object)e);
            return false;
        }
        if (card == null) {
            log.warn("\u89e3\u6790\u52a0\u7fa4\u5361\u7247\u53c2\u6570\u5931\u8d25, json={}", (Object)message);
            return false;
        }
        List<String> chatroomIds = this.getChatroomIds(wechatId, card);
        if (CollectionUtils.isEmpty(chatroomIds)) {
            log.warn("\u6ca1\u6709\u53ef\u7528\u7684\u7fa4\uff0c\u9080\u8bf7\u5165\u7fa4\u5931\u8d25\u3002 card={}", (Object)card);
            return false;
        }
        Integer maxMemberCount = card.getChatroomMaxMemberCount();
        if (maxMemberCount == null || maxMemberCount > 500) {
            maxMemberCount = 500;
        }
        if ((chatroomId = this.getOrderedChatroomId(wechatId, chatroomIds, maxMemberCount)) == null) {
            log.warn("\u7fa4\u5df2\u7ecf\u90fd\u6ee1\u4e86\uff0c\u65e0\u6cd5\u9080\u8bf7\u5165\u7fa4\u3002 card={}", (Object)card);
            return false;
        }
        if (this.isInChatRoom(targetId, chatroomId)) {
            log.info("targetId: {} is in chatRoom: {}", (Object)targetId, (Object)chatroomId);
            return false;
        }
        this.wechatService.inviteToRoom(wechatId, Collections.singletonList(targetId), chatroomId);
        return true;
    }

    private boolean isInChatRoom(String wechatId, String chatRoomId) {
        boolean result = false;
        log.info("check is in chatRoom wechatId: {}, chatRoomId: {}", (Object)wechatId, (Object)chatRoomId);
        int num = this.wechatChatRoomMapper.queryInChatRoom(wechatId, chatRoomId);
        if (num > 0) {
            result = true;
        }
        return result;
    }

    private List<String> getChatroomIds(String wechatId, ReplyJoinGroupCardDto card) {
        if (CollectionUtils.isNotEmpty((Collection)card.getChatroomIds())) {
            return card.getChatroomIds();
        }
        List chatroomIds = null;
        if (CollectionUtils.isNotEmpty((Collection)card.getList())) {
            for (RobotToRoomDto invite : card.getList()) {
                if (!wechatId.equals(invite.getWechatId())) continue;
                chatroomIds = invite.getChatroomIds();
                break;
            }
        }
        if (chatroomIds == null) {
            log.warn("\u6ca1\u6709\u627e\u5230\u8fd9\u4e2a\u5fae\u4fe1\u53f7\u8bbe\u7f6e\u7684\u9080\u8bf7\u5165\u7fa4\u5361\u7247, wechatId={}, list={}", (Object)wechatId, (Object)card.getList());
        }
        return chatroomIds;
    }

    private String getOrderedChatroomId(String wechatId, List<String> chatroomIds, Integer maxMemberCount) {
        if (CollectionUtils.isEmpty(chatroomIds)) {
            log.warn("chatroomIds is empty");
            return null;
        }
        if (chatroomIds.size() == 1) {
            return chatroomIds.get(0);
        }
        List chatRoomList = this.wechatChatRoomMapper.queryListByChatroomIds(wechatId, chatroomIds);
        if (CollectionUtils.isEmpty((Collection)chatRoomList)) {
            log.warn("Chatroom not found, chatroomIds={}", chatroomIds);
            return null;
        }
        Map<String, List<WechatChatRoom>> chatRoomMap = chatRoomList.stream().collect(Collectors.groupingBy(WechatChatRoom::getName));
        for (String chatroomId : chatroomIds) {
            List<WechatChatRoom> roomList = chatRoomMap.get(chatroomId);
            if (roomList == null) {
                log.warn("Chatroom not found with id={}", (Object)chatroomId);
                continue;
            }
            WechatChatRoom chatroom = roomList.get(0);
            Integer memberCount = chatroom.getMemberCount();
            if (memberCount > maxMemberCount) continue;
            return chatroomId;
        }
        log.info("No available chatroom found, chatroomIds={}, maxMemberCount={}", chatroomIds, (Object)maxMemberCount);
        return null;
    }

    @Override
    public List<WechatStatusInfo> queryWechatStatus(List<String> wechatIds) {
        if (CollectionUtils.isEmpty(wechatIds)) {
            return Collections.emptyList();
        }
        BaseResponse resp = this.pushService.queryWechatsStatus(wechatIds);
        if (resp.getCode() != 0L) {
            log.warn("query wechat status failed. wechatIds={}, resp={}", wechatIds, (Object)resp);
            return Collections.emptyList();
        }
        return (List)resp.getData();
    }

    @Override
    public void sleep() {
        this.sleep(100L);
    }

    @Override
    public void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

