/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.marketing;

import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatAccountGroupRelation;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatAccountGroupRelationCriteria;
import com.kuaike.skynet.logic.dal.wechat.mapper.MarketingTrafficLevelMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatAccountGroupRelationMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MarketingTrafficLevelHelper {
    private static final Logger log = LoggerFactory.getLogger(MarketingTrafficLevelHelper.class);
    @Autowired
    private MarketingTrafficLevelMapper marketingTrafficLevelMapper;
    @Autowired
    private WechatAccountGroupRelationMapper wechatAccountGroupRelationMapper;

    public void onJoinGroup() {
        ReplyContext ctx = ReplyContextUtil.get();
        String chatRoomId = ctx.getChatroomId();
        List<String> memberIds = ctx.getJoinGroupWithoutRobotWechatIds();
        if (CollectionUtils.isEmpty(memberIds)) {
            log.info("No memberIds found, requestId={}. Maybe they are robot or in blacklist, buId={}, wechatIds={}", new Object[]{ctx.getRequestId(), ctx.getBusinessCustomerId(), ctx.getJoinGroupWechatIds()});
            return;
        }
        log.info("add wechat room member tags, chatRoomId={}, list={}", (Object)chatRoomId, memberIds);
        WechatAccountGroupRelationCriteria wechatAccountGroupRelationCriteria = new WechatAccountGroupRelationCriteria();
        wechatAccountGroupRelationCriteria.createCriteria().andChatRoomIdEqualTo(chatRoomId).andWechatIdIsNull();
        List groupRelationList = this.wechatAccountGroupRelationMapper.selectByExample((Object)wechatAccountGroupRelationCriteria);
        if (CollectionUtils.isEmpty((Collection)groupRelationList)) {
            return;
        }
        Map trafficLevelMap = this.marketingTrafficLevelMapper.queryTrafficLevelMap(ctx.getBusinessCustomerId());
        ArrayList<WechatAccountGroupRelation> list4Add = new ArrayList<WechatAccountGroupRelation>();
        ArrayList list4Update = new ArrayList();
        for (WechatAccountGroupRelation groupRelation : groupRelationList) {
            for (String memberWechatId : memberIds) {
                Long groupId;
                String wechatId = memberWechatId;
                List<WechatAccountGroupRelation> existList = this.queryExistGroupRelationList(wechatId, groupId = groupRelation.getGroupId());
                if (CollectionUtils.isEmpty(existList)) {
                    WechatAccountGroupRelation record = new WechatAccountGroupRelation();
                    record.setWechatId(wechatId);
                    record.setGroupId(groupRelation.getGroupId());
                    record.setChatRoomId(groupRelation.getChatRoomId());
                    record.setFlowLevelId(groupRelation.getFlowLevelId());
                    list4Add.add(record);
                    continue;
                }
                existList.forEach(exist -> {
                    Integer newLevel = trafficLevelMap.getOrDefault(groupRelation.getFlowLevelId(), 0);
                    Integer existLevel = trafficLevelMap.getOrDefault(exist.getFlowLevelId(), 0);
                    if (newLevel > existLevel) {
                        exist.setFlowLevelId(groupRelation.getFlowLevelId());
                        list4Update.add(exist);
                    }
                });
            }
        }
        if (CollectionUtils.isNotEmpty(list4Add)) {
            this.wechatAccountGroupRelationMapper.addWechatAccountGroupRelationBatch(list4Add);
        }
        if (CollectionUtils.isNotEmpty(list4Update)) {
            list4Update.forEach(it -> this.wechatAccountGroupRelationMapper.updateByPrimaryKeySelective(it));
        }
    }

    public void onFriendIsJoined(Long levelId, List<Long> categoryTags) {
        ReplyContext ctx = ReplyContextUtil.get();
        String wechatId = ctx.getTalkerId();
        log.info("batch tag with wechatId={}, levelId={}, tags={}", new Object[]{wechatId, levelId, categoryTags});
        if (CollectionUtils.isEmpty(categoryTags)) {
            log.info("No tags");
            return;
        }
        Map trafficLevelMap = this.marketingTrafficLevelMapper.queryTrafficLevelMap(ctx.getBusinessCustomerId());
        ArrayList<WechatAccountGroupRelation> list4Add = new ArrayList<WechatAccountGroupRelation>();
        ArrayList list4Update = new ArrayList();
        for (Long groupId : categoryTags) {
            List<WechatAccountGroupRelation> existList = this.queryExistGroupRelationList(wechatId, groupId);
            if (CollectionUtils.isEmpty(existList)) {
                WechatAccountGroupRelation accountGroupRelation2 = new WechatAccountGroupRelation();
                accountGroupRelation2.setWechatId(wechatId);
                accountGroupRelation2.setGroupId(groupId);
                accountGroupRelation2.setFlowLevelId(levelId);
                list4Add.add(accountGroupRelation2);
                continue;
            }
            existList.forEach(exist -> {
                Integer newLevel = trafficLevelMap.getOrDefault(levelId, 0);
                Integer existLevel = trafficLevelMap.getOrDefault(exist.getFlowLevelId(), 0);
                if (newLevel > existLevel) {
                    exist.setFlowLevelId(levelId);
                    list4Update.add(exist);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(list4Add)) {
            this.wechatAccountGroupRelationMapper.addWechatAccountGroupRelationBatch(list4Add);
        }
        if (CollectionUtils.isNotEmpty(list4Update)) {
            list4Update.forEach(accountGroupRelation -> this.wechatAccountGroupRelationMapper.updateByPrimaryKeySelective(accountGroupRelation));
        }
    }

    private List<WechatAccountGroupRelation> queryExistGroupRelationList(String wechatId, Long groupId) {
        WechatAccountGroupRelationCriteria example = new WechatAccountGroupRelationCriteria();
        example.createCriteria().andWechatIdEqualTo(wechatId).andGroupIdEqualTo(groupId);
        List existGroupRelationList = this.wechatAccountGroupRelationMapper.selectByExample((Object)example);
        return existGroupRelationList;
    }
}

