/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.marketing;

import com.google.common.collect.Lists;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.market.entity.MarketChatRoomMember;
import com.kuaike.skynet.logic.dal.market.mapper.MarketChatRoomMemberMapper;
import com.kuaike.skynet.logic.service.common.enums.MarketingPlanType;
import com.kuaike.skynet.logic.wechat.msg.JoinGroupMsg;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MarketChatRoomMemberHandler {
    private static final Logger log = LoggerFactory.getLogger(MarketChatRoomMemberHandler.class);
    @Autowired
    private MarketChatRoomMemberMapper marketChatRoomMemberMapper;

    public void onJoinGroup(MarketingPlanType planType, Long planId, Long planCategoryId) {
        ReplyContext ctx = ReplyContextUtil.get();
        List<JoinGroupMsg.Member> members = ctx.getJoinGroupMemberList();
        if (CollectionUtils.isEmpty(members)) {
            return;
        }
        log.info("record market chat room member, requestId={}, planType={}, planId={}, planCategoryId={}, members={}", new Object[]{ctx.getRequestId(), planType, planId, planCategoryId, members});
        ArrayList list = Lists.newArrayList();
        for (JoinGroupMsg.Member it : members) {
            MarketChatRoomMember member = new MarketChatRoomMember();
            member.setBusinessCustomerId(ctx.getBusinessCustomerId());
            member.setChatRoomId(ctx.getChatroomId());
            member.setWechatId(it.getUsername());
            member.setNickname(it.getNickname());
            member.setPlanType(Integer.valueOf(planType.getValue()));
            member.setPlanId(planId);
            member.setPlanCategoryId(planCategoryId);
            list.add(member);
        }
        try {
            this.marketChatRoomMemberMapper.batchInsert((List)list);
        }
        catch (Exception e) {
            log.error("Failed insert market chat room members", (Throwable)e);
        }
    }
}

