/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.marketing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfig;
import com.kuaike.skynet.logic.dal.market.mapper.MarketReplyConfigMapper;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessage;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessageMember;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicIntervalSendMessageMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicIntervalSendMessageMemberMapper;
import com.kuaike.skynet.logic.handler.common.MsgDigestHelper;
import com.kuaike.skynet.logic.handler.marketing.MarketingContactStatusHandler;
import com.kuaike.skynet.logic.handler.marketing.MarketingTrafficLevelHelper;
import com.kuaike.skynet.logic.service.common.SettingService;
import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.common.dto.ReplyMessageDto;
import com.kuaike.skynet.logic.service.common.enums.IntervalMessageReplyTypeEnum;
import com.kuaike.skynet.logic.service.common.enums.MarketReplyConfigType;
import com.kuaike.skynet.logic.service.common.enums.MarketingPlanType;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.marketing.dto.FissionFriendAccomplishTaskReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.FissionJoinFriendReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.FriendFissionRewardReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.InviteToChatRoomDto;
import com.kuaike.skynet.logic.service.marketing.dto.WechatIdAndChatRoomIdsDto;
import com.kuaike.skynet.logic.service.reply.dto.FileDto;
import com.kuaike.skynet.logic.service.reply.dto.ReplyJoinGroupCardDto;
import com.kuaike.skynet.logic.service.reply.dto.RobotToRoomDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyMessageType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class FissionFriendReplyHandler {
    private static final Logger log = LoggerFactory.getLogger(FissionFriendReplyHandler.class);
    @Autowired
    private MarketReplyConfigMapper marketReplyConfigMapper;
    @Autowired
    private MarketingContactStatusHandler marketingContactStatusHandler;
    @Autowired
    private LogicIntervalSendMessageMapper logicIntervalSendMessageMapper;
    @Autowired
    private LogicIntervalSendMessageMemberMapper logicIntervalSendMessageMemberMapper;
    @Autowired
    private MarketingTrafficLevelHelper marketingTrafficLevelHelper;
    @Autowired
    private MsgDigestHelper msgDigestHelper;
    @Autowired
    private SettingService settingService;

    public void onWaitJoinFriendEvent(WechatMessage wechatMessage) {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("on wait join friend event, requestId={}", (Object)ctx.getRequestId());
        Long planId = this.marketReplyConfigMapper.getFissionFriendPlanId(ctx.getBusinessCustomerId(), ctx.getWechatId(), Integer.valueOf(MarketReplyConfigType.WECHAT_FISSION_WECHATID_CONFIG.getValue()), new Date());
        if (planId == null) {
            log.info("No effective fission plan found, businessCustomerId={}, wechatId={}", (Object)ctx.getBusinessCustomerId(), (Object)ctx.getWechatId());
            return;
        }
        this.marketingContactStatusHandler.onWaitJoinFriendEvent(MarketingPlanType.WECHAT_FISSION_PLAN, planId);
    }

    public boolean onFriendIsJoined(WechatMessage wechatMessage) {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("on friend is joined, requestId={}", (Object)ctx.getRequestId());
        Long planId = this.marketReplyConfigMapper.getFissionFriendPlanId(ctx.getBusinessCustomerId(), ctx.getWechatId(), Integer.valueOf(MarketReplyConfigType.WECHAT_FISSION_WECHATID_CONFIG.getValue()), new Date());
        if (planId == null) {
            log.info("No effective fission plan found, businessCustomerId={}, wechatId={}", (Object)ctx.getBusinessCustomerId(), (Object)ctx.getWechatId());
            return false;
        }
        log.info("Using fission plan, id={}", (Object)planId);
        this.marketingContactStatusHandler.onFriendIsJoined(MarketingPlanType.WECHAT_FISSION_PLAN, planId);
        MarketReplyConfig config = this.marketReplyConfigMapper.getFissionWechatFriendPlanId(planId, Integer.valueOf(MarketReplyConfigType.WECHAT_FISSION_ADD_FRIEND_REPLY.getValue()));
        if (config == null) {
            log.info("No join friend reply found, planId={}", (Object)planId);
            return false;
        }
        FissionJoinFriendReplyConfig replyConfig = null;
        try {
            replyConfig = (FissionJoinFriendReplyConfig)JacksonUtil.str2Obj((String)config.getJsonText(), FissionJoinFriendReplyConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed parsing fission join friend reply, config={}", (Object)config, (Object)e);
        }
        if (replyConfig == null) {
            log.info("No fission join friend reply found, config={}", (Object)config);
            return false;
        }
        this.marketingTrafficLevelHelper.onFriendIsJoined(config.getLevelId(), replyConfig.getCategoryTags());
        boolean flag = this.createJoinFriendReply(planId, config, replyConfig);
        return flag;
    }

    private boolean createJoinFriendReply(Long planId, MarketReplyConfig config, FissionJoinFriendReplyConfig replyConfig) {
        ReplyContext ctx = ReplyContextUtil.get();
        String message = this.getJoinFriendReplyMessage(replyConfig);
        if (StringUtils.isBlank((CharSequence)message)) {
            return false;
        }
        String digest = SHA1Utils.digest((String)message);
        if (this.msgDigestHelper.isCached(digest)) {
            return true;
        }
        LogicIntervalSendMessage sendMsgRecord = new LogicIntervalSendMessage();
        sendMsgRecord.setWechatId(ctx.getWechatId());
        sendMsgRecord.setWechatRoomName("");
        sendMsgRecord.setMessage(message);
        sendMsgRecord.setReplyType(Integer.valueOf(IntervalMessageReplyTypeEnum.FISSION_JOIN_FRIEND.getValue()));
        sendMsgRecord.setFissionPlanId(planId);
        sendMsgRecord.setMemberInterval(Integer.valueOf(0));
        sendMsgRecord.setIntervalAudiTime(Integer.valueOf(0));
        Integer sendIntervalTime = this.settingService.getFriendSendIntervalTime(ctx.getBusinessCustomerId());
        sendMsgRecord.setSendTime(new Date(System.currentTimeMillis() + (long)sendIntervalTime.intValue() * 1000L));
        this.logicIntervalSendMessageMapper.insertSelective((Object)sendMsgRecord);
        LogicIntervalSendMessageMember sendMsgMemberRecord = new LogicIntervalSendMessageMember();
        sendMsgMemberRecord.setIntervalSendMessageId(sendMsgRecord.getId());
        sendMsgMemberRecord.setWechatRoomName("");
        sendMsgMemberRecord.setMemberWechatId(ctx.getTalkerId());
        this.logicIntervalSendMessageMemberMapper.insertSelective((Object)sendMsgMemberRecord);
        this.msgDigestHelper.cache(digest);
        return true;
    }

    private String getJoinFriendReplyMessage(FissionJoinFriendReplyConfig replyConfig) {
        if (replyConfig == null) {
            log.warn("Reply config is null");
            return "";
        }
        if (CollectionUtils.isEmpty((Collection)replyConfig.getAddFriendReplyMessages())) {
            log.warn("No add friend reply found, config={}", (Object)replyConfig);
            return "";
        }
        ReplyMessageDto replyMessageDto = new ReplyMessageDto(replyConfig.getAddFriendReplyMessages());
        return JacksonUtil.obj2Str((Object)replyMessageDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean recvFriendImage(WechatMessage wechatMessage) {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("recv friend image, requestId={}", (Object)ctx.getRequestId());
        Long planId = this.marketReplyConfigMapper.getFissionFriendPlanId(ctx.getBusinessCustomerId(), ctx.getWechatId(), Integer.valueOf(MarketReplyConfigType.WECHAT_FISSION_WECHATID_CONFIG.getValue()), new Date());
        if (planId == null) {
            log.info("No effective fission plan found, businessCustomerId={}, wechatId={}", (Object)ctx.getBusinessCustomerId(), (Object)ctx.getWechatId());
            return false;
        }
        if (this.existFriendFissionTask(ctx.getWechatId(), ctx.getTalkerId(), planId)) {
            log.info("This contact has already completed task. planId={}, wechatId={}, talkerId={}", new Object[]{planId, ctx.getWechatId(), ctx.getTalkerId()});
            return true;
        }
        this.createTaskCompleteReply(planId);
        return true;
    }

    private boolean existFriendFissionTask(String wechatId, String memberWechatId, Long fissionPlanId) {
        log.info("query exist fission friend task, wechatId={}, talkerId={}, planId={}", new Object[]{wechatId, memberWechatId, fissionPlanId});
        HashMap mapParam = Maps.newHashMap();
        mapParam.put("wechatId", wechatId);
        mapParam.put("memberWechatId", memberWechatId);
        mapParam.put("fissionPlanId", fissionPlanId);
        mapParam.put("replyType", IntervalMessageReplyTypeEnum.FISSION_FRIEND_TASK_COMPLETE.getValue());
        int num = this.logicIntervalSendMessageMapper.existFissionTaskCount((Map)mapParam);
        return num > 0;
    }

    private boolean createTaskCompleteReply(Long planId) {
        ReplyContext ctx = ReplyContextUtil.get();
        MarketReplyConfig config = this.marketReplyConfigMapper.getFissionWechatFriendPlanId(planId, Integer.valueOf(MarketReplyConfigType.WECHAT_FISSION_RECEIVE_PICTURE_SCREENSHOTS_REPLY.getValue()));
        if (config == null) {
            log.info("No receive friend image reply found, planId={}", (Object)planId);
            return false;
        }
        FissionFriendAccomplishTaskReplyConfig replyConfig = null;
        try {
            replyConfig = (FissionFriendAccomplishTaskReplyConfig)JacksonUtil.str2Obj((String)config.getJsonText(), FissionFriendAccomplishTaskReplyConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Failed parsing fission friend task accomplish reply, json={}", (Object)config.getJsonText(), (Object)e);
        }
        if (replyConfig == null) {
            log.info("No fission friend task accomplish reply found, config={}", (Object)config);
            return false;
        }
        List messageList = replyConfig.getReplyMessages();
        ReplyMessageDto replyMessageDto = new ReplyMessageDto((CommonMessage)messageList.get(0));
        String message = JacksonUtil.obj2Str((Object)replyMessageDto);
        int intervalTime = (Integer)ObjectUtils.defaultIfNull((Object)replyConfig.getIntervalTime(), (Object)0);
        int intervalAuditTime = (Integer)ObjectUtils.defaultIfNull((Object)replyConfig.getIntervalAuditTime(), (Object)0);
        long accomplishSendTime = System.currentTimeMillis() + (long)intervalTime * 1000L;
        Date sendTime = new Date(accomplishSendTime);
        LogicIntervalSendMessage send = new LogicIntervalSendMessage();
        send.setWechatId(ctx.getWechatId());
        send.setWechatRoomName("");
        send.setMessage(message);
        send.setReplyType(Integer.valueOf(IntervalMessageReplyTypeEnum.FISSION_FRIEND_TASK_COMPLETE.getValue()));
        send.setFissionPlanId(planId);
        send.setSendTime(sendTime);
        send.setMemberInterval(Integer.valueOf(0));
        send.setIntervalAudiTime(Integer.valueOf(0));
        this.logicIntervalSendMessageMapper.insertSelective((Object)send);
        LogicIntervalSendMessageMember sendMember = new LogicIntervalSendMessageMember();
        sendMember.setIntervalSendMessageId(send.getId());
        sendMember.setWechatRoomName("");
        sendMember.setMemberWechatId(ctx.getTalkerId());
        this.logicIntervalSendMessageMemberMapper.insertSelective((Object)sendMember);
        this.createRewardReply(planId, intervalTime, intervalAuditTime);
        return true;
    }

    private boolean createRewardReply(Long planId, Integer intervalTime, Integer intervalAuditTime) {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("create friend rewards reply with planId={}", (Object)planId);
        MarketReplyConfig config = this.marketReplyConfigMapper.getFissionWechatFriendPlanId(planId, Integer.valueOf(MarketReplyConfigType.WECHAT_FISSION_CHECK_ACCOMPLISH_REPLY.getValue()));
        if (config == null) {
            return false;
        }
        FriendFissionRewardReplyConfig replyConfig = null;
        try {
            replyConfig = (FriendFissionRewardReplyConfig)JacksonUtil.str2Obj((String)config.getJsonText(), FriendFissionRewardReplyConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Failed parsing fission friend reward reply, json={}", (Object)config.getJsonText(), (Object)e);
        }
        if (replyConfig == null) {
            log.info("No fission friend reward reply found, config={}", (Object)config);
            return false;
        }
        String message = this.getRewardMessage(replyConfig);
        if (StringUtils.isBlank((CharSequence)message)) {
            log.warn("No reward reply message found, config={}", (Object)config);
            return false;
        }
        Date sendTime = new Date(System.currentTimeMillis() + (long)intervalTime.intValue() * 1000L + 1L + (long)(intervalAuditTime * 60) * 1000L);
        LogicIntervalSendMessage send = new LogicIntervalSendMessage();
        send.setWechatId(ctx.getWechatId());
        send.setWechatRoomName("");
        send.setMessage(message);
        send.setReplyType(Integer.valueOf(IntervalMessageReplyTypeEnum.FISSION_FRIEND_TASK_REWARD.getValue()));
        send.setFissionPlanId(planId);
        send.setSendTime(sendTime);
        send.setMemberInterval(Integer.valueOf(0));
        send.setIntervalAudiTime(Integer.valueOf(0));
        this.logicIntervalSendMessageMapper.insertSelective((Object)send);
        LogicIntervalSendMessageMember sendMember = new LogicIntervalSendMessageMember();
        sendMember.setIntervalSendMessageId(send.getId());
        sendMember.setWechatRoomName("");
        sendMember.setMemberWechatId(ctx.getTalkerId());
        this.logicIntervalSendMessageMemberMapper.insertSelective((Object)sendMember);
        return true;
    }

    private String getRewardMessage(FriendFissionRewardReplyConfig replyConfig) {
        if (replyConfig == null) {
            log.warn("Reply config is null");
            return "";
        }
        ArrayList replyMessages = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)replyConfig.getReplyMessages())) {
            log.info("Append reply message:{}", (Object)replyConfig.getReplyMessages());
            replyMessages.addAll(replyConfig.getReplyMessages());
        } else {
            log.info("No reply message found.");
        }
        if (StringUtils.isNotBlank((CharSequence)replyConfig.getDataPacketUrl())) {
            log.info("Append data pack, name={}, url={}", (Object)replyConfig.getDataPacketName(), (Object)replyConfig.getDataPacketUrl());
            CommonMessage commonMessage = new CommonMessage();
            commonMessage.setType(Integer.valueOf(AutoReplyMessageType.FILE.getValue()));
            commonMessage.setSeq(Integer.valueOf(replyMessages.size() + 1));
            FileDto msg = new FileDto();
            msg.setTitle(replyConfig.getDataPacketName());
            msg.setUrl(replyConfig.getDataPacketUrl());
            commonMessage.setContent(JacksonUtil.obj2Str((Object)msg));
            replyMessages.add(commonMessage);
        } else {
            log.info("No data pack found.");
        }
        InviteToChatRoomDto invite = replyConfig.getInviteToChatRoomDto();
        ReplyJoinGroupCardDto card = this.getReplyJoinGroupCard(invite);
        if (card != null) {
            log.info("Append join group card={}", (Object)card);
            CommonMessage commonMessage = new CommonMessage();
            commonMessage.setType(Integer.valueOf(AutoReplyMessageType.JOIN_GROUP_CARD.getValue()));
            commonMessage.setSeq(Integer.valueOf(replyMessages.size() + 1));
            commonMessage.setContent(JacksonUtil.obj2Str((Object)card));
            replyMessages.add(commonMessage);
        } else {
            log.info("No invite to room config, params={}", (Object)invite);
        }
        if (CollectionUtils.isEmpty((Collection)replyMessages)) {
            log.warn("No reply message found.");
            return "";
        }
        ReplyMessageDto replyMessageDto = new ReplyMessageDto((List)replyMessages);
        String message = JacksonUtil.obj2Str((Object)replyMessageDto);
        return message;
    }

    private ReplyJoinGroupCardDto getReplyJoinGroupCard(InviteToChatRoomDto params) {
        ReplyContext ctx = ReplyContextUtil.get();
        String wechatId = ctx.getWechatId();
        if (params == null) {
            log.warn("\u9080\u8bf7\u597d\u53cb\u52a0\u7fa4\u7684\u53c2\u6570\u4e3a\u7a7a, params={}", (Object)params);
            return null;
        }
        if (!Objects.equals(params.getWasOpenForwardChatRoom(), 1)) {
            log.warn("\u672a\u5f00\u542f\u9080\u8bf7\u5165\u7fa4, params={}", (Object)params);
            return null;
        }
        List list = params.getWechatIdAndChatRoomIdsDtoList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.warn("\u9080\u8bf7\u597d\u53cb\u52a0\u7fa4\u7684\u53c2\u6570\u4e3a\u7a7a, params={}", (Object)params);
            return null;
        }
        RobotToRoomDto room = null;
        for (WechatIdAndChatRoomIdsDto dto : list) {
            if (!wechatId.equals(dto.getWechatId())) continue;
            room = new RobotToRoomDto();
            room.setWechatId(dto.getWechatId());
            room.setChatroomIds(dto.getChatRoomIds());
        }
        if (room == null) {
            log.warn("\u627e\u4e0d\u5230\u5f53\u524d\u673a\u5668\u4eba\u7684\u9080\u8bf7\u5165\u7fa4\u914d\u7f6e, wechatId={}, params", (Object)wechatId, (Object)params);
            return null;
        }
        ReplyJoinGroupCardDto result = new ReplyJoinGroupCardDto();
        result.setChatroomMaxMemberCount(Integer.valueOf(500));
        result.setList(Collections.singletonList(room));
        return result;
    }
}

