/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.marketing;

import com.google.common.collect.Lists;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfig;
import com.kuaike.skynet.logic.dal.market.mapper.MarketReplyConfigMapper;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessage;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessageMember;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicIntervalSendMessageMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicIntervalSendMessageMemberMapper;
import com.kuaike.skynet.logic.handler.common.MsgDigestHelper;
import com.kuaike.skynet.logic.handler.marketing.MarketingContactStatusHandler;
import com.kuaike.skynet.logic.handler.marketing.MarketingTrafficLevelHelper;
import com.kuaike.skynet.logic.service.common.SettingService;
import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.common.dto.ReplyMessageDto;
import com.kuaike.skynet.logic.service.common.enums.IntervalMessageReplyTypeEnum;
import com.kuaike.skynet.logic.service.common.enums.MarketReplyConfigType;
import com.kuaike.skynet.logic.service.common.enums.MarketingPlanType;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.marketing.dto.DrainageJoinFriendReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.InviteToChatRoomDto;
import com.kuaike.skynet.logic.service.marketing.dto.WechatIdAndChatRoomIdsDto;
import com.kuaike.skynet.logic.service.reply.dto.FileDto;
import com.kuaike.skynet.logic.service.reply.dto.ReplyJoinGroupCardDto;
import com.kuaike.skynet.logic.service.reply.dto.RobotToRoomDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyMessageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DrainageFriendReplyHandler {
    private static final Logger log = LoggerFactory.getLogger(DrainageFriendReplyHandler.class);
    @Autowired
    private MarketReplyConfigMapper marketReplyConfigMapper;
    @Autowired
    private MarketingContactStatusHandler marketingContactStatusHandler;
    @Autowired
    private LogicIntervalSendMessageMapper logicIntervalSendMessageMapper;
    @Autowired
    private LogicIntervalSendMessageMemberMapper logicIntervalSendMessageMemberMapper;
    @Autowired
    private MarketingTrafficLevelHelper marketingTrafficLevelHelper;
    @Autowired
    private MsgDigestHelper msgDigestHelper;
    @Autowired
    private SettingService settingService;

    public void onWaitJoinFriendEvent(WechatMessage wechatMessage) {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("on wait join friend event, requestId={}", (Object)ctx.getRequestId());
        String wechatId = ctx.getWechatId();
        Long businessCustomerId = ctx.getBusinessCustomerId();
        Long planId = this.marketReplyConfigMapper.getDrainageFriendPlanId(businessCustomerId, wechatId, Integer.valueOf(MarketReplyConfigType.WECHAT_DRAINAGE_WECHATID.getValue()), new Date());
        if (planId == null) {
            log.info("No effective drainage plan found, businessCustomerId={}, wechatId={}", (Object)businessCustomerId, (Object)wechatId);
            return;
        }
        this.marketingContactStatusHandler.onWaitJoinFriendEvent(MarketingPlanType.WECHAT_DRAINAGE_PLAN, planId);
    }

    public boolean onFriendIsJoined(WechatMessage wechatMessage) {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("on friend is joined, requestId={}", (Object)ctx.getRequestId());
        Long planId = this.marketReplyConfigMapper.getDrainageFriendPlanId(ctx.getBusinessCustomerId(), ctx.getWechatId(), Integer.valueOf(MarketReplyConfigType.WECHAT_DRAINAGE_WECHATID.getValue()), new Date());
        if (planId == null) {
            log.info("No effective drainage plan found, businessCustomerId={}, wechatId={}", (Object)ctx.getBusinessCustomerId(), (Object)ctx.getWechatId());
            return false;
        }
        this.marketingContactStatusHandler.onFriendIsJoined(MarketingPlanType.WECHAT_DRAINAGE_PLAN, planId);
        MarketReplyConfig config = this.marketReplyConfigMapper.getDrainageWechatFriendPlanId(planId, Integer.valueOf(MarketReplyConfigType.WECHAT_DRAINAGE_ADD_FRIEND_REPLY.getValue()));
        if (config == null) {
            log.info("No join friend reply found, planId={}", (Object)planId);
            return false;
        }
        DrainageJoinFriendReplyConfig replyConfig = null;
        try {
            replyConfig = (DrainageJoinFriendReplyConfig)JacksonUtil.str2Obj((String)config.getJsonText(), DrainageJoinFriendReplyConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("Failed parsing drainage join friend reply, config={}", (Object)config, (Object)e);
        }
        this.marketingTrafficLevelHelper.onFriendIsJoined(config.getLevelId(), replyConfig.getCategoryTags());
        boolean flag = this.createJoinFriendReply(planId, config, replyConfig);
        return flag;
    }

    private String getJoinFriendReplyMessage(DrainageJoinFriendReplyConfig replyConfig) {
        if (replyConfig == null) {
            log.warn("Reply config is null");
            return "";
        }
        ArrayList replyMessages = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)replyConfig.getAddFriendReplyMessages())) {
            log.info("Append reply message:{}", (Object)replyConfig.getAddFriendReplyMessages());
            replyMessages.addAll(replyConfig.getAddFriendReplyMessages());
        } else {
            log.info("No reply message found.");
        }
        if (StringUtils.isNotBlank((CharSequence)replyConfig.getDataPacketUrl())) {
            log.info("Append data pack, name={}, url={}", (Object)replyConfig.getDataPacketName(), (Object)replyConfig.getDataPacketUrl());
            CommonMessage commonMessage = new CommonMessage();
            commonMessage.setType(Integer.valueOf(AutoReplyMessageType.FILE.getValue()));
            commonMessage.setSeq(Integer.valueOf(replyMessages.size() + 1));
            FileDto msg = new FileDto();
            msg.setTitle(replyConfig.getDataPacketName());
            msg.setUrl(replyConfig.getDataPacketUrl());
            commonMessage.setContent(JacksonUtil.obj2Str((Object)msg));
            replyMessages.add(commonMessage);
        } else {
            log.info("No data pack found");
        }
        InviteToChatRoomDto invite = replyConfig.getInviteToChatRoomDto();
        ReplyJoinGroupCardDto card = this.getReplyJoinGroupCard(invite);
        if (card != null) {
            log.info("Append join group card={}", (Object)card);
            CommonMessage commonMessage = new CommonMessage();
            commonMessage.setType(Integer.valueOf(AutoReplyMessageType.JOIN_GROUP_CARD.getValue()));
            commonMessage.setSeq(Integer.valueOf(replyMessages.size() + 1));
            commonMessage.setContent(JacksonUtil.obj2Str((Object)card));
            replyMessages.add(commonMessage);
        } else {
            log.info("No invite to room config, params={}", (Object)invite);
        }
        if (CollectionUtils.isEmpty((Collection)replyMessages)) {
            log.warn("No reply message found.");
            return "";
        }
        ReplyMessageDto replyMessageDto = new ReplyMessageDto((List)replyMessages);
        String message = JacksonUtil.obj2Str((Object)replyMessageDto);
        return message;
    }

    private ReplyJoinGroupCardDto getReplyJoinGroupCard(InviteToChatRoomDto params) {
        ReplyContext ctx = ReplyContextUtil.get();
        String wechatId = ctx.getWechatId();
        if (params == null) {
            log.warn("\u9080\u8bf7\u597d\u53cb\u52a0\u7fa4\u7684\u53c2\u6570\u4e3a\u7a7a, params={}", (Object)params);
            return null;
        }
        if (!Objects.equals(params.getWasOpenForwardChatRoom(), 1)) {
            log.warn("\u672a\u5f00\u542f\u9080\u8bf7\u5165\u7fa4, params={}", (Object)params);
            return null;
        }
        List list = params.getWechatIdAndChatRoomIdsDtoList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.warn("\u9080\u8bf7\u597d\u53cb\u52a0\u7fa4\u7684\u53c2\u6570\u4e3a\u7a7a, params={}", (Object)params);
            return null;
        }
        RobotToRoomDto room = null;
        for (WechatIdAndChatRoomIdsDto dto : list) {
            if (!wechatId.equals(dto.getWechatId())) continue;
            room = new RobotToRoomDto();
            room.setWechatId(dto.getWechatId());
            room.setChatroomIds(dto.getChatRoomIds());
        }
        if (room == null) {
            log.warn("\u627e\u4e0d\u5230\u5f53\u524d\u673a\u5668\u4eba\u7684\u9080\u8bf7\u5165\u7fa4\u914d\u7f6e, wechatId={}, params", (Object)wechatId, (Object)params);
            return null;
        }
        ReplyJoinGroupCardDto result = new ReplyJoinGroupCardDto();
        result.setChatroomMaxMemberCount(Integer.valueOf(500));
        result.setList(Collections.singletonList(room));
        return result;
    }

    private boolean createJoinFriendReply(Long planId, MarketReplyConfig config, DrainageJoinFriendReplyConfig replyConfig) {
        ReplyContext ctx = ReplyContextUtil.get();
        String message = this.getJoinFriendReplyMessage(replyConfig);
        if (StringUtils.isBlank((CharSequence)message)) {
            return false;
        }
        String digest = SHA1Utils.digest((String)message);
        if (this.msgDigestHelper.isCached(digest)) {
            return true;
        }
        LogicIntervalSendMessage send = new LogicIntervalSendMessage();
        send.setWechatId(ctx.getWechatId());
        send.setWechatRoomName("");
        send.setMessage(message);
        send.setReplyType(Integer.valueOf(IntervalMessageReplyTypeEnum.DRAINAGE_JOIN_FRIEND.getValue()));
        send.setFissionPlanId(planId);
        send.setMemberInterval(Integer.valueOf(0));
        send.setIntervalAudiTime(Integer.valueOf(0));
        Integer sendIntervalTime = this.settingService.getFriendSendIntervalTime(ctx.getBusinessCustomerId());
        send.setSendTime(new Date(System.currentTimeMillis() + (long)sendIntervalTime.intValue() * 1000L));
        this.logicIntervalSendMessageMapper.insertSelective((Object)send);
        LogicIntervalSendMessageMember sendMember = new LogicIntervalSendMessageMember();
        sendMember.setIntervalSendMessageId(send.getId());
        sendMember.setWechatRoomName("");
        sendMember.setMemberWechatId(ctx.getTalkerId());
        this.logicIntervalSendMessageMemberMapper.insertSelective((Object)sendMember);
        this.msgDigestHelper.cache(digest);
        return true;
    }
}

