/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.common;

import com.google.common.collect.Sets;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.service.common.SettingService;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MsgDigestHelper {
    private static final Logger log = LoggerFactory.getLogger(MsgDigestHelper.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Autowired
    private SettingService settingService;

    private String friendKey(Long businessCustomerId, String wechatId, String talkerId) {
        return this.redisKeyPrefix + String.format("mdc:f:%d:%s:%s", businessCustomerId, wechatId, talkerId);
    }

    private String groupKey(Long businessCustomerId, String chatroomId) {
        return this.redisKeyPrefix + String.format("mdc:g:%d:%s", businessCustomerId, chatroomId);
    }

    public String redisKey() {
        ReplyContext ctx = ReplyContextUtil.get();
        if (ctx.getTalkerType() == 1) {
            return this.friendKey(ctx.getBusinessCustomerId(), ctx.getWechatId(), ctx.getTalkerId());
        }
        return this.groupKey(ctx.getBusinessCustomerId(), ctx.getChatroomId());
    }

    private Integer friendExpired(Long businessCustomerId) {
        boolean deduplicateEnabled = this.settingService.getFriendReplyDeduplicateEnabled(businessCustomerId);
        Integer deduplicateTime = this.settingService.getFriendReplyDeduplicateTime(businessCustomerId);
        if (deduplicateEnabled && deduplicateTime > 0) {
            return deduplicateTime;
        }
        return -1;
    }

    private Integer groupExpired(Long businessCustomerId) {
        boolean deduplicateEnabled = this.settingService.getGroupReplyDeduplicateEnabled(businessCustomerId);
        Integer deduplicateTime = this.settingService.getGroupReplyDeduplicateTime(businessCustomerId);
        if (deduplicateEnabled && deduplicateTime > 0) {
            return deduplicateTime;
        }
        return -1;
    }

    public Integer expire() {
        ReplyContext ctx = ReplyContextUtil.get();
        if (ctx.getTalkerType() == 1) {
            return this.friendExpired(ctx.getBusinessCustomerId());
        }
        return this.groupExpired(ctx.getBusinessCustomerId());
    }

    public Set<String> isCached(List<String> digests) {
        log.info("Query cached digests={}", digests);
        long seconds = this.expire().intValue();
        if (seconds <= 0L) {
            log.info("message deduplicate is disabled, expire={}", (Object)seconds);
            return Collections.emptySet();
        }
        String key = this.redisKey();
        Map map = null;
        try {
            HashOperations hash = this.redisTemplate.opsForHash();
            map = hash.entries((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed get redis, key={}", (Object)key, (Object)e);
        }
        if (map == null || map.isEmpty()) {
            log.info("No cached digests found, key={}", (Object)key);
            return Collections.emptySet();
        }
        long now = System.currentTimeMillis() / 1000L;
        HashSet result = Sets.newHashSet();
        for (String digest : digests) {
            long timestamp;
            if (!map.containsKey(digest)) continue;
            String value = (String)map.get(digest);
            try {
                timestamp = Long.parseLong(value);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Failed parsing digest timestamp={}", (Object)value, (Object)e);
                continue;
            }
            if (now > timestamp + seconds) continue;
            result.add(digest);
        }
        if (result.size() > 0) {
            log.info("These digests is cached, key={}, result={}", (Object)key, (Object)result);
        }
        return result;
    }

    public boolean isCached(String digest) {
        long timestamp;
        long seconds = this.expire().intValue();
        if (seconds <= 0L) {
            log.info("message deduplicate is disabled, expire={}", (Object)seconds);
            return false;
        }
        String key = this.redisKey();
        String value = null;
        try {
            HashOperations hash = this.redisTemplate.opsForHash();
            value = (String)hash.get((Object)key, (Object)digest);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed get redis, key={}, digest={}", new Object[]{key, digest, e});
        }
        if (value == null) {
            log.info("No cached digest found, key={}, digest={}", (Object)key, (Object)digest);
            return false;
        }
        try {
            timestamp = Long.parseLong(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed parsing digest timestamp={}", (Object)value, (Object)e);
            return false;
        }
        long now = System.currentTimeMillis() / 1000L;
        if (now > timestamp + seconds) {
            return false;
        }
        log.info("This message is cached, key={}, digest={}, createTime={}", new Object[]{key, digest, timestamp});
        return true;
    }

    public void cache(String digest) {
        long seconds = this.expire().intValue();
        if (seconds <= 0L) {
            return;
        }
        String key = this.redisKey();
        log.info("cache message digest, key={}, digest={}, seconds={}", new Object[]{key, digest, seconds});
        long timestamp = System.currentTimeMillis() / 1000L;
        String value = "" + timestamp;
        try {
            HashOperations hash = this.redisTemplate.opsForHash();
            hash.put((Object)key, (Object)digest, (Object)value);
            this.redisTemplate.expire((Object)key, seconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed cache message key={}, digest={}", new Object[]{key, digest, e});
        }
    }
}

