/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.biz;

import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.wechat.enums.WechatAccountType;
import com.kuaike.skynet.logic.handler.common.ReplyMsgSendHelper;
import com.kuaike.skynet.logic.service.cache.ReplyOptionCacheService;
import com.kuaike.skynet.logic.service.cache.WechatAccountCacheService;
import com.kuaike.skynet.logic.service.cache.dto.CachedOption;
import com.kuaike.skynet.logic.service.cache.dto.CachedReplyMsg;
import com.kuaike.skynet.logic.service.common.SettingService;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplyOptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ReplyOptionHandler.class);
    @Autowired
    private ReplyMsgSendHelper replyMsgSendHelper;
    @Autowired
    private ReplyOptionCacheService replyOptionCacheService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private WechatAccountCacheService wechatAccountCacheService;

    public boolean recvGroupText(WechatMessage wechatMessage, String text, List<String> atUsers) {
        log.info("reply option with num={}, atUsers={}", (Object)text, atUsers);
        if (text == null || !StringUtils.isNumeric((CharSequence)text.trim())) {
            log.info("Not number, text={}", (Object)text);
            return false;
        }
        String wechatId = wechatMessage.getWechatId();
        String chatroomId = wechatMessage.getTalkerId();
        String chatroomTalkerId = wechatMessage.getChatroomTalkerId();
        Long businessCustomerId = this.wechatAccountCacheService.getBusinessCustomerId(wechatId);
        String redisKey = this.replyOptionCacheService.getReplyOptionKey(businessCustomerId, chatroomId, chatroomTalkerId);
        CachedOption cache = this.replyOptionCacheService.getCachedOption(redisKey);
        CachedReplyMsg result = this.replyOptionCacheService.getValidOption(cache, text);
        if (result == null) {
            log.info("No valid option found with cache={}, num={}", (Object)cache, (Object)text);
            return false;
        }
        Long buId = this.wechatAccountCacheService.getBusinessCustomerId(cache.getWId());
        if (!businessCustomerId.equals(buId)) {
            log.info("reply option cache buid={} different from cached bot buId={}, cache={}", new Object[]{businessCustomerId, buId, cache});
            return false;
        }
        if (this.wechatAccountCacheService.isType(cache.getWId(), WechatAccountType.ATMOSPHERE_ROBOT)) {
            log.info("cached wid becomme atmosphere robot, ignore this cache. wid={}", (Object)cache.getWId());
            return false;
        }
        boolean needAtRobot = this.settingService.needAtRobot(businessCustomerId);
        if (needAtRobot && CollectionUtils.isEmpty(atUsers)) {
            log.info("Need @robot but not found");
            return false;
        }
        if (CollectionUtils.isNotEmpty(atUsers) && !atUsers.contains(cache.getWId())) {
            log.info("Need @wechatId={} but not found {}", (Object)cache.getWId(), atUsers);
            return false;
        }
        List<String> preferredWechatIds = Collections.singletonList(cache.getWId());
        return this.replyMsgSendHelper.sendGroupMsg(preferredWechatIds, cache.getText(), null, result);
    }

    public boolean recvFriendText() {
        ReplyContext ctx = ReplyContextUtil.get();
        String text = ctx.getPureMsg();
        String wechatId = ctx.getWechatId();
        String talkerId = ctx.getTalkerId();
        Long businessCustomerId = ctx.getBusinessCustomerId();
        if (!StringUtils.isNumeric((CharSequence)text)) {
            return false;
        }
        log.info("reply option with num={}", (Object)text);
        String redisKey = this.replyOptionCacheService.getReplyOptionKey(businessCustomerId, wechatId, talkerId);
        CachedOption cache = this.replyOptionCacheService.getCachedOption(redisKey);
        CachedReplyMsg result = this.replyOptionCacheService.getValidOption(cache, text);
        if (result == null) {
            log.info("No valid option found with cache={}, num={}", (Object)cache, (Object)text);
            return false;
        }
        return this.replyMsgSendHelper.sendFriendMsg(cache.getText(), null, result);
    }
}

