/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.biz;

import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWechatRoom;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessage;
import com.kuaike.skynet.logic.dal.reply.entity.LogicJoinGroupReplyConfig;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWechatRoomMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicJoinGroupReplyConfigMapper;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoom;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomMapper;
import com.kuaike.skynet.logic.handler.common.GroupJoinReplyHelper;
import com.kuaike.skynet.logic.service.common.enums.IntervalMessageReplyTypeEnum;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyType;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupJoinedReplyHandler {
    private static final Logger log = LoggerFactory.getLogger(GroupJoinedReplyHandler.class);
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicJoinGroupReplyConfigMapper logicJoinGroupReplyConfigMapper;
    @Autowired
    private LogicAutoReplyWechatRoomMapper logicAutoReplyWechatRoomMapper;
    @Autowired
    private GroupJoinReplyHelper helper;
    @Autowired
    private WechatChatRoomMapper wechatChatRoomMapper;

    public boolean onJoinGroup() {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("Receive join group, requestId={}", (Object)ctx.getRequestId());
        List<String> memberIds = ctx.getJoinGroupWithoutRobotWechatIds();
        if (CollectionUtils.isEmpty(memberIds)) {
            log.info("No memberIds found, requestId={}. Maybe they are robot or in blacklist, buId={}, wechatIds={}", new Object[]{ctx.getRequestId(), ctx.getBusinessCustomerId(), ctx.getJoinGroupWechatIds()});
            return false;
        }
        LogicAutoReply reply = this.logicAutoReplyMapper.queryReplyByWechatRoomName(ctx.getBusinessCustomerId(), ctx.getChatroomId(), Integer.valueOf(AutoReplyType.JOIN_GROUP_REPLY.getValue()));
        if (reply == null) {
            log.info("No join grouy reply found, requestId={}, chatroomId={}", (Object)ctx.getRequestId(), (Object)ctx.getChatroomId());
            return false;
        }
        if (reply.getEnabled() == null || reply.getEnabled() == 0) {
            log.info("Auto reply is disabled for requestId={}, replyId={}", (Object)ctx.getRequestId(), (Object)reply.getId());
            return false;
        }
        if (StringUtils.isBlank((CharSequence)reply.getMessage())) {
            log.info("No message found, requestId={}, replyId={}", (Object)ctx.getRequestId(), (Object)reply.getId());
            return false;
        }
        LogicJoinGroupReplyConfig config = this.logicJoinGroupReplyConfigMapper.getByAutoReplyId(reply.getId());
        Integer timeIntervalMin = null;
        Integer timeIntervalMax = null;
        Integer memberInterval = null;
        if (config != null) {
            timeIntervalMin = config.getTimeIntervalMin();
            timeIntervalMax = config.getTimeIntervalMax();
            memberInterval = config.getMemberInterval();
        } else {
            log.warn("No join group reply config found, requestId={}, replyId={}", (Object)ctx.getRequestId(), (Object)reply.getId());
        }
        Date sendTime = GroupJoinReplyHelper.getRandSendTime(timeIntervalMin, timeIntervalMax);
        memberInterval = GroupJoinReplyHelper.memberInterval(memberInterval);
        LogicIntervalSendMessage message = this.helper.get(ctx.getChatroomId(), IntervalMessageReplyTypeEnum.JOIN_GROUP);
        if (message == null) {
            String roomId;
            WechatChatRoom chatRoom;
            String wechatId = ctx.getWechatId();
            LogicAutoReplyWechatRoom replyWechatRoom = this.logicAutoReplyWechatRoomMapper.queryByReplyId(reply.getId(), ctx.getChatroomId());
            if (replyWechatRoom != null && (chatRoom = this.wechatChatRoomMapper.queryByName(roomId = replyWechatRoom.getWechatRoomName())) != null) {
                String members = chatRoom.getMemberList();
                if (replyWechatRoom.getReplyWechatId() != null && members.contains(replyWechatRoom.getReplyWechatId())) {
                    wechatId = replyWechatRoom.getReplyWechatId();
                }
            }
            log.info("Receive join group, reply wechatId: {}, chatroom: {}, requestId: {}", new Object[]{wechatId, ctx.getChatroomId(), ctx.getRequestId()});
            if (StringUtils.isNotEmpty((CharSequence)ctx.getRequestId()) && StringUtils.isNotEmpty((CharSequence)wechatId) && ctx.getRequestId().contains(wechatId)) {
                message = this.helper.newJoinGroupMessage(wechatId, ctx.getChatroomId(), reply.getMessage(), sendTime, memberInterval);
            }
        }
        if (message != null) {
            this.helper.saveMembers(message.getId(), ctx.getChatroomId(), memberIds);
        }
        return true;
    }
}

