/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.biz;

import com.google.common.collect.Lists;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessage;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessageMember;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicIntervalSendMessageMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicIntervalSendMessageMemberMapper;
import com.kuaike.skynet.logic.handler.common.MsgDigestHelper;
import com.kuaike.skynet.logic.service.cache.WechatAccountCacheService;
import com.kuaike.skynet.logic.service.common.SettingService;
import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.common.dto.ReplyMessageDto;
import com.kuaike.skynet.logic.service.common.enums.IntervalMessageReplyTypeEnum;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class FriendJoinedReplyHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendJoinedReplyHandler.class);
    @Autowired
    private SettingService settingService;
    @Autowired
    private MsgDigestHelper msgDigestHelper;
    @Autowired
    private WechatAccountCacheService wechatAccountCacheService;
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicIntervalSendMessageMapper logicIntervalSendMessageMapper;
    @Autowired
    private LogicIntervalSendMessageMemberMapper logicIntervalSendMessageMemberMapper;

    public boolean onFriendIsJoinedEvent(WechatMessage wechatMessage) {
        return this.handle(wechatMessage);
    }

    public boolean onJoinedByFriendEvent(WechatMessage wechatMessage) {
        return this.handle(wechatMessage);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean handle(WechatMessage wechatMessage) {
        log.info("Reply on join friend, message:{}", (Object)wechatMessage.getMessage());
        String wechatId = wechatMessage.getWechatId();
        String talkerId = wechatMessage.getTalkerId();
        Long buId = this.wechatAccountCacheService.getBusinessCustomerId(wechatId);
        if (buId == null) {
            log.warn("wechatId not belone to any buId, wechatId={}", (Object)wechatId);
            return false;
        }
        LogicAutoReply logicAutoReply = this.logicAutoReplyMapper.selectAddFriendAutoReplyConfig(wechatId, buId);
        if (logicAutoReply == null || StringUtils.isBlank((CharSequence)logicAutoReply.getMessage())) {
            log.info("No auto reply message found for wechatId={}", (Object)wechatId);
            return false;
        }
        if (logicAutoReply.getEnabled() == null || logicAutoReply.getEnabled() == 0) {
            log.info("Auto reply is disabled wechatId={}", (Object)wechatId);
            return false;
        }
        String digest = SHA1Utils.digest((String)logicAutoReply.getMessage());
        if (this.msgDigestHelper.isCached(digest)) {
            return false;
        }
        ReplyMessageDto dto = this.replyMessageDtoService.toReplyMessageDto(logicAutoReply.getMessage());
        if (dto == null || CollectionUtils.isEmpty((Collection)dto.getReplyMessage())) {
            log.warn("Reply message is empty. logicAutoReply={}", (Object)logicAutoReply.getId());
            return false;
        }
        log.info("Add friend reply with logicAutoReply={}", (Object)logicAutoReply.getId());
        boolean saved = false;
        int totalDelay = this.totalDelay(dto.getReplyMessage());
        saved = totalDelay > 0 ? this.createSplitMessage(wechatId, talkerId, dto.getReplyMessage()) : this.createSingleMessage(wechatId, talkerId, logicAutoReply.getMessage());
        if (saved) {
            this.msgDigestHelper.cache(digest);
        }
        return saved;
    }

    private int totalDelay(List<CommonMessage> list) {
        int totalDelay = 0;
        for (CommonMessage dto : list) {
            totalDelay += dto.getDelay();
        }
        return totalDelay;
    }

    private boolean createSplitMessage(String wechatId, String talkerId, List<CommonMessage> list) {
        log.info("create split reply message, wechatId={}, talkerId={}, list={}", new Object[]{wechatId, talkerId, list});
        int size = list.size();
        ArrayList splitReplyMessage = Lists.newArrayListWithCapacity((int)size);
        ArrayList tmpList = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            CommonMessage msg = list.get(i);
            int delay = msg.getDelay();
            if (i != 0 && delay > 0) {
                splitReplyMessage.add(new ReplyMessageDto((List)tmpList));
                tmpList = Lists.newArrayList();
            }
            tmpList.add(msg);
        }
        if (tmpList.size() > 0) {
            splitReplyMessage.add(new ReplyMessageDto((List)tmpList));
        }
        Long businessCustomerId = this.wechatAccountCacheService.getBusinessCustomerId(wechatId);
        int sendDelay = this.settingService.getFriendSendIntervalTime(businessCustomerId);
        long sendStartTime = System.currentTimeMillis() + (long)(sendDelay * 1000);
        int totalDelay = 0;
        ArrayList sendMessageList = Lists.newArrayListWithCapacity((int)splitReplyMessage.size());
        for (ReplyMessageDto tmp : splitReplyMessage) {
            int delay = ((CommonMessage)tmp.getReplyMessage().get(0)).getDelay();
            long sendTimeInMillis = sendStartTime + (long)((totalDelay += delay) * 1000);
            Date sendTime = new Date(sendTimeInMillis);
            String message = JacksonUtil.obj2Str((Object)tmp);
            LogicIntervalSendMessage sendMsgRecord = this.newLogicIntervalSendMessage(wechatId, message, sendTime);
            sendMessageList.add(sendMsgRecord);
        }
        try {
            this.saveAll(sendMessageList, talkerId);
            return true;
        }
        catch (Exception e) {
            log.info("Failed saving add friend reply message, wechatId={}, talkerId={}, list={}", new Object[]{wechatId, talkerId, sendMessageList});
            e.printStackTrace();
            return false;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    private void saveAll(List<LogicIntervalSendMessage> list, String talkerId) {
        log.info("Save split interval send messages, list={}", list);
        this.logicIntervalSendMessageMapper.batchInsert(list);
        ArrayList sendMemberList = Lists.newArrayListWithCapacity((int)list.size());
        for (LogicIntervalSendMessage sendMessage : list) {
            sendMemberList.add(this.newLogicIntervalSendMessageMember(sendMessage.getId(), talkerId));
        }
        this.logicIntervalSendMessageMemberMapper.batchInsert((List)sendMemberList);
    }

    private boolean createSingleMessage(String wechatId, String talkerId, String message) {
        log.info("create single reply message, wechatId={}, talkerId={}, message={}", new Object[]{wechatId, talkerId, message});
        Long businessCustomerId = this.wechatAccountCacheService.getBusinessCustomerId(wechatId);
        int sendDelay = this.settingService.getFriendSendIntervalTime(businessCustomerId);
        long sendStartTime = System.currentTimeMillis() + (long)(sendDelay * 1000);
        LogicIntervalSendMessage msg = this.newLogicIntervalSendMessage(wechatId, message, new Date(sendStartTime));
        try {
            this.save(msg, talkerId);
            return true;
        }
        catch (Exception e) {
            log.info("Failed saving add friend reply message, wechatId={}, talkerId={}, list={}", new Object[]{wechatId, talkerId, message});
            e.printStackTrace();
            return false;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    private void save(LogicIntervalSendMessage sendMessage, String talkerId) {
        log.info("Save single interval send message, sendMessage={}", (Object)sendMessage);
        this.logicIntervalSendMessageMapper.insertSelective((Object)sendMessage);
        LogicIntervalSendMessageMember sendMsgMemberRecord = this.newLogicIntervalSendMessageMember(sendMessage.getId(), talkerId);
        this.logicIntervalSendMessageMemberMapper.insertSelective((Object)sendMsgMemberRecord);
    }

    private LogicIntervalSendMessage newLogicIntervalSendMessage(String wechatId, String message, Date sendTime) {
        log.info("new logic interval send message with wechatId={}, message={}, sendTime={}", new Object[]{wechatId, message, sendTime});
        LogicIntervalSendMessage result = new LogicIntervalSendMessage();
        result.setWechatId(wechatId);
        result.setMessage(message);
        result.setSendTime(sendTime);
        result.setWechatRoomName("");
        result.setReplyType(Integer.valueOf(IntervalMessageReplyTypeEnum.LOGIC_AUTO_REPLY_JOIN_FRIEND.getValue()));
        result.setFissionPlanId(Long.valueOf(0L));
        result.setFissionCategoryId(Long.valueOf(0L));
        result.setMemberInterval(Integer.valueOf(0));
        return result;
    }

    private LogicIntervalSendMessageMember newLogicIntervalSendMessageMember(Long sendMessageId, String talkerId) {
        LogicIntervalSendMessageMember result = new LogicIntervalSendMessageMember();
        result.setIntervalSendMessageId(sendMessageId);
        result.setWechatRoomName("");
        result.setMemberWechatId(talkerId);
        return result;
    }
}

