/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.biz;

import com.google.common.collect.Lists;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.friend.entity.NewFriendGroupConfig;
import com.kuaike.skynet.logic.dal.friend.mapper.NewFriendGroupConfigMapper;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatAccountGroupRelation;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatAccountGroupRelationCriteria;
import com.kuaike.skynet.logic.dal.wechat.mapper.MarketingTrafficLevelMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatAccountGroupRelationMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomGroupMapper;
import com.kuaike.skynet.logic.service.common.enums.AddFriendType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FriendAutoGroupHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendAutoGroupHandler.class);
    @Resource
    private NewFriendGroupConfigMapper newFriendGroupConfigMapper;
    @Resource
    private WechatChatRoomGroupMapper wechatChatRoomGroupMapper;
    @Resource
    private WechatAccountGroupRelationMapper wechatAccountGroupRelationMapper;
    @Resource
    private MarketingTrafficLevelMapper marketingTrafficLevelMapper;

    @Transactional
    public void handleActiveAddFriend(WechatMessage wechatMessage) {
        log.info("handleActiveAddFriend params: {}", (Object)wechatMessage);
        this.handleAddGroup(wechatMessage, AddFriendType.INITIATIVE_ADD_FRIEND);
    }

    @Transactional
    public void handlePassiveAddFriend(WechatMessage wechatMessage) {
        log.info("handlePassiveAddFriend params: {}", (Object)wechatMessage);
        this.handleAddGroup(wechatMessage, AddFriendType.PASSIVE_ADD_FRIEND);
    }

    private void handleAddGroup(WechatMessage wechatMessage, AddFriendType addFriendType) {
        String wechatId = wechatMessage.getWechatId();
        String talkerId = wechatMessage.getTalkerId();
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBusinessCustomerId();
        try {
            List<NewFriendGroupConfig> configList = this.queryConfig(bizId, wechatId, addFriendType);
            if (CollectionUtils.isEmpty(configList)) {
                log.info("config is empty");
                return;
            }
            Date startTime = configList.get(0).getStartTime();
            Date endTime = configList.get(0).getEndTime();
            if (startTime == null && endTime != null || startTime != null && endTime == null) {
                log.warn("config time is error");
                return;
            }
            Date currentTime = new Date();
            if (startTime != null && currentTime.before(startTime)) {
                log.info("config time is not start");
                return;
            }
            if (endTime != null && currentTime.after(endTime)) {
                log.info("config time is end");
                return;
            }
            List groupList = configList.stream().map(item -> item.getGroupId()).collect(Collectors.toList());
            HashMap<Long, Long> groupLevelMap = new HashMap<Long, Long>();
            for (NewFriendGroupConfig config : configList) {
                groupLevelMap.put(config.getGroupId(), config.getFlowLevelId());
            }
            if (CollectionUtils.isEmpty((Collection)(groupList = this.wechatChatRoomGroupMapper.queryGroupList(bizId, groupList)))) {
                log.warn("group list is empty");
                return;
            }
            ArrayList levelList = Lists.newArrayList();
            for (Long groupId : groupList) {
                levelList.add(groupLevelMap.get(groupId));
            }
            this.autoAddFriendGroup(bizId, talkerId, groupList, levelList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("handleActiveAddFriend error : {}", (Throwable)e);
        }
    }

    private void autoAddFriendGroup(Long bizId, String wechatId, List<Long> groupIds, List<Long> levelList) {
        log.info("autoAddFriendGroup groupIds: {}, levelIds: {}", groupIds, levelList);
        ArrayList insertList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        Map trafficLevelMap = this.marketingTrafficLevelMapper.queryTrafficLevelMap(bizId);
        for (int i = 0; i < groupIds.size(); ++i) {
            Long groupId = groupIds.get(i);
            Long level = levelList.get(i);
            WechatAccountGroupRelationCriteria example = new WechatAccountGroupRelationCriteria();
            example.createCriteria().andWechatIdEqualTo(wechatId).andGroupIdEqualTo(groupId);
            List existList = this.wechatAccountGroupRelationMapper.selectByExample((Object)example);
            if (CollectionUtils.isEmpty((Collection)existList)) {
                WechatAccountGroupRelation groupRelation = new WechatAccountGroupRelation();
                groupRelation.setWechatId(wechatId);
                groupRelation.setGroupId(groupId);
                groupRelation.setFlowLevelId(level);
                insertList.add(groupRelation);
                continue;
            }
            existList.forEach(exist -> {
                Integer newLevel = trafficLevelMap.getOrDefault(level, 0);
                Integer existLevel = trafficLevelMap.getOrDefault(exist.getFlowLevelId(), 0);
                if (newLevel > existLevel) {
                    exist.setFlowLevelId(level);
                    updateList.add(exist);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            this.wechatAccountGroupRelationMapper.addWechatAccountGroupRelationBatch((List)insertList);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            this.wechatAccountGroupRelationMapper.batchUpdateById((List)updateList);
        }
    }

    private List<NewFriendGroupConfig> queryConfig(Long bizId, String wechatId, AddFriendType addFriendType) {
        return this.newFriendGroupConfigMapper.queryWechatGroupConfig(bizId, wechatId, Integer.valueOf(addFriendType.getValue()));
    }
}

