/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.biz;

import com.google.common.collect.Sets;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.link.service.WechatOpService;
import com.kuaike.skynet.link.service.common.BaseResponse;
import com.kuaike.skynet.link.service.dto.AcceptFriendInnerRequestS;
import com.kuaike.skynet.link.service.dto.AcceptFriendRequestS;
import com.kuaike.skynet.link.service.dto.ContactAdd2WeworkRequestS;
import com.kuaike.skynet.logic.dal.collect.mapper.CollectBlackListMapper;
import com.kuaike.skynet.logic.dal.friend.entity.AcceptFriendLog;
import com.kuaike.skynet.logic.dal.friend.mapper.AcceptFriendLogMapper;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReplyWechat;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyWechatMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatAccountMapper;
import com.kuaike.skynet.logic.service.common.enums.AcceptStatus;
import com.kuaike.skynet.logic.service.common.enums.AcceptStep;
import com.kuaike.skynet.logic.service.common.enums.AddFriendOpStatus;
import com.kuaike.skynet.logic.service.common.utils.JacksonUtils;
import com.kuaike.wework.api.wechat.dto.WeworkAbility;
import com.kuaike.wework.api.wechat.service.WechatService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AcceptFriendHandler {
    private static final Logger log = LoggerFactory.getLogger(AcceptFriendHandler.class);
    @Autowired
    CollectBlackListMapper collectBlackListMapper;
    @Autowired
    AcceptFriendLogMapper acceptFriendLogMapper;
    @Autowired
    WechatOpService wechatOpService;
    @Autowired
    LogicAutoReplyWechatMapper logicAutoReplyWechatMapper;
    @Autowired
    WechatService wechatService;
    @Autowired
    WechatAccountMapper wechatAccountMapper;
    @Value(value="${hasWeworkAddFriendAbility:false}")
    private Boolean hasWeworkAddFriendAbility;
    private static final String passiveAddFriendCheckFlag = "passiveAddFriendCheckFlag";
    private static final String weworkAddFriendFlag = "weworkAddFriendFlag";
    private static final String NOTACCEPT = "\u81ea\u52a8\u901a\u8fc7\u597d\u53cb\u8bf7\u6c42\u5173\u95ed,\u9000\u51fa";
    private static final String WEWORKBUTTONOFF = "\u53bb\u4f01\u4e1a\u5fae\u4fe1\u6dfb\u52a0\u5bf9\u65b9\u6309\u94ae\u5173\u95ed";
    private static final String WEWORKFRIEND = "\u4f01\u5fae\u597d\u53cb\u4e0d\u652f\u6301\u540c\u610f\u6dfb\u52a0";
    private static final String INBLACKLIST = "\u9ed1\u540d\u5355\u7528\u6237";
    private static final String NOBINDWEWORK = "\u673a\u5668\u4eba\u5fae\u4fe1\u672a\u5f00\u901a\u5546\u6237\u4e0b\u7684\u4f01\u5fae\u53f7";
    private static final String NOBINDBIZ = "\u673a\u5668\u4eba\u6240\u5728\u5546\u6237\u4e3a\u5f00\u901a\u4f01\u4e1a\u5fae\u4fe1";
    private static final String JUMPTOWEWORKERROR = "\u673a\u5668\u4eba\u5fae\u4fe1\u8df3\u8f6c\u5230\u4f01\u5fae\u5931\u8d25:";
    private static final String ACCEPTFRIENDERROR = "\u673a\u5668\u4eba\u63a5\u53d7\u597d\u53cb\u8bf7\u6c42\u5931\u8d25:";

    public void handler(WechatMessage wechatMessage) {
        log.info("acceptFriendHandler start");
        AcceptFriendInnerRequestS acceptFriendInnterRequestS = this.buildAcceptFriendRequest(wechatMessage);
        AcceptFriendLog temLog = this.insertAcceptFriendLog(acceptFriendInnterRequestS);
        if (this.filterNotPass(acceptFriendInnterRequestS, temLog)) {
            return;
        }
        Map<String, Object> config = this.queryWechatAcceptFriendConfig(wechatMessage.getWechatId());
        boolean passiveAddFriend = this.getConfigValueWithDefaultTrue(config, passiveAddFriendCheckFlag);
        boolean weworkAddFriend = this.getConfigValueWithDefaultFalse(config, weworkAddFriendFlag);
        boolean canWechatProcess = true;
        if (this.hasWeworkAddFriendAbility != null && this.hasWeworkAddFriendAbility.booleanValue() && weworkAddFriend) {
            canWechatProcess = this.dealReqWithWework(temLog);
        } else {
            this.updateAcceptFriendLog(temLog, null, null, null, AddFriendOpStatus.WAITING.getStatus(), WEWORKBUTTONOFF);
            log.info("not have ability to add wework.weworkAbility={},weworkAddFriend={},acceptFriendLog={}", new Object[]{this.hasWeworkAddFriendAbility, weworkAddFriend, temLog});
        }
        if (canWechatProcess && passiveAddFriend) {
            this.dealReqWithWechat(acceptFriendInnterRequestS, temLog);
        } else {
            log.info("\u81ea\u52a8\u901a\u8fc7\u597d\u53cb\u5f00\u5173\u5173\u95ed,request={}", (Object)acceptFriendInnterRequestS);
            this.updateAcceptFriendLog(temLog, NOTACCEPT, AcceptStatus.EARLY_EXIT, null, null, null);
        }
        log.info("acceptFriendHandler end");
    }

    private void dealReqWithWechat(AcceptFriendInnerRequestS acceptFriendInnterRequestS, AcceptFriendLog temLog) {
        log.info("dealReqWithWechat with acceptFriendInnterRequestS={},temLog={}", (Object)acceptFriendInnterRequestS, (Object)temLog);
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.wechatOpService.acceptFriend((AcceptFriendRequestS)acceptFriendInnterRequestS);
        }
        catch (Exception e) {
            log.error("acceptFriend with error ", (Throwable)e);
            this.updateAcceptFriendLog(temLog, StringUtils.join((Object[])new String[]{ACCEPTFRIENDERROR, e.getMessage()}), AcceptStatus.EXCEPTION, null, null, null);
        }
        log.info("accept friend with req={},response={}", (Object)acceptFriendInnterRequestS, (Object)baseResponse);
    }

    private boolean dealReqWithWework(AcceptFriendLog temLog) {
        log.info("dealReqWithWework with temLog={}", (Object)temLog);
        boolean canWechatProcess = false;
        Long bizId = this.wechatAccountMapper.queryBizIdByWechatId(temLog.getWechatId());
        if (bizId == null) {
            this.updateAcceptFriendLog(temLog, NOBINDBIZ, AcceptStatus.EXCEPTION, null, AddFriendOpStatus.PARAM_ERROR.getStatus(), NOBINDBIZ);
            canWechatProcess = true;
            return canWechatProcess;
        }
        List weworkAbilities = null;
        try {
            weworkAbilities = this.wechatService.queryHaveWeworkAbility((Set)Sets.newHashSet((Object[])new String[]{temLog.getWechatId()}), bizId);
        }
        catch (Exception e) {
            log.error("queryHaveWeworkAbility with error", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(weworkAbilities) || !((WeworkAbility)weworkAbilities.get(0)).isEnableWework()) {
            this.updateAcceptFriendLog(temLog, NOBINDWEWORK, AcceptStatus.EARLY_EXIT, null, AddFriendOpStatus.PARAM_ERROR.getStatus(), NOBINDWEWORK);
            canWechatProcess = true;
            return canWechatProcess;
        }
        ContactAdd2WeworkRequestS contactAdd2WeworkRequestS = this.buildContactAdd2WeworkReq(temLog);
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.wechatOpService.contactAddToWework(contactAdd2WeworkRequestS);
            canWechatProcess = true;
        }
        catch (Exception e) {
            log.error("contactAddToWework with error ", (Throwable)e);
            this.updateAcceptFriendLog(temLog, StringUtils.join((Object[])new String[]{JUMPTOWEWORKERROR, e.getMessage()}), AcceptStatus.EXCEPTION, null, null, null);
            canWechatProcess = false;
        }
        log.info("jumpToWework with req={}, baseResponse:{}", (Object)contactAdd2WeworkRequestS, (Object)baseResponse);
        return canWechatProcess;
    }

    private ContactAdd2WeworkRequestS buildContactAdd2WeworkReq(AcceptFriendLog temLog) {
        ContactAdd2WeworkRequestS contactAdd2WeworkRequestS = new ContactAdd2WeworkRequestS();
        contactAdd2WeworkRequestS.setWId(temLog.getWechatId());
        contactAdd2WeworkRequestS.setMsgSvrId(temLog.getSvrId());
        contactAdd2WeworkRequestS.setTarget(temLog.getTargetWid());
        contactAdd2WeworkRequestS.setTicket(temLog.getTicket());
        contactAdd2WeworkRequestS.setContent(temLog.getApplyContent());
        return contactAdd2WeworkRequestS;
    }

    private Map<String, Object> queryWechatAcceptFriendConfig(String wechatId) {
        LogicAutoReplyWechat logicAutoReplyWechat = this.logicAutoReplyWechatMapper.queryReplyWechatByWechatId(wechatId, 2);
        String configJson = "";
        if (logicAutoReplyWechat == null) {
            log.warn("acceptFriend config is null");
        } else {
            configJson = logicAutoReplyWechat.getExtendConfig();
        }
        Map<String, Object> config = this.jsonStr2Map(configJson);
        return config;
    }

    private AcceptFriendLog insertAcceptFriendLog(AcceptFriendInnerRequestS acceptFriendInnterRequestS) {
        AcceptStatus acceptStatus = AcceptStatus.WAITING;
        String remark = "\u5df2\u5165\u5e93,\u5f85\u540c\u610f";
        AcceptFriendLog temLog = AcceptFriendHandler.buildAcceptFriendLog(acceptFriendInnterRequestS, acceptStatus, remark);
        this.acceptFriendLogMapper.insertSelective((Object)temLog);
        return temLog;
    }

    private void updateAcceptFriendLog(AcceptFriendLog temLog, String remark, AcceptStatus status, AcceptStep step, Integer addFriendOpStatus, String weworkRemark) {
        if (temLog == null || temLog.getId() == null) {
            return;
        }
        if (step != null) {
            temLog.setStep(Integer.valueOf(step.getStep()));
        }
        temLog.setRemark(StringUtils.abbreviate((String)remark, (int)60));
        temLog.setStatus(status != null ? Integer.valueOf(status.getStatus()) : null);
        temLog.setWeworkRemark(weworkRemark);
        temLog.setWeworkStatus(addFriendOpStatus);
        this.acceptFriendLogMapper.updateByPrimaryKeySelective((Object)temLog);
    }

    private boolean filterNotPass(AcceptFriendInnerRequestS acceptFriendInnterRequestS, AcceptFriendLog temLog) {
        if (acceptFriendInnterRequestS.getTargetWid().contains("@openim")) {
            log.info("\u4f01\u4e1a\u5fae\u4fe1\u4e0d\u652f\u6301\u81ea\u52a8\u901a\u8fc7\u597d\u53cb,wid={},targetWid={}", (Object)acceptFriendInnterRequestS.getWId(), (Object)acceptFriendInnterRequestS.getTargetWid());
            this.updateAcceptFriendLog(temLog, WEWORKFRIEND, AcceptStatus.EARLY_EXIT, null, null, null);
            return true;
        }
        int count = this.collectBlackListMapper.queryInBlackList(acceptFriendInnterRequestS.getWId(), acceptFriendInnterRequestS.getTargetWid());
        if (count > 0) {
            log.info("\u5728\u9ed1\u540d\u5355\u4e2d {} {}", (Object)acceptFriendInnterRequestS.getWId(), (Object)acceptFriendInnterRequestS.getTargetWid());
            this.updateAcceptFriendLog(temLog, INBLACKLIST, AcceptStatus.EARLY_EXIT, null, null, null);
            return true;
        }
        return false;
    }

    private Map<String, Object> jsonStr2Map(String configJson) {
        Map config = null;
        if (StringUtils.isEmpty((CharSequence)configJson)) {
            return config;
        }
        try {
            config = (Map)JacksonUtils.getInstance().readValue(configJson, Map.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    private boolean getConfigValueWithDefaultFalse(Map<String, Object> config, String key) {
        boolean booleanValue = false;
        if (config == null) {
            return booleanValue;
        }
        Object object = config.get(key);
        if (object != null) {
            booleanValue = (Boolean)object;
        }
        return booleanValue;
    }

    private boolean getConfigValueWithDefaultTrue(Map<String, Object> config, String key) {
        boolean booleanValue = true;
        if (config == null) {
            return booleanValue;
        }
        Object object = config.get(key);
        if (object != null) {
            booleanValue = (Boolean)object;
        }
        return booleanValue;
    }

    private AcceptFriendInnerRequestS buildAcceptFriendRequest(WechatMessage wechatMessage) {
        AcceptFriendInnerRequestS acceptFriendRequestS = new AcceptFriendInnerRequestS();
        acceptFriendRequestS.setMessageRequestId(wechatMessage.getRequestId());
        acceptFriendRequestS.setSvrId(wechatMessage.getMsgSvrId());
        acceptFriendRequestS.setWId(wechatMessage.getWechatId());
        acceptFriendRequestS.setTargetWid(wechatMessage.getTalkerId());
        String[] arr = this.parseContent(wechatMessage);
        acceptFriendRequestS.setApplyContent(arr[0]);
        acceptFriendRequestS.setTicket(wechatMessage.getTicket());
        acceptFriendRequestS.setControl(true);
        acceptFriendRequestS.setSource(Integer.valueOf(arr[1]));
        acceptFriendRequestS.setSourceId(arr[2]);
        return acceptFriendRequestS;
    }

    private String[] parseContent(WechatMessage wechatMessage) {
        String[] arr = new String[]{"", "", ""};
        try {
            String source;
            String content;
            HashMap map = (HashMap)JacksonUtils.getInstance().getXmlMapper().readValue(wechatMessage.getMessage(), HashMap.class);
            arr[0] = content = this.getFieldValue(map, "content");
            arr[1] = source = this.getFieldValue(map, "scene");
            String chatroomId = this.getFieldValue(map, "chatroomusername");
            String shardCardwxId = this.getFieldValue(map, "sharecardusername");
            String sourcewxId = this.getFieldValue(map, "sourceusername");
            if (StringUtils.isNotEmpty((CharSequence)chatroomId)) {
                arr[2] = chatroomId;
            } else if (StringUtils.isNotEmpty((CharSequence)shardCardwxId)) {
                arr[2] = shardCardwxId;
            } else if (StringUtils.isNotEmpty((CharSequence)sourcewxId)) {
                arr[2] = sourcewxId;
            }
            return arr;
        }
        catch (Exception e) {
            log.error("xml parse error with msg={}", (Object)wechatMessage, (Object)e);
            return arr;
        }
    }

    private String getFieldValue(HashMap map, String key) {
        String value = "";
        Object obj = map.get(key);
        value = obj != null ? (String)obj : "";
        return value;
    }

    public static AcceptFriendLog buildAcceptFriendLog(AcceptFriendInnerRequestS acceptFriendInnerRequestS, AcceptStatus acceptStatus, String remark) {
        AcceptFriendLog log = new AcceptFriendLog();
        log.setApplyContent(acceptFriendInnerRequestS.getApplyContent());
        log.setMessageRequestId(acceptFriendInnerRequestS.getMessageRequestId());
        log.setSource(acceptFriendInnerRequestS.getSource());
        log.setSourceId(acceptFriendInnerRequestS.getSourceId());
        log.setStatus(Integer.valueOf(acceptStatus.getStatus()));
        log.setSvrId(acceptFriendInnerRequestS.getSvrId());
        log.setTargetWid(acceptFriendInnerRequestS.getTargetWid());
        log.setTicket(acceptFriendInnerRequestS.getTicket());
        log.setWechatId(acceptFriendInnerRequestS.getWId());
        log.setRemark(remark);
        log.setStep(Integer.valueOf(AcceptStep.IN_DB.getStep()));
        return log;
    }
}

