/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.link.service.WechatOpService;
import com.kuaike.skynet.link.service.common.BaseResponse;
import com.kuaike.skynet.link.service.common.OpBaseResponse;
import com.kuaike.skynet.link.service.dto.ApproveJoinGroupRequestS;
import com.kuaike.skynet.logic.consumer.AckMessageProducer;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.wechat.enums.WechatAccountType;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomMapper;
import com.kuaike.skynet.logic.handler.biz.GroupJoinedReplyHandler;
import com.kuaike.skynet.logic.handler.biz.GroupKeywordReplyHandler;
import com.kuaike.skynet.logic.handler.biz.ReplyOptionHandler;
import com.kuaike.skynet.logic.handler.common.ReplyMsgSendHelper;
import com.kuaike.skynet.logic.handler.marketing.DrainageGroupReplyHandler;
import com.kuaike.skynet.logic.handler.marketing.FissionGroupReplyHandler;
import com.kuaike.skynet.logic.handler.marketing.MarketingTrafficLevelHelper;
import com.kuaike.skynet.logic.service.cache.BlacklistCacheService;
import com.kuaike.skynet.logic.service.cache.WechatAccountCacheService;
import com.kuaike.skynet.logic.service.common.dto.ApproveJoinGroupRecordDto;
import com.kuaike.skynet.logic.service.message.WechatMsgService;
import com.kuaike.skynet.logic.wechat.msg.AtUserList;
import com.kuaike.skynet.logic.wechat.msg.ChatRoomAccessVerify;
import com.kuaike.skynet.logic.wechat.utils.AbstractMsgHandler;
import com.kuaike.skynet.logic.wechat.utils.JoinGroupDto;
import com.kuaike.skynet.logic.wechat.utils.JoinGroupFactory;
import com.kuaike.skynet.logic.wechat.utils.MsgUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class GroupMsgRecvHandler
extends AbstractMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(GroupMsgRecvHandler.class);
    @Autowired
    private ReplyOptionHandler replyOptionHandler;
    @Autowired
    private ReplyMsgSendHelper replyMsgSendHelper;
    @Autowired
    private DrainageGroupReplyHandler drainageGroupReplyHandler;
    @Autowired
    private FissionGroupReplyHandler fissionGroupReplyHandler;
    @Autowired
    private GroupJoinedReplyHandler groupJoinedReplyHandler;
    @Autowired
    private MarketingTrafficLevelHelper marketingTrafficLevelHelper;
    @Autowired
    private GroupKeywordReplyHandler groupKeywordReplyHandler;
    @Autowired
    private WechatOpService wechatOpService;
    @Autowired
    private WechatMsgService wechatMsgService;
    @Autowired
    private WechatChatRoomMapper wechatChatRoomMapper;
    @Autowired
    private WechatAccountCacheService wechatAccountCacheService;
    @Autowired
    private BlacklistCacheService blacklistCacheService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private AckMessageProducer ackMessageProducer;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${spring.redis.key.msgSyncLock.format:msg_sync_lock:%s}")
    private String msgSyncLock;
    @Value(value="${spring.redis.key.msgSyncLock.expire:600}")
    private long msgSyncLockExpireTime;

    public void dispatch(WechatMessage wechatMessage) {
        String wechatId = wechatMessage.getWechatId();
        String chatroomId = wechatMessage.getTalkerId();
        String chatroomTalkerId = wechatMessage.getChatroomTalkerId();
        String requestId = wechatMessage.getRequestId();
        ReplyContext ctx = ReplyContextUtil.get();
        ctx.setChatroomId(chatroomId);
        ctx.setTalkerId(chatroomTalkerId);
        if (wechatId.equals(chatroomTalkerId)) {
            log.info("Ignore message send by myself, requestId={}", (Object)requestId);
            return;
        }
        if (!this.wechatMsgService.isServiceTime()) {
            log.info("Not service time, ignore message. requestId={}", (Object)requestId);
            return;
        }
        if (this.wechatAccountCacheService.isType(wechatId, WechatAccountType.ATMOSPHERE_ROBOT)) {
            log.info("Ignore atmosphere robot, requestId={}", (Object)requestId);
            return;
        }
        if (!this.locked(ctx.getBusinessCustomerId(), wechatMessage.getMsgSvrId())) {
            log.info("Not locked, requestId={}", (Object)ctx.getRequestId());
            return;
        }
        Long ownerBusinessCustomerId = this.getOwnerBusinessCustomerId(chatroomId);
        if (ownerBusinessCustomerId != null && !ownerBusinessCustomerId.equals(ctx.getBusinessCustomerId())) {
            log.info("From different businessCustomer, ignore this message. owner={}, robot={}", (Object)ownerBusinessCustomerId, (Object)ctx.getBusinessCustomerId());
            return;
        }
        if (!chatroomId.equals(chatroomTalkerId)) {
            if (this.blacklistCacheService.inBlacklist(ctx.getBusinessCustomerId(), chatroomTalkerId)) {
                log.info("Ignore wechat contact in black list, businessCustomerId={}, talkerId={}, requetId={}", new Object[]{ctx.getBusinessCustomerId(), chatroomTalkerId, requestId});
                return;
            }
            if (this.wechatAccountCacheService.isRobot(chatroomTalkerId)) {
                log.info("Ignore message from robot, requestId={}", (Object)requestId);
                return;
            }
        }
        ctx.setChatRoomOwner(this.wechatMsgService.isChatRoomOwner(wechatMessage));
        super.dispatch(wechatMessage);
    }

    private boolean locked(Long buId, String msgSvrId) {
        String content = String.format(this.msgSyncLock, buId + ":" + msgSvrId);
        String lockKey = this.redisKeyPrefix + content;
        try {
            Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"", this.msgSyncLockExpireTime, TimeUnit.SECONDS);
            log.debug("locked={}, key={}", (Object)locked, (Object)lockKey);
            if (locked == null) {
                return false;
            }
            return locked;
        }
        catch (Exception e) {
            log.error("Failed lock msg msgSrvId={}", (Object)msgSvrId, (Object)e);
            return false;
        }
    }

    private boolean locked(Long buId, String chatRoomId, List<String> memberIds, long seconds) {
        String content = String.format(this.msgSyncLock, buId + ":" + chatRoomId + ":" + StringUtils.join(memberIds, (String)",").hashCode());
        String lockKey = this.redisKeyPrefix + content;
        try {
            Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"", seconds, TimeUnit.SECONDS);
            log.debug("locked={}, key={}", (Object)locked, (Object)lockKey);
            if (locked == null) {
                return false;
            }
            return locked;
        }
        catch (Exception e) {
            log.error("Failed lock msg content={}", (Object)content, (Object)e);
            return false;
        }
    }

    private Long getOwnerBusinessCustomerId(String chatroomId) {
        String owner = this.wechatChatRoomMapper.queryOwnerByName(chatroomId);
        if (StringUtils.isBlank((CharSequence)owner)) {
            return null;
        }
        return this.wechatAccountCacheService.getBusinessCustomerId(owner);
    }

    public void text(WechatMessage wechatMessage) {
        String wechatId = wechatMessage.getWechatId();
        String requestId = wechatMessage.getRequestId();
        String chatroomId = wechatMessage.getTalkerId();
        String chatroomTalkerId = wechatMessage.getChatroomTalkerId();
        String message = wechatMessage.getMessage();
        Long buId = this.wechatAccountCacheService.getBusinessCustomerId(wechatId);
        log.info("Receive text from group, requestId={}, chatroom={}, talkerId={}, message={}", new Object[]{wechatMessage.getRequestId(), chatroomId, chatroomTalkerId, message});
        List<String> atUsers = this.getAtUsersFromLvBuffer(requestId, wechatMessage.getLvbuffer());
        ReplyContextUtil.get().setAtUsers(atUsers);
        String text = wechatMessage.getMessage();
        ReplyContextUtil.get().setMsg(text);
        text = this.wechatMsgService.removeAtMembers(text, chatroomId, atUsers);
        text = MsgUtils.removeAtMembers((String)text);
        text = MsgUtils.removeReferredText((String)text);
        ReplyContextUtil.get().setPureMsg(text);
        if (this.replyOptionHandler.recvGroupText(wechatMessage, text, atUsers)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(atUsers)) {
            String wid = this.replyMsgSendHelper.getAvailableBot(buId, atUsers, wechatId);
            atUsers = wid == null ? Collections.emptyList() : Collections.singletonList(wid);
        }
        if (this.drainageGroupReplyHandler.recvGroupText(wechatMessage, text, atUsers)) {
            return;
        }
        if (this.fissionGroupReplyHandler.recvGroupText(wechatMessage, text, atUsers)) {
            return;
        }
        if (this.groupKeywordReplyHandler.recvText(wechatMessage, text, atUsers)) {
            return;
        }
    }

    private List<String> getAtUsersFromLvBuffer(String requestId, String lvBuffer) {
        String wechatIdStr;
        List<String> atUsers = Collections.emptyList();
        if (StringUtils.isBlank((CharSequence)lvBuffer)) {
            log.info("lvbuffer is empty, requestId={}", (Object)requestId);
            return atUsers;
        }
        String elementStart = "<msgsource>";
        String elementEnd = "</msgsource>";
        int start = lvBuffer.indexOf(elementStart);
        int end = lvBuffer.indexOf(elementEnd, start);
        if (start < 0 || end < 0) {
            log.info("lvbuffer is not a valid xml, requestId={}, lvbuffer={}", (Object)requestId, (Object)lvBuffer);
            return atUsers;
        }
        String xml = lvBuffer.substring(start, end + elementEnd.length());
        AtUserList atUserList = null;
        try {
            atUserList = (AtUserList)this.xmlMapper.readValue(xml, AtUserList.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed parsing lvBuffer, requestId={}, lvBuffer={}", new Object[]{requestId, lvBuffer, e});
            return atUsers;
        }
        if (atUserList != null && StringUtils.isNotBlank((CharSequence)atUserList.getAtUserList()) && StringUtils.isNotBlank((CharSequence)(wechatIdStr = atUserList.getAtUserList().trim()))) {
            String[] arr = StringUtils.split((String)wechatIdStr);
            atUsers = Arrays.asList(arr);
        }
        return atUsers;
    }

    public void image(WechatMessage wechatMessage) {
        log.info("Receive image from group, requestId={}, chatroom={}, talkerId={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getTalkerId(), wechatMessage.getChatroomTalkerId()});
        this.fissionGroupReplyHandler.recvGroupImage(wechatMessage);
    }

    public void onBecomeOwnerEvent(WechatMessage wechatMessage) {
        log.info("Receive BecomeOwnerEvent from group, requestId={}, chatroom={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
        this.wechatMsgService.onBecomeOwnerEvent(wechatMessage.getWechatId(), wechatMessage.getTalkerId(), wechatMessage.getCreateTime());
    }

    public void onJoinGroupEvent(WechatMessage wechatMessage) {
        JoinGroupDto record;
        log.info("Receive JoinGroupEvent from group, requestId={}, chatroom={}, talkerId={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getTalkerId(), wechatMessage.getChatroomTalkerId()});
        ReplyContext ctx = ReplyContextUtil.get();
        if (!ctx.isChatRoomOwner()) {
            log.info("Not chatroom owner. requestId={}", (Object)ctx.getRequestId());
        }
        if ((record = JoinGroupFactory.parse((WechatMessage)wechatMessage)) == null) {
            log.info("ignore unknown tips, requestId={}", (Object)ctx.getRequestId());
            return;
        }
        if (record.getType() != 1 && record.getType() != 2) {
            log.info("ignore tips, requestId={}", (Object)ctx.getRequestId());
            return;
        }
        ctx.setJoinGroupWechatIds(record.getMemberIds());
        ctx.setJoinGroupMemberList(record.getMemberList());
        ArrayList memberIds = Lists.newArrayList((Iterable)record.getMemberIds());
        if (CollectionUtils.isNotEmpty((Collection)memberIds)) {
            memberIds.removeIf(memberId -> StringUtils.isBlank((CharSequence)memberId) || this.wechatAccountCacheService.isRobot(ctx.getBusinessCustomerId(), memberId) || this.blacklistCacheService.inBlacklist(ctx.getBusinessCustomerId(), memberId));
            ctx.setJoinGroupWithoutRobotWechatIds(memberIds);
        }
        if (CollectionUtils.isEmpty((Collection)memberIds)) {
            log.info("No memberIds found, requestId={}. Maybe they are robot or in blacklist, buId={}, wechatIds={}", new Object[]{ctx.getRequestId(), ctx.getBusinessCustomerId(), ctx.getJoinGroupWechatIds()});
            return;
        }
        if (!this.locked(ctx.getBusinessCustomerId(), ctx.getChatroomId(), record.getMemberIds(), 5L)) {
            log.info("Not locked, requestId={}, roomId={}", (Object)ctx.getRequestId(), (Object)ctx.getChatroomId());
            return;
        }
        this.marketingTrafficLevelHelper.onJoinGroup();
        if (this.drainageGroupReplyHandler.onJoinGroup()) {
            return;
        }
        if (this.fissionGroupReplyHandler.onJoinGroup()) {
            return;
        }
        if (this.groupJoinedReplyHandler.onJoinGroup()) {
            return;
        }
    }

    public void chatRoomAccessVerifyApplication(WechatMessage wechatMessage) {
        log.info("Receive ChatRoomAccessVerifyApplication from group, requestId={}, chatroom={}, talkerId={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getTalkerId(), wechatMessage.getChatroomTalkerId()});
        String wechatId = wechatMessage.getWechatId();
        String message = wechatMessage.getMessage();
        ChatRoomAccessVerify verify = null;
        try {
            verify = (ChatRoomAccessVerify)this.xmlMapper.readValue(message, ChatRoomAccessVerify.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u89e3\u6790\u9080\u8bf7\u5165\u7fa4\u7533\u8bf7\u5931\u8d25, xml={}", (Object)message, (Object)e);
            return;
        }
        if (verify.getVerifyApplication() == null) {
            log.warn("\u9080\u8bf7\u5165\u7fa4\u7533\u8bf7xml\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u65e0\u6cd5\u83b7\u53d6\u9080\u8bf7\u8005\u7684\u5fae\u4fe1id, xml={}", (Object)message);
            return;
        }
        if (verify.getVerifyApplication().getLink() == null) {
            log.warn("\u9080\u8bf7\u5165\u7fa4\u7533\u8bf7xml\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u65e0\u6cd5\u83b7\u53d6\u9080\u8bf7\u8005\u7684\u5fae\u4fe1id, xml={}", (Object)message);
            return;
        }
        String inviterUsername = verify.getVerifyApplication().getLink().getInviterUsername();
        if (StringUtils.isBlank((CharSequence)inviterUsername)) {
            log.warn("\u9080\u8bf7\u5165\u7fa4\u7533\u8bf7xml\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u65e0\u6cd5\u83b7\u53d6\u9080\u8bf7\u8005\u7684\u5fae\u4fe1id, xml={}", (Object)message);
            return;
        }
        ChatRoomAccessVerify.MamberList memberList = verify.getVerifyApplication().getLink().getMemberList();
        if (Objects.isNull(memberList) || CollectionUtils.isEmpty((Collection)memberList.getMembers())) {
            log.warn("\u9080\u8bf7\u5165\u7fa4\u7533\u8bf7xml\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u88ab\u9080\u8bf7\u4eba\u5217\u8868\u4e3a\u7a7a, xml={}", (Object)message);
            return;
        }
        if (!this.wechatAccountCacheService.isRobot(inviterUsername)) {
            log.info("\u9080\u8bf7\u5165\u7fa4\u7533\u8bf7\u5e76\u975e\u7531\u673a\u5668\u4eba\u53d1\u9001\uff0c\u4e0d\u6267\u884c\u81ea\u52a8\u901a\u8fc7\u3002inviterUsername={}", (Object)inviterUsername);
            return;
        }
        ApproveJoinGroupRequestS req = new ApproveJoinGroupRequestS();
        req.setMsgSvrId(wechatMessage.getMsgSvrId());
        req.setMessage(message);
        req.setWId(wechatId);
        try {
            BaseResponse resp = this.wechatOpService.approveJoinGroup(req);
            if (resp.getCode() != 0L) {
                log.warn("\u81ea\u52a8\u901a\u8fc7\u9080\u8bf7\u5165\u7fa4\u9a8c\u8bc1\u5931\u8d25. requestId={}, msgSrvId={}, message={}, resp={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getMsgSvrId(), wechatMessage.getMessage(), resp});
            }
            this.buildAndSendApproveChatRoomAccessVerify(wechatId, inviterUsername, memberList, verify, resp);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8c03\u7528WechatOpService\u81ea\u52a8\u901a\u8fc7\u5361\u7247\u52a0\u7fa4\u5931\u8d25, requestId={}, msgSrvId={}, message={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getMsgSvrId(), wechatMessage.getMessage(), e});
        }
    }

    private void buildAndSendApproveChatRoomAccessVerify(String approveWechatId, String inviterUsername, ChatRoomAccessVerify.MamberList memberList, ChatRoomAccessVerify verify, BaseResponse<?> resp) {
        ApproveJoinGroupRecordDto approveJoinGroupRecordDto = new ApproveJoinGroupRecordDto();
        approveJoinGroupRecordDto.setApproveWechatId(approveWechatId);
        approveJoinGroupRecordDto.setInviteWechatId(inviterUsername);
        approveJoinGroupRecordDto.setWechatIds((Collection)memberList.getMembers().stream().map(ChatRoomAccessVerify.Member::getUsername).collect(Collectors.toSet()));
        approveJoinGroupRecordDto.setChatRoomId(verify.getVerifyApplication().getRoomName());
        OpBaseResponse response = new OpBaseResponse();
        response.setRequestId(resp.getRequestId());
        response.setCode((int)resp.getCode());
        response.setMsg(resp.getMsg());
        response.setCmd(-21);
        response.setBody(JSON.toJSONString((Object)approveJoinGroupRecordDto));
        this.ackMessageProducer.sendMessage(response);
        log.info("buildAndSendApproveChatRoomAccessVerify response:{}", (Object)JSON.toJSONString((Object)response));
    }
}

