/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.consumer;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.kuaike.skynet.link.service.common.OpBaseResponse;
import com.kuaike.skynet.logic.service.common.utils.JacksonUtils;
import com.kuaike.skynet.logic.service.common.utils.KafkaClientUtils;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AckMessageProducer {
    private static final Logger log = LoggerFactory.getLogger(AckMessageProducer.class);
    @Autowired
    private KafkaClientUtils kafkaClient;
    @Value(value="${kafkaMessage.consumer.skAckMessage.topic}")
    private String skAckMessageTopic;
    private static final JacksonUtils jacksonUtils = new JacksonUtils();

    public void producerAckMessage(String message) {
        try {
            this.kafkaClient.sendMessage(this.skAckMessageTopic, null, message);
            log.info("producerAckMessage message\uff1a{}", (Object)message);
        }
        catch (Exception e) {
            log.error("producerAckMessage message error, response:{}", (Object)message, (Object)e);
        }
    }

    public void sendMessage(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return;
        }
        this.producerAckMessage(message);
    }

    public void sendMessage(OpBaseResponse response) {
        if (Objects.isNull(response)) {
            return;
        }
        try {
            this.producerAckMessage(jacksonUtils.getObjectMapper().writeValueAsString((Object)response));
        }
        catch (JsonProcessingException e) {
            log.error("sendMessage error:{}", (Object)JSON.toJSONString((Object)response), (Object)e);
        }
    }
}

