/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.message.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfig;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfigCriteria;
import com.kuaike.skynet.logic.dal.market.mapper.MarketReplyConfigMapper;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessage;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessageMember;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessageMemberCriteria;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicIntervalSendMessageMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicIntervalSendMessageMemberMapper;
import com.kuaike.skynet.logic.dal.wechat.dto.ChatRoomSumCount;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoom;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoomGroupRelation;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomGroupRelationMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomRelationMapper;
import com.kuaike.skynet.logic.service.client.PushMsgService;
import com.kuaike.skynet.logic.service.client.WechatService;
import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.common.dto.ReplyMessageDto;
import com.kuaike.skynet.logic.service.common.enums.IntervalMessageReplyTypeEnum;
import com.kuaike.skynet.logic.service.common.enums.MarketReplyConfigType;
import com.kuaike.skynet.logic.service.common.enums.MessageSendStatusEnum;
import com.kuaike.skynet.logic.service.marketing.dto.FissionAccomplishTaskReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.FissionRewardReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.InviteToChatRoomDto;
import com.kuaike.skynet.logic.service.marketing.dto.WechatIdAndChatRoomIdsDto;
import com.kuaike.skynet.logic.service.message.IntervalSendMessageService;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.dto.IntervalSendMessageReqDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyMessageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IntervalSendMessageServiceImpl
implements IntervalSendMessageService {
    private static final Logger log = LoggerFactory.getLogger(IntervalSendMessageServiceImpl.class);
    @Autowired
    private LogicIntervalSendMessageMapper logicIntervalSendMessageMapper;
    @Autowired
    private LogicIntervalSendMessageMemberMapper logicIntervalSendMessageMemberMapper;
    @Autowired
    private WechatChatRoomGroupRelationMapper wechatChatRoomGroupRelationMapper;
    @Autowired
    private MarketReplyConfigMapper marketReplyConfigMapper;
    @Autowired
    private WechatChatRoomMapper wechatChatRoomMapper;
    @Autowired
    private PushMsgService pushMsgService;
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;
    @Autowired
    private WechatService inviteToRoomService;
    @Autowired
    private WechatChatRoomRelationMapper wechatChatRoomRelationMapper;
    public static final Set<Integer> needIntervalMessageReplyTypeEnum = ImmutableSet.of((Object)IntervalMessageReplyTypeEnum.FISSION_TASK_SUCCESS.getValue(), (Object)IntervalMessageReplyTypeEnum.FISSION_TASK_REWARD.getValue());

    @Override
    public void addMember(IntervalSendMessageReqDto req) {
        log.info("Add member with req={}", (Object)req);
        LogicIntervalSendMessage condition = new LogicIntervalSendMessage();
        condition.setWechatRoomName(req.getWechatRoomName());
        condition.setReplyType(req.getReplyType());
        condition.setStatus(Integer.valueOf(MessageSendStatusEnum.WAIT_SEND.getValue()));
        LogicIntervalSendMessage logicIntervalSendMessage = (LogicIntervalSendMessage)this.logicIntervalSendMessageMapper.selectOne((Object)condition);
        if (logicIntervalSendMessage == null) {
            if (!this.populateMessageAndSendTime(req)) {
                log.warn("Failed polute message when add member, req={}", (Object)req);
                return;
            }
            if (!Objects.equals(req.getReplyType(), IntervalMessageReplyTypeEnum.FISSION_TASK_SUCCESS.getValue()) && StringUtils.isEmpty((CharSequence)req.getMessage())) {
                log.warn("Reply type is not FISSION_TASK_SUCCESS, stop following operations, req={}", (Object)req);
                return;
            }
            if (req.getMessage() == null) {
                log.warn("Reply message is null, req={}", (Object)req);
                req.setMessage("");
            }
            LogicIntervalSendMessage lismRecord = new LogicIntervalSendMessage();
            lismRecord.setWechatId(req.getWechatId());
            lismRecord.setWechatRoomName(req.getWechatRoomName());
            lismRecord.setMessage(req.getMessage());
            lismRecord.setReplyType(req.getReplyType());
            lismRecord.setFissionCategoryId(req.getFissionCategoryId());
            lismRecord.setMemberInterval(req.getMemberInterval());
            lismRecord.setSendTime(req.getSendTime());
            lismRecord.setIntervalAudiTime(req.getIntervalAuditTime());
            this.logicIntervalSendMessageMapper.insertSelective((Object)lismRecord);
            logicIntervalSendMessage = lismRecord;
        } else {
            LogicIntervalSendMessageMember memberCondition = new LogicIntervalSendMessageMember();
            memberCondition.setIntervalSendMessageId(logicIntervalSendMessage.getId());
            List memberIds = this.logicIntervalSendMessageMemberMapper.select((Object)memberCondition).stream().map(LogicIntervalSendMessageMember::getMemberWechatId).collect(Collectors.toList());
            if (memberIds.contains(req.getMemberWechatId())) {
                log.warn("Duplicated memeberWechatId detected. wechatId={}, existsMemberIds={}", (Object)req.getMemberWechatId(), memberIds);
                return;
            }
        }
        LogicIntervalSendMessageMember record = new LogicIntervalSendMessageMember();
        record.setIntervalSendMessageId(logicIntervalSendMessage.getId());
        record.setWechatRoomName(req.getWechatRoomName());
        record.setMemberWechatId(req.getMemberWechatId());
        this.logicIntervalSendMessageMemberMapper.insertSelective((Object)record);
    }

    @Override
    @Transactional(noRollbackFor={Exception.class})
    public void sendMessage(Long id) {
        Date currentTime = new Date();
        int status = MessageSendStatusEnum.WAIT_SEND.getValue();
        List sendMsgList = this.logicIntervalSendMessageMapper.selectByStatus(id, status, currentTime);
        if (CollectionUtils.isEmpty((Collection)sendMsgList)) {
            log.debug("No send message task found.");
            return;
        }
        List<LogicIntervalSendMessage> sendMsgQueue = this.filterWaitSendMsg(sendMsgList, currentTime);
        if (CollectionUtils.isEmpty(sendMsgQueue)) {
            log.debug("No send message task found.");
            return;
        }
        List<Long> sendMsgIds = sendMsgQueue.stream().map(LogicIntervalSendMessage::getId).collect(Collectors.toList());
        log.info("Send message ids={}", sendMsgIds);
        List<LogicIntervalSendMessageMember> memberList = this.queryWaitSendMsgMembers(sendMsgIds);
        Map<Long, List<LogicIntervalSendMessageMember>> memberMap = memberList.stream().collect(Collectors.groupingBy(LogicIntervalSendMessageMember::getIntervalSendMessageId));
        ArrayList successIdList = Lists.newArrayList();
        ArrayList rewardList = Lists.newArrayList();
        ArrayList rewardMemberList = Lists.newArrayList();
        sendMsgQueue.forEach(e -> {
            List members = (List)memberMap.get(e.getId());
            try {
                this.sendMessage((LogicIntervalSendMessage)e, members);
            }
            catch (Exception ex) {
                log.error("Failed send message with id={}, ", (Object)e.getId(), (Object)ex);
                return;
            }
            successIdList.add(e.getId());
            try {
                if (e.getReplyType().intValue() == IntervalMessageReplyTypeEnum.FISSION_TASK_SUCCESS.getValue()) {
                    if (CollectionUtils.isEmpty((Collection)members)) {
                        log.warn("Members not found id={}, members={}", (Object)e.getId(), (Object)members);
                    } else {
                        rewardList.add(e);
                        rewardMemberList.addAll(members);
                    }
                }
            }
            catch (Exception ex) {
                log.error("Failed process fission task, msg={}, members={}", new Object[]{e, members, ex});
            }
        });
        this.logicIntervalSendMessageMapper.batchUpdateStatus(Integer.valueOf(MessageSendStatusEnum.SUCCESS.getValue()), (List)successIdList);
        if (rewardList.size() > 0) {
            this.createRewardTask(rewardList, rewardMemberList);
        }
    }

    private List<LogicIntervalSendMessageMember> queryWaitSendMsgMembers(List<Long> sendMsgIds) {
        LogicIntervalSendMessageMemberCriteria example = new LogicIntervalSendMessageMemberCriteria();
        LogicIntervalSendMessageMemberCriteria.Criteria criteria = example.createCriteria();
        criteria.andIntervalSendMessageIdIn(sendMsgIds);
        return this.logicIntervalSendMessageMemberMapper.selectByExample((Object)example);
    }

    private List<LogicIntervalSendMessage> filterWaitSendMsg(List<LogicIntervalSendMessage> sendMsgList, Date sendTime) {
        List sendMsgIds = sendMsgList.stream().map(LogicIntervalSendMessage::getId).collect(Collectors.toList());
        log.info("Filtering wait send message with sendTime={}, sendMsgIds={}", (Object)sendTime, sendMsgIds);
        Map countMemberMap = this.logicIntervalSendMessageMemberMapper.getCountMemberMap(sendMsgIds);
        long current = sendTime.getTime() + 5000L;
        ArrayList sendMsgQueue = Lists.newArrayList();
        for (LogicIntervalSendMessage msg : sendMsgList) {
            long send = msg.getSendTime().getTime();
            if (send > current) {
                if (StringUtils.isBlank((CharSequence)msg.getWechatRoomName())) {
                    log.info("Ingore message.id={}, reason: Don't batch friend message.", (Object)msg.getId());
                    continue;
                }
                if (needIntervalMessageReplyTypeEnum.contains(msg.getReplyType())) {
                    log.info("Ignore message.id={}, reason: Don't batch chatroom fission reward message.", (Object)msg.getId());
                    continue;
                }
                Integer memberCount = countMemberMap.getOrDefault(msg.getId(), 0);
                if (msg.getMemberInterval() <= 0 || memberCount < msg.getMemberInterval()) {
                    log.info("Ignore message.id={}, reason: Wait send member count is not enough, {} < {}", new Object[]{msg.getId(), memberCount, msg.getMemberInterval()});
                    continue;
                }
            }
            sendMsgQueue.add(msg);
        }
        return sendMsgQueue;
    }

    private void sendMessage(LogicIntervalSendMessage message, List<LogicIntervalSendMessageMember> members) {
        List<String> memberIds;
        if (StringUtils.isBlank((CharSequence)message.getMessage())) {
            log.warn("Message is empty, message={}", (Object)message);
            return;
        }
        String wechatId = message.getWechatId();
        if (CollectionUtils.isEmpty(members)) {
            memberIds = null;
            if (StringUtils.isBlank((CharSequence)message.getWechatRoomName())) {
                log.warn("No member found with id={}", (Object)message.getId());
                return;
            }
        } else {
            memberIds = members.stream().map(LogicIntervalSendMessageMember::getMemberWechatId).collect(Collectors.toList());
        }
        String toWechatId = null;
        if (StringUtils.isBlank((CharSequence)message.getWechatRoomName())) {
            toWechatId = (String)memberIds.get(0);
            memberIds = null;
        } else {
            toWechatId = message.getWechatRoomName();
        }
        ReplyMessageDto replyMessageDto = this.replyMessageDtoService.toReplyMessageDto(message.getMessage());
        List replyMessage = replyMessageDto.getReplyMessage();
        if (CollectionUtils.isEmpty((Collection)replyMessage)) {
            log.warn("Reply message is empty, replyMessageDto={}", (Object)replyMessageDto);
            return;
        }
        int size = replyMessage.size();
        for (int i = 0; i < size; ++i) {
            CommonMessage msg = (CommonMessage)replyMessage.get(i);
            Integer type = msg.getType();
            String content = msg.getContent();
            boolean pushed = false;
            try {
                pushed = this.pushMsgService.pushMessage(wechatId, toWechatId, type, content, memberIds);
            }
            catch (Exception ex) {
                log.error("Failed sending message, message={}", (Object)msg, (Object)ex);
                ex.printStackTrace();
                pushed = false;
            }
            if (pushed && memberIds != null) {
                memberIds = null;
            }
            if (!pushed || i >= size - 1) continue;
            this.pushMsgService.sleep();
        }
    }

    private boolean populateMessageAndSendTime(IntervalSendMessageReqDto req) {
        WechatChatRoomGroupRelation wcrgrCondition = new WechatChatRoomGroupRelation();
        wcrgrCondition.setChatRoomName(req.getWechatRoomName());
        List relationList = this.wechatChatRoomGroupRelationMapper.select((Object)wcrgrCondition);
        if (req.getReplyType().intValue() == IntervalMessageReplyTypeEnum.FISSION_TASK_COMPLETE.getValue()) {
            return this.onChatroomFissionTaskComplete(req, relationList);
        }
        if (req.getReplyType().intValue() == IntervalMessageReplyTypeEnum.FISSION_TASK_SUCCESS.getValue()) {
            return this.onChatroomFissionTaskSuccess(req, relationList);
        }
        if (req.getReplyType().intValue() == IntervalMessageReplyTypeEnum.FISSION_TASK_FAIL.getValue()) {
            return this.onChatroomFissionTaskFail(req, relationList);
        }
        return true;
    }

    private boolean onChatroomFissionTaskComplete(IntervalSendMessageReqDto req, List<WechatChatRoomGroupRelation> relationList) {
        for (WechatChatRoomGroupRelation relation : relationList) {
            if (relation.getFissionCategoryId() == null) continue;
            req.setFissionCategoryId(relation.getFissionCategoryId());
            MarketReplyConfig marketReplyConfig = this.marketReplyConfigMapper.getTaskCompleteByFissionCategoryPlanId(relation.getFissionCategoryId(), new Date());
            if (marketReplyConfig == null) {
                return false;
            }
            FissionAccomplishTaskReplyConfig replyConfig = (FissionAccomplishTaskReplyConfig)JSON.parseObject((String)marketReplyConfig.getJsonText(), FissionAccomplishTaskReplyConfig.class);
            if (replyConfig.getIsAutoReply().equals(0)) {
                return false;
            }
            ReplyMessageDto replyMessageDto = new ReplyMessageDto((CommonMessage)replyConfig.getReplyMessages().get(0));
            req.setMessage(JacksonUtil.obj2Str((Object)replyMessageDto));
            long sendTimeBase = System.currentTimeMillis();
            int seconds = (Integer)ObjectUtils.defaultIfNull((Object)replyConfig.getIntervalTime(), (Object)0);
            req.setSendTime(new Date(sendTimeBase + (long)(seconds * 1000)));
            req.setMemberInterval(replyConfig.getPeopleInterval());
            req.setIntervalAuditTime(Integer.valueOf(0));
            return true;
        }
        return false;
    }

    private boolean onChatroomFissionTaskSuccess(IntervalSendMessageReqDto req, List<WechatChatRoomGroupRelation> relationList) {
        for (WechatChatRoomGroupRelation relation : relationList) {
            if (relation.getFissionCategoryId() == null) continue;
            req.setFissionCategoryId(relation.getFissionCategoryId());
            MarketReplyConfig marketReplyConfig = this.marketReplyConfigMapper.getTaskCompleteByFissionCategoryPlanId(relation.getFissionCategoryId(), new Date());
            if (marketReplyConfig == null) {
                return false;
            }
            FissionAccomplishTaskReplyConfig replyConfig = (FissionAccomplishTaskReplyConfig)JSON.parseObject((String)marketReplyConfig.getJsonText(), FissionAccomplishTaskReplyConfig.class);
            if (replyConfig.getIsAutoReply().equals(0)) {
                return false;
            }
            req.setMessage("");
            long sendTimeBase = System.currentTimeMillis();
            int seconds = (Integer)ObjectUtils.defaultIfNull((Object)replyConfig.getIntervalTime(), (Object)0);
            req.setSendTime(new Date(sendTimeBase + (long)(seconds * 1000)));
            req.setMemberInterval(Integer.valueOf(0));
            int minutes = (Integer)ObjectUtils.defaultIfNull((Object)replyConfig.getIntervalAuditTime(), (Object)0);
            req.setIntervalAuditTime(Integer.valueOf(minutes));
            return true;
        }
        return false;
    }

    private boolean onChatroomFissionTaskFail(IntervalSendMessageReqDto req, List<WechatChatRoomGroupRelation> relationList) {
        for (WechatChatRoomGroupRelation relation : relationList) {
            if (relation.getFissionCategoryId() == null) continue;
            req.setFissionCategoryId(relation.getFissionCategoryId());
            MarketReplyConfig marketReplyConfig = this.marketReplyConfigMapper.getTaskCompleteByFissionCategoryPlanId(relation.getFissionCategoryId(), new Date());
            if (marketReplyConfig == null) {
                return false;
            }
            FissionAccomplishTaskReplyConfig replyConfig = (FissionAccomplishTaskReplyConfig)JSON.parseObject((String)marketReplyConfig.getJsonText(), FissionAccomplishTaskReplyConfig.class);
            if (replyConfig.getIsAutoReply().equals(0)) {
                return false;
            }
            ReplyMessageDto replyMessageDto = new ReplyMessageDto((CommonMessage)replyConfig.getReplyMessages().get(1));
            req.setMessage(JacksonUtil.obj2Str((Object)replyMessageDto));
            long sendTimeBase = System.currentTimeMillis();
            int minutes = (Integer)ObjectUtils.defaultIfNull((Object)replyConfig.getIntervalAuditTime(), (Object)0);
            req.setSendTime(new Date(sendTimeBase + (long)(minutes * 60 * 1000)));
            req.setMemberInterval(Integer.valueOf(0));
            req.setIntervalAuditTime(Integer.valueOf(0));
            return true;
        }
        return false;
    }

    private void createRewardTask(List<LogicIntervalSendMessage> rewardList, List<LogicIntervalSendMessageMember> rewardMemberList) {
        log.info("create fission rewards reply with rewardList={}, memberList={}", rewardList, rewardMemberList);
        List fissionCategoryIdList = rewardList.stream().map(LogicIntervalSendMessage::getFissionCategoryId).collect(Collectors.toList());
        MarketReplyConfigCriteria criteria = new MarketReplyConfigCriteria();
        criteria.createCriteria().andExtendedIdIn(fissionCategoryIdList).andConfigTypeEqualTo(Integer.valueOf(MarketReplyConfigType.FISSION_TASK_REWARD.getValue())).andIsDeletedEqualTo(Boolean.valueOf(false));
        List replyConfigList = this.marketReplyConfigMapper.selectByExample((Object)criteria);
        Map<Long, List<MarketReplyConfig>> replyConfigMap = replyConfigList.stream().collect(Collectors.groupingBy(MarketReplyConfig::getExtendedId));
        rewardList.removeIf(e -> CollectionUtils.isEmpty((Collection)((Collection)replyConfigMap.get(e.getFissionCategoryId()))));
        rewardList.forEach(e -> {
            MarketReplyConfig marketReplyConfig = (MarketReplyConfig)((List)replyConfigMap.get(e.getFissionCategoryId())).get(0);
            FissionRewardReplyConfig replyConfig = (FissionRewardReplyConfig)JSON.parseObject((String)marketReplyConfig.getJsonText(), FissionRewardReplyConfig.class);
            ArrayList replyMessages = Lists.newArrayList();
            replyMessages.addAll(replyConfig.getReplyMessages());
            CommonMessage commonMessage = new CommonMessage();
            commonMessage.setSeq(Integer.valueOf(2));
            commonMessage.setContent(replyConfig.getWechatId());
            commonMessage.setType(Integer.valueOf(AutoReplyMessageType.B_CARD.getValue()));
            replyMessages.add(commonMessage);
            ReplyMessageDto replyMessageDto = new ReplyMessageDto((List)replyMessages);
            e.setSendTime(new Date(System.currentTimeMillis() + (long)(e.getIntervalAudiTime() * 60 * 1000)));
            e.setMessage(JacksonUtil.obj2Str((Object)replyMessageDto));
            e.setReplyType(Integer.valueOf(IntervalMessageReplyTypeEnum.FISSION_TASK_REWARD.getValue()));
            e.setMemberInterval(Integer.valueOf(0));
        });
        if (CollectionUtils.isNotEmpty(rewardList)) {
            this.logicIntervalSendMessageMapper.batchInsert(rewardList);
            rewardMemberList.forEach(e -> {
                for (LogicIntervalSendMessage logicIntervalSendMessage : rewardList) {
                    if (!e.getWechatRoomName().equals(logicIntervalSendMessage.getWechatRoomName())) continue;
                    e.setIntervalSendMessageId(logicIntervalSendMessage.getId());
                    break;
                }
            });
            this.logicIntervalSendMessageMemberMapper.batchInsert(rewardMemberList);
        }
    }

    @Deprecated
    private void inviteToRoom4FriendReward(String wechatId, InviteToChatRoomDto params, String memberId) {
        log.info("invite friend to chat room, wechatId={}, memberId={}, params={}", new Object[]{wechatId, memberId, params});
        if (params == null) {
            log.warn("\u9080\u8bf7\u597d\u53cb\u52a0\u7fa4\u7684\u53c2\u6570\u4e3a\u7a7a, params={}", (Object)params);
            return;
        }
        if (!Objects.equals(params.getWasOpenForwardChatRoom(), 1)) {
            log.warn("\u672a\u5f00\u542f\u9080\u8bf7\u5165\u7fa4, params={}", (Object)params);
            return;
        }
        List list = params.getWechatIdAndChatRoomIdsDtoList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.warn("\u9080\u8bf7\u597d\u53cb\u52a0\u7fa4\u7684\u53c2\u6570\u4e3a\u7a7a, params={}", (Object)params);
            return;
        }
        Optional<WechatIdAndChatRoomIdsDto> optionalDto = list.stream().filter(dto -> StringUtils.equals((CharSequence)dto.getWechatId(), (CharSequence)wechatId)).findFirst();
        if (!optionalDto.isPresent()) {
            log.warn("\u627e\u4e0d\u5230\u5fae\u4fe1ID\u5bf9\u5e94\u7684\u7fa4ID\u4fe1\u606f\uff0c\u65e0\u6cd5\u9080\u8bf7\u5165\u7fa4, wechatId={}, list={}", (Object)wechatId, (Object)list);
            return;
        }
        WechatIdAndChatRoomIdsDto dto2 = optionalDto.get();
        List chatRoomIdList = dto2.getChatRoomIds();
        if (CollectionUtils.isEmpty((Collection)chatRoomIdList)) {
            log.warn("\u7fa4ID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u9080\u8bf7\u5165\u7fa4. params={}", (Object)params);
            return;
        }
        List wechatChatRoomList = this.wechatChatRoomMapper.queryListByChatroomIds(wechatId, (Collection)chatRoomIdList);
        if (CollectionUtils.isEmpty(chatRoomIdList = wechatChatRoomList.stream().map(WechatChatRoom::getName).distinct().collect(Collectors.toList()))) {
            log.warn("\u7fa4ID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u9080\u8bf7\u5165\u7fa4. params={}", (Object)dto2);
            return;
        }
        log.info("invite friend to room, wechatId={}, memberId={}, chatRoomIdList={}", new Object[]{wechatId, memberId, chatRoomIdList});
        String roomId = (String)chatRoomIdList.get(0);
        if (chatRoomIdList.size() == 1) {
            this.inviteToRoomService.inviteToRoom(wechatId, Collections.singletonList(memberId), (String)chatRoomIdList.get(0));
            return;
        }
        List chatRoomSumCountList = this.wechatChatRoomRelationMapper.caculateRelationAmount(chatRoomIdList);
        if (CollectionUtils.isNotEmpty((Collection)chatRoomSumCountList)) {
            TreeMap chatRoomSumCountMultiMap = chatRoomSumCountList.stream().collect(Collectors.groupingBy(ChatRoomSumCount::getSumCount, TreeMap::new, Collectors.mapping(ChatRoomSumCount::getChatRoomId, Collectors.toList())));
            List strList = (List)chatRoomSumCountMultiMap.firstEntry().getValue();
            Collections.shuffle(strList);
            roomId = (String)strList.get(0);
        } else {
            log.warn("Failed to query member count, chatRoomIds={}", chatRoomIdList);
        }
        this.inviteToRoomService.inviteToRoom(wechatId, Collections.singletonList(memberId), roomId);
    }
}

