/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.service.client.utils;

import com.kuaike.skynet.link.service.dto.PushMessageRequestS;
import com.kuaike.skynet.link.service.dto.push.AppletPushMessage;
import com.kuaike.skynet.link.service.dto.push.AtMemberPushMessage;
import com.kuaike.skynet.link.service.dto.push.BCardPushMessage;
import com.kuaike.skynet.link.service.dto.push.FilePushMessage;
import com.kuaike.skynet.link.service.dto.push.ImagePushMessage;
import com.kuaike.skynet.link.service.dto.push.LinkCardPushMessage;
import com.kuaike.skynet.link.service.dto.push.TextPushMessage;
import com.kuaike.skynet.link.service.dto.push.VideoPushMessage;
import com.kuaike.skynet.link.service.dto.push.VoicePushMessage;
import java.util.List;

public class PushMsgBuilder {
    private String wId = null;
    private String to = null;
    private boolean control = false;
    private PushMessageRequestS req = new PushMessageRequestS();

    public static PushMsgBuilder builder() {
        return new PushMsgBuilder();
    }

    public PushMsgBuilder wId(String wId) {
        this.wId = wId;
        return this;
    }

    public PushMsgBuilder to(String to) {
        this.to = to;
        return this;
    }

    public PushMsgBuilder control(boolean control) {
        this.control = control;
        return this;
    }

    public PushMsgBuilder businessCard(String wechatId) {
        BCardPushMessage bCardPushMessage = new BCardPushMessage();
        bCardPushMessage.setWId(wechatId);
        this.req.setBCardPushMessage(bCardPushMessage);
        return this;
    }

    public PushMsgBuilder text(String content) {
        TextPushMessage textPushMessage = new TextPushMessage();
        textPushMessage.setContent(content);
        this.req.setTextPushMessage(textPushMessage);
        return this;
    }

    public PushMsgBuilder image(String url) {
        ImagePushMessage imagePushMessage = new ImagePushMessage();
        imagePushMessage.setImageUrl(url);
        this.req.setImagePushMessage(imagePushMessage);
        return this;
    }

    public PushMsgBuilder video(String url) {
        VideoPushMessage videoPushMessage = new VideoPushMessage();
        videoPushMessage.setVideoUrl(url);
        this.req.setVideoPushMessage(videoPushMessage);
        return this;
    }

    public PushMsgBuilder voice(String url, int lengthInSecond) {
        VoicePushMessage voicePushMessage = new VoicePushMessage();
        voicePushMessage.setVoiceUrl(url);
        voicePushMessage.setLengthInSecond(lengthInSecond);
        this.req.setVoicePushMessage(voicePushMessage);
        return this;
    }

    public PushMsgBuilder link(String title, String desc, String url, String thumbUrl) {
        LinkCardPushMessage linkCard = new LinkCardPushMessage();
        linkCard.setTitle(title);
        linkCard.setDesc(desc);
        linkCard.setLinkUrl(url);
        linkCard.setIconUrl(thumbUrl);
        this.req.setLinkCardPushMessage(linkCard);
        return this;
    }

    public PushMsgBuilder file(String name, String url) {
        FilePushMessage filePushMessage = new FilePushMessage();
        filePushMessage.setFileName(name);
        filePushMessage.setFileUrl(url);
        this.req.setFilePushMessage(filePushMessage);
        return this;
    }

    public PushMsgBuilder atMembers(List<String> memberIds) {
        AtMemberPushMessage atMemberPushMessage = new AtMemberPushMessage();
        atMemberPushMessage.setConcatAt(true);
        atMemberPushMessage.setMemberIds(memberIds);
        atMemberPushMessage.setContent(" ");
        this.req.setAtMemberPushMessage(atMemberPushMessage);
        return this;
    }

    public PushMsgBuilder atMembers(List<String> memberIds, String content) {
        AtMemberPushMessage atMemberPushMessage = new AtMemberPushMessage();
        atMemberPushMessage.setConcatAt(true);
        atMemberPushMessage.setMemberIds(memberIds);
        atMemberPushMessage.setContent(content);
        this.req.setAtMemberPushMessage(atMemberPushMessage);
        return this;
    }

    public PushMsgBuilder miniProgram(String username, String nickname, String url, String pagePath, String title, String iconUrl, String thumbUrl) {
        AppletPushMessage appletPushMessage = new AppletPushMessage();
        appletPushMessage.setNameWithApp(username);
        appletPushMessage.setNickName(nickname);
        appletPushMessage.setUrl(url);
        appletPushMessage.setPagePath(pagePath);
        appletPushMessage.setTitle(title);
        appletPushMessage.setIconUrl(iconUrl);
        appletPushMessage.setThumbIconUrl(thumbUrl);
        this.req.setAppletPushMessage(appletPushMessage);
        return this;
    }

    public PushMessageRequestS build() {
        this.req.setWId(this.wId);
        this.req.setTo(this.to);
        this.req.setControl(this.control);
        return this.req;
    }
}

