/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.marketing;

import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.market.entity.MarketWechatContact;
import com.kuaike.skynet.logic.dal.market.mapper.MarketWechatContactMapper;
import com.kuaike.skynet.logic.service.common.enums.MarketContactStatus;
import com.kuaike.skynet.logic.service.common.enums.MarketingPlanType;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MarketingContactStatusHandler {
    private static final Logger log = LoggerFactory.getLogger(MarketingContactStatusHandler.class);
    @Autowired
    private MarketWechatContactMapper marketWechatContactMapper;

    @Transactional(rollbackFor={Exception.class})
    public void onWaitJoinFriendEvent(MarketingPlanType planType, Long planId) {
        ReplyContext ctx = ReplyContextUtil.get();
        String wechatId = ctx.getWechatId();
        String talkerId = ctx.getTalkerId();
        Integer status = MarketContactStatus.APPLY_FOR_ADD_FRIEND.getValue();
        Integer type = planType.getValue();
        List ids = this.marketWechatContactMapper.queryExistIds(wechatId, talkerId, type, planId);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            log.info("insert market wechat contact status, requestId={}, planType={}, planId={}", new Object[]{ctx.getRequestId(), planType, planId});
            MarketWechatContact record = this.newRecord(wechatId, talkerId, type, planId, status);
            this.marketWechatContactMapper.insertSelective((Object)record);
        } else {
            log.info("Already exist wechat contact status, requestIds={}, ids={}, planType={}, planId={}", new Object[]{ctx.getRequestId(), ids, planType, planId});
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void onFriendIsJoined(MarketingPlanType planType, Long planId) {
        ReplyContext ctx = ReplyContextUtil.get();
        String wechatId = ctx.getWechatId();
        String talkerId = ctx.getTalkerId();
        Integer status = MarketContactStatus.ALREADY_ADD_FRIEND.getValue();
        Integer type = planType.getValue();
        log.info("update market wechat contact status, requestId={}, planType={}, planId={}", new Object[]{ctx.getRequestId(), planType, planId});
        List ids = this.marketWechatContactMapper.queryExistIds(wechatId, talkerId, type, planId);
        if (CollectionUtils.isEmpty((Collection)ids)) {
            MarketWechatContact record = this.newRecord(wechatId, talkerId, type, planId, status);
            this.marketWechatContactMapper.insertSelective((Object)record);
        } else {
            log.info("exist ids={}", (Object)ids);
            this.marketWechatContactMapper.updateStatusByIds((Collection)ids, status);
        }
    }

    private MarketWechatContact newRecord(String wechatId, String talkerId, Integer type, Long planId, Integer status) {
        MarketWechatContact marketWechatContact = new MarketWechatContact();
        marketWechatContact.setWechatId(wechatId);
        marketWechatContact.setContactId(talkerId);
        marketWechatContact.setType(type);
        marketWechatContact.setPlanId(planId);
        marketWechatContact.setStatus(status);
        return marketWechatContact;
    }
}

