/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.marketing;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfig;
import com.kuaike.skynet.logic.dal.market.mapper.FissionPlanMapper;
import com.kuaike.skynet.logic.dal.market.mapper.MarketReplyConfigMapper;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessage;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatChatRoomGroupRelation;
import com.kuaike.skynet.logic.dal.wechat.enums.MarketRelationRoomStatus;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomGroupRelationMapper;
import com.kuaike.skynet.logic.handler.common.GroupJoinReplyHelper;
import com.kuaike.skynet.logic.handler.common.KeywordReplyHelper;
import com.kuaike.skynet.logic.handler.marketing.MarketChatRoomMemberHandler;
import com.kuaike.skynet.logic.service.cache.FissionKeywordCacheService;
import com.kuaike.skynet.logic.service.cache.dto.MatchedResult;
import com.kuaike.skynet.logic.service.client.PushMsgService;
import com.kuaike.skynet.logic.service.client.utils.PushMsgBuilder;
import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.common.dto.ReplyMessageDto;
import com.kuaike.skynet.logic.service.common.enums.IntervalMessageReplyTypeEnum;
import com.kuaike.skynet.logic.service.common.enums.MarketingPlanType;
import com.kuaike.skynet.logic.service.marketing.GroupFissionService;
import com.kuaike.skynet.logic.service.marketing.MarketingCommonService;
import com.kuaike.skynet.logic.service.marketing.dto.FissionAccomplishTaskReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.FissionJoinGroupReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.MarketChatRoomConfigDto;
import com.kuaike.skynet.logic.service.message.IntervalSendMessageService;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.dto.AutoReplyMessageDto;
import com.kuaike.skynet.logic.service.reply.dto.IntervalSendMessageReqDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FissionGroupReplyHandler {
    private static final Logger log = LoggerFactory.getLogger(FissionGroupReplyHandler.class);
    @Autowired
    private WechatChatRoomGroupRelationMapper wechatChatRoomGroupRelationMapper;
    @Autowired
    private FissionPlanMapper fissionPlanMapper;
    @Autowired
    private MarketReplyConfigMapper marketReplyConfigMapper;
    @Autowired
    private GroupJoinReplyHelper helper;
    @Autowired
    private KeywordReplyHelper keywordReplyHelper;
    @Autowired
    private FissionKeywordCacheService fissionKeywordCacheService;
    @Autowired
    private MarketingCommonService marketingCommonService;
    @Autowired
    private MarketChatRoomMemberHandler marketChatRoomMemberHandler;
    @Autowired
    private GroupFissionService groupFissionService;
    @Autowired
    private IntervalSendMessageService intervalSendMessageService;
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;
    @Autowired
    private PushMsgService pushMsgService;

    public boolean onJoinGroup() {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("Receive join group, requestId={}", (Object)ctx.getRequestId());
        ArrayList status = Lists.newArrayList((Object[])new Integer[]{MarketRelationRoomStatus.RUNNING.getValue(), MarketRelationRoomStatus.USED.getValue()});
        Long categoryId = this.wechatChatRoomGroupRelationMapper.getFissionCategoryId(ctx.getChatroomId(), (List)status);
        if (categoryId == null) {
            log.info("No fission category id found, requestId={}, chatroomId={}", (Object)ctx.getRequestId(), (Object)ctx.getChatroomId());
            return false;
        }
        Long planId = this.fissionPlanMapper.getPlanIdByCategoryId(categoryId);
        this.marketChatRoomMemberHandler.onJoinGroup(MarketingPlanType.CHATROOM_FISSION_PLAN, planId, categoryId);
        List<String> memberIds = ctx.getJoinGroupWithoutRobotWechatIds();
        if (CollectionUtils.isEmpty(memberIds)) {
            log.info("No memberIds found, requestId={}. Maybe they are robot or in blacklist, buId={}, wechatIds={}", new Object[]{ctx.getRequestId(), ctx.getBusinessCustomerId(), ctx.getJoinGroupWechatIds()});
            return false;
        }
        FissionJoinGroupReplyConfig config = this.getJoinGroupReply(categoryId);
        if (config == null) {
            log.info("No fission join group reply found, requestId={}, chatroomId={}, categoryId={}", new Object[]{ctx.getRequestId(), ctx.getChatroomId(), categoryId});
            return false;
        }
        String content = this.getJoinGroupReplyMessage(config);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.info("No reply message found, requestId={}, chatroomId={}, categoryId={}, config={}", new Object[]{ctx.getRequestId(), ctx.getChatroomId(), categoryId, config});
            return false;
        }
        Date sendTime = GroupJoinReplyHelper.getRandSendTime(config.getTimeIntervalMin(), config.getTimeIntervalMax());
        Integer memberInterval = GroupJoinReplyHelper.memberInterval(config.getMemberInterval());
        LogicIntervalSendMessage message = this.helper.get(ctx.getChatroomId(), IntervalMessageReplyTypeEnum.JOIN_GROUP);
        if (message == null) {
            message = this.helper.newJoinGroupMessage(ctx.getWechatId(), ctx.getChatroomId(), content, sendTime, memberInterval);
        }
        this.helper.saveMembers(message.getId(), ctx.getChatroomId(), memberIds);
        return true;
    }

    private FissionJoinGroupReplyConfig getJoinGroupReply(Long fissionCategoryId) {
        if (fissionCategoryId == null) {
            return null;
        }
        MarketReplyConfig marketReplyConfig = this.marketReplyConfigMapper.getJoinGroupByFissionCategoryPlanId(fissionCategoryId, new Date());
        if (marketReplyConfig == null) {
            return null;
        }
        FissionJoinGroupReplyConfig config = null;
        try {
            config = (FissionJoinGroupReplyConfig)JacksonUtil.str2Obj((String)marketReplyConfig.getJsonText(), FissionJoinGroupReplyConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Failed parsing fission join group reply config, json={}", (Object)marketReplyConfig.getJsonText(), (Object)e);
        }
        return config;
    }

    private String getJoinGroupReplyMessage(FissionJoinGroupReplyConfig config) {
        List list = config.getJoinGroupReplyMessages();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ReplyMessageDto replyMessageDto = new ReplyMessageDto(list);
        String message = JacksonUtil.obj2Str((Object)replyMessageDto);
        return message;
    }

    public boolean recvGroupText(WechatMessage wechatMessage, String text, List<String> atUsers) {
        String chatroomId = wechatMessage.getTalkerId();
        log.info("reply market keyword, requestId={}", (Object)wechatMessage.getRequestId());
        MarketChatRoomConfigDto config = this.marketingCommonService.getChatRoomConfig(chatroomId);
        if (config == null) {
            return false;
        }
        if (!config.getIsAutoReply().equals(1)) {
            log.warn("market keyword reply disabled, requestId={}", (Object)wechatMessage.getRequestId());
            return false;
        }
        if (AutoReplyRelationType.FISSION_PLAN.getValue() != config.getRelationType().intValue()) {
            log.warn("unknown market relation type, config={}", (Object)config);
            return false;
        }
        MatchedResult result = this.fissionKeywordCacheService.match((Object)config.getMarketPlanId(), text);
        return this.keywordReplyHelper.groupKeyword(result);
    }

    public boolean recvGroupImage(WechatMessage wechatMessage) {
        log.info("handleFissionTaskMessage requestId={}", (Object)wechatMessage.getRequestId());
        ReplyContext ctx = ReplyContextUtil.get();
        ArrayList status = Lists.newArrayList((Object[])new Integer[]{MarketRelationRoomStatus.RUNNING.getValue(), MarketRelationRoomStatus.USED.getValue()});
        Long categoryId = this.wechatChatRoomGroupRelationMapper.getFissionCategoryId(ctx.getChatroomId(), (List)status);
        if (categoryId == null) {
            log.info("No fission category id found, requestId={}, chatroomId={}", (Object)ctx.getRequestId(), (Object)ctx.getChatroomId());
            return false;
        }
        if (this.groupFissionService.existGroupFissionTask(ctx.getWechatId(), ctx.getChatroomId(), ctx.getTalkerId(), categoryId)) {
            return false;
        }
        FissionAccomplishTaskReplyConfig replyConfig = this.getRecvImageReply(categoryId);
        if (replyConfig == null) {
            return false;
        }
        ReplyMessageDto replyMessageDto = new ReplyMessageDto((CommonMessage)replyConfig.getReplyMessages().get(0));
        String content = JacksonUtil.obj2Str((Object)replyMessageDto);
        int seconds = (Integer)ObjectUtils.defaultIfNull((Object)replyConfig.getIntervalTime(), (Object)0);
        Date sendTime = new Date(System.currentTimeMillis() + (long)seconds * 1000L);
        Integer memberInterval = replyConfig.getPeopleInterval();
        Integer intrvalAuditTime = 0;
        replyConfig.getIntervalAuditTime();
        IntervalSendMessageReqDto req = new IntervalSendMessageReqDto();
        req.setReplyType(Integer.valueOf(IntervalMessageReplyTypeEnum.FISSION_TASK_COMPLETE.getValue()));
        req.setWechatId(ctx.getWechatId());
        req.setWechatRoomName(ctx.getChatroomId());
        req.setMemberWechatId(ctx.getTalkerId());
        req.setCreateTime(ctx.getCreateTime());
        this.intervalSendMessageService.addMember(req);
        req = new IntervalSendMessageReqDto();
        log.info("handle group image, requestId={}", (Object)ctx.getRequestId());
        req.setReplyType(Integer.valueOf(IntervalMessageReplyTypeEnum.FISSION_TASK_SUCCESS.getValue()));
        req.setWechatId(ctx.getWechatId());
        req.setWechatRoomName(ctx.getChatroomId());
        req.setMemberWechatId(ctx.getTalkerId());
        req.setCreateTime(ctx.getCreateTime());
        this.intervalSendMessageService.addMember(req);
        return true;
    }

    private FissionAccomplishTaskReplyConfig getRecvImageReply(Long fissionCategoryId) {
        if (fissionCategoryId == null) {
            return null;
        }
        MarketReplyConfig config = this.marketReplyConfigMapper.getTaskCompleteByFissionCategoryPlanId(fissionCategoryId, new Date());
        if (config == null) {
            return null;
        }
        FissionAccomplishTaskReplyConfig replyConfig = (FissionAccomplishTaskReplyConfig)JSON.parseObject((String)config.getJsonText(), FissionAccomplishTaskReplyConfig.class);
        if (replyConfig.getIsAutoReply().equals(0)) {
            return null;
        }
        return replyConfig;
    }

    private boolean onChatroomFissionTaskComplete(IntervalSendMessageReqDto req, List<WechatChatRoomGroupRelation> relationList) {
        for (WechatChatRoomGroupRelation relation : relationList) {
            if (relation.getFissionCategoryId() == null) continue;
            req.setFissionCategoryId(relation.getFissionCategoryId());
            MarketReplyConfig marketReplyConfig = this.marketReplyConfigMapper.getTaskCompleteByFissionCategoryPlanId(relation.getFissionCategoryId(), new Date());
            if (marketReplyConfig == null) {
                return false;
            }
            FissionAccomplishTaskReplyConfig replyConfig = (FissionAccomplishTaskReplyConfig)JSON.parseObject((String)marketReplyConfig.getJsonText(), FissionAccomplishTaskReplyConfig.class);
            if (replyConfig.getIsAutoReply().equals(0)) {
                return false;
            }
            ReplyMessageDto replyMessageDto = new ReplyMessageDto((CommonMessage)replyConfig.getReplyMessages().get(0));
            req.setMessage(JacksonUtil.obj2Str((Object)replyMessageDto));
            long sendTimeBase = System.currentTimeMillis();
            int seconds = (Integer)ObjectUtils.defaultIfNull((Object)replyConfig.getIntervalTime(), (Object)0);
            req.setSendTime(new Date(sendTimeBase + (long)(seconds * 1000)));
            req.setMemberInterval(replyConfig.getPeopleInterval());
            req.setIntervalAuditTime(Integer.valueOf(0));
            return true;
        }
        return false;
    }

    private boolean onChatroomFissionTaskSuccess(IntervalSendMessageReqDto req, List<WechatChatRoomGroupRelation> relationList) {
        for (WechatChatRoomGroupRelation relation : relationList) {
            if (relation.getFissionCategoryId() == null) continue;
            req.setFissionCategoryId(relation.getFissionCategoryId());
            MarketReplyConfig marketReplyConfig = this.marketReplyConfigMapper.getTaskCompleteByFissionCategoryPlanId(relation.getFissionCategoryId(), new Date());
            if (marketReplyConfig == null) {
                return false;
            }
            FissionAccomplishTaskReplyConfig replyConfig = (FissionAccomplishTaskReplyConfig)JSON.parseObject((String)marketReplyConfig.getJsonText(), FissionAccomplishTaskReplyConfig.class);
            if (replyConfig.getIsAutoReply().equals(0)) {
                return false;
            }
            req.setMessage("");
            long sendTimeBase = System.currentTimeMillis();
            int seconds = (Integer)ObjectUtils.defaultIfNull((Object)replyConfig.getIntervalTime(), (Object)0);
            req.setSendTime(new Date(sendTimeBase + (long)(seconds * 1000)));
            req.setMemberInterval(Integer.valueOf(0));
            int minutes = (Integer)ObjectUtils.defaultIfNull((Object)replyConfig.getIntervalAuditTime(), (Object)0);
            req.setIntervalAuditTime(Integer.valueOf(minutes));
            return true;
        }
        return false;
    }

    private boolean onChatroomFissionTaskFail(IntervalSendMessageReqDto req, List<WechatChatRoomGroupRelation> relationList) {
        for (WechatChatRoomGroupRelation relation : relationList) {
            if (relation.getFissionCategoryId() == null) continue;
            req.setFissionCategoryId(relation.getFissionCategoryId());
            MarketReplyConfig marketReplyConfig = this.marketReplyConfigMapper.getTaskCompleteByFissionCategoryPlanId(relation.getFissionCategoryId(), new Date());
            if (marketReplyConfig == null) {
                return false;
            }
            FissionAccomplishTaskReplyConfig replyConfig = (FissionAccomplishTaskReplyConfig)JSON.parseObject((String)marketReplyConfig.getJsonText(), FissionAccomplishTaskReplyConfig.class);
            if (replyConfig.getIsAutoReply().equals(0)) {
                return false;
            }
            ReplyMessageDto replyMessageDto = new ReplyMessageDto((CommonMessage)replyConfig.getReplyMessages().get(1));
            req.setMessage(JacksonUtil.obj2Str((Object)replyMessageDto));
            long sendTimeBase = System.currentTimeMillis();
            int minutes = (Integer)ObjectUtils.defaultIfNull((Object)replyConfig.getIntervalAuditTime(), (Object)0);
            req.setSendTime(new Date(sendTimeBase + (long)(minutes * 60 * 1000)));
            req.setMemberInterval(Integer.valueOf(0));
            req.setIntervalAuditTime(Integer.valueOf(0));
            return true;
        }
        return false;
    }

    public boolean recvFriendText() {
        String url;
        ReplyContext ctx = ReplyContextUtil.get();
        String wechatId = ctx.getWechatId();
        String talkerId = ctx.getTalkerId();
        String text = ctx.getPureMsg();
        log.info("Send reward on keyword with requestId={}, talkerId={}, text={}", new Object[]{ctx.getRequestId(), talkerId, text});
        Map dataMap = this.groupFissionService.getRewordConfig();
        if (MapUtils.isEmpty((Map)dataMap)) {
            log.info("No available send reward activity.");
            return false;
        }
        Map dataPackageMap = (Map)dataMap.get(text);
        if (MapUtils.isEmpty((Map)dataPackageMap)) {
            log.info("Keyword is not matched to send reward.");
            return false;
        }
        Map reward = (Map)dataPackageMap.get(wechatId);
        if (MapUtils.isEmpty((Map)reward)) {
            log.info("Wechat is not matched to send reward. wechatId={}", (Object)wechatId);
            return false;
        }
        log.info("Matching keyword, sending reward. wechatId={}, talkerId={}, reward={}", new Object[]{wechatId, talkerId, reward});
        String rewardMessages = (String)reward.get("rewardMessages");
        if (this.replyRewardMessage(wechatId, talkerId, rewardMessages)) {
            log.info("reply reward message={}", (Object)rewardMessages);
            return true;
        }
        String name = (String)reward.get("name");
        if (this.replyRewardDataPackage(wechatId, talkerId, name, url = (String)reward.get("url"))) {
            return true;
        }
        log.info("No reward to reply.");
        return false;
    }

    private boolean replyRewardMessage(String wechatId, String talkerId, String rewardMessages) {
        log.info("reply reward message={}", (Object)rewardMessages);
        if (StringUtils.isBlank((CharSequence)rewardMessages)) {
            return false;
        }
        List replyMessage = null;
        try {
            replyMessage = JacksonUtil.str2List((String)rewardMessages, AutoReplyMessageDto.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Failed to parse reward messages={}", (Object)rewardMessages);
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)replyMessage)) {
            log.warn("reward messages is empty, rewardMessages={}", (Object)rewardMessages);
            return false;
        }
        ReplyMessageDto replyMessageDto = this.replyMessageDtoService.toReplyMessageDto((Collection)replyMessage);
        boolean flag = false;
        for (CommonMessage dto : replyMessageDto.getReplyMessage()) {
            try {
                this.pushMsgService.pushMessage(wechatId, talkerId, dto.getType(), dto.getContent(), null);
                flag = true;
            }
            catch (Exception e) {
                log.error("Failed reply message, wechatId={}, talkerId={} msg:{}", new Object[]{wechatId, talkerId, dto, e});
                e.printStackTrace();
            }
        }
        return flag;
    }

    private boolean replyRewardDataPackage(String wechatId, String talkerId, String name, String url) {
        log.info("reply reward datapack, name={}, url={}", (Object)name, (Object)url);
        if (StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)url)) {
            log.info("data pack is empty");
            return false;
        }
        PushMsgBuilder builder = PushMsgBuilder.builder().wId(wechatId).to(talkerId).control(false);
        try {
            if (StringUtils.endsWithIgnoreCase((CharSequence)url, (CharSequence)".png") || StringUtils.endsWithIgnoreCase((CharSequence)url, (CharSequence)".jpeg")) {
                builder.image(url);
            } else {
                builder.file(name, url);
            }
            this.pushMsgService.pushMessage(builder.build());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed sending reward.", (Throwable)e);
            return false;
        }
    }
}

