/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.marketing;

import com.google.common.collect.Lists;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.market.entity.MarketReplyConfig;
import com.kuaike.skynet.logic.dal.market.mapper.DrainagePlanMapper;
import com.kuaike.skynet.logic.dal.market.mapper.MarketReplyConfigMapper;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessage;
import com.kuaike.skynet.logic.dal.wechat.enums.MarketRelationRoomStatus;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomGroupRelationMapper;
import com.kuaike.skynet.logic.handler.common.GroupJoinReplyHelper;
import com.kuaike.skynet.logic.handler.common.KeywordReplyHelper;
import com.kuaike.skynet.logic.handler.marketing.MarketChatRoomMemberHandler;
import com.kuaike.skynet.logic.service.cache.DrainageKeywordCacheService;
import com.kuaike.skynet.logic.service.cache.dto.MatchedResult;
import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.common.dto.ReplyMessageDto;
import com.kuaike.skynet.logic.service.common.enums.IntervalMessageReplyTypeEnum;
import com.kuaike.skynet.logic.service.common.enums.MarketingPlanType;
import com.kuaike.skynet.logic.service.marketing.MarketingCommonService;
import com.kuaike.skynet.logic.service.marketing.dto.DrainageJoinGroupReplyConfig;
import com.kuaike.skynet.logic.service.marketing.dto.MarketChatRoomConfigDto;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyMessageType;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyRelationType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DrainageGroupReplyHandler {
    private static final Logger log = LoggerFactory.getLogger(DrainageGroupReplyHandler.class);
    @Autowired
    private WechatChatRoomGroupRelationMapper wechatChatRoomGroupRelationMapper;
    @Autowired
    private DrainagePlanMapper drainagePlanMapper;
    @Autowired
    private MarketReplyConfigMapper marketReplyConfigMapper;
    @Autowired
    private GroupJoinReplyHelper joinGroupReplyHelper;
    @Autowired
    private KeywordReplyHelper keywordReplyHelper;
    @Autowired
    private DrainageKeywordCacheService drainageKeywordCacheService;
    @Autowired
    private MarketingCommonService marketingCommonService;
    @Autowired
    private MarketChatRoomMemberHandler marketChatRoomMemberHandler;

    public boolean onJoinGroup() {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("Receive join group, requestId={}", (Object)ctx.getRequestId());
        ArrayList status = Lists.newArrayList((Object[])new Integer[]{MarketRelationRoomStatus.RUNNING.getValue(), MarketRelationRoomStatus.USED.getValue()});
        Long categoryId = this.wechatChatRoomGroupRelationMapper.getDrainageCategoryId(ctx.getChatroomId(), (List)status);
        if (categoryId == null) {
            log.info("No drainage category id found, requestId={}, chatroomId={}", (Object)ctx.getRequestId(), (Object)ctx.getChatroomId());
            return false;
        }
        Long planId = this.drainagePlanMapper.getPlanIdByCategoryId(categoryId);
        this.marketChatRoomMemberHandler.onJoinGroup(MarketingPlanType.CHATROOM_DRAINAGE_PLAN, planId, categoryId);
        List<String> memberIds = ctx.getJoinGroupWithoutRobotWechatIds();
        if (CollectionUtils.isEmpty(memberIds)) {
            log.info("No memberIds found, requestId={}. Maybe they are robot or in blacklist, buId={}, wechatIds={}", new Object[]{ctx.getRequestId(), ctx.getBusinessCustomerId(), ctx.getJoinGroupWechatIds()});
            return false;
        }
        DrainageJoinGroupReplyConfig config = this.getJoinGroupReply(categoryId);
        if (config == null) {
            log.info("No drainage join group reply found, requestId={}, chatroomId={}, categoryId={}", new Object[]{ctx.getRequestId(), ctx.getChatroomId(), categoryId});
            return false;
        }
        String content = this.toMessage(config);
        if (StringUtils.isBlank((CharSequence)content)) {
            log.info("No reply message found, requestId={}, chatroomId={}, categoryId={}, config={}", new Object[]{ctx.getRequestId(), ctx.getChatroomId(), categoryId, config});
            return false;
        }
        Date sendTime = GroupJoinReplyHelper.getRandSendTime(config.getTimeIntervalMin(), config.getTimeIntervalMax());
        Integer memberInterval = GroupJoinReplyHelper.memberInterval(config.getMemberInterval());
        LogicIntervalSendMessage message = this.joinGroupReplyHelper.get(ctx.getChatroomId(), IntervalMessageReplyTypeEnum.JOIN_GROUP);
        if (message == null) {
            message = this.joinGroupReplyHelper.newJoinGroupMessage(ctx.getWechatId(), ctx.getChatroomId(), content, sendTime, memberInterval);
        }
        this.joinGroupReplyHelper.saveMembers(message.getId(), ctx.getChatroomId(), memberIds);
        return true;
    }

    private DrainageJoinGroupReplyConfig getJoinGroupReply(Long drainageCategoryId) {
        MarketReplyConfig marketReplyConfig = this.marketReplyConfigMapper.getJoinGroupByDrainageCategoryPlanId(drainageCategoryId, new Date());
        if (marketReplyConfig == null) {
            return null;
        }
        DrainageJoinGroupReplyConfig config = null;
        try {
            config = (DrainageJoinGroupReplyConfig)JacksonUtil.str2Obj((String)marketReplyConfig.getJsonText(), DrainageJoinGroupReplyConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Failed parsing drainage join group reply config, json={}", (Object)marketReplyConfig.getJsonText(), (Object)e);
        }
        if (config.getIsAutoReply().equals(0)) {
            return null;
        }
        return config;
    }

    private String toMessage(DrainageJoinGroupReplyConfig config) {
        List list = config.getJoinGroupReplyMessages();
        if (StringUtils.isNotBlank((CharSequence)config.getWechatId())) {
            if (CollectionUtils.isEmpty((Collection)list)) {
                list = Lists.newArrayList();
            }
            CommonMessage commonMessage = new CommonMessage();
            commonMessage.setSeq(Integer.valueOf(2));
            commonMessage.setContent(config.getWechatId());
            commonMessage.setType(Integer.valueOf(AutoReplyMessageType.B_CARD.getValue()));
            if (list.size() >= 1) {
                list.add(1, commonMessage);
            } else {
                list.add(commonMessage);
            }
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ReplyMessageDto replyMessageDto = new ReplyMessageDto(list);
        String message = JacksonUtil.obj2Str((Object)replyMessageDto);
        return message;
    }

    public boolean recvGroupText(WechatMessage wechatMessage, String text, List<String> atUsers) {
        String chatroomId = wechatMessage.getTalkerId();
        log.info("reply market keyword, requestId={}", (Object)wechatMessage.getRequestId());
        MarketChatRoomConfigDto config = this.marketingCommonService.getChatRoomConfig(chatroomId);
        if (config == null) {
            return false;
        }
        if (!config.getIsAutoReply().equals(1)) {
            log.warn("market keyword reply disabled, requestId={}", (Object)wechatMessage.getRequestId());
            return false;
        }
        if (AutoReplyRelationType.DRAINAGE_PLAN.getValue() != config.getRelationType().intValue()) {
            log.warn("unknown market relation type, config={}", (Object)config);
            return false;
        }
        MatchedResult result = this.drainageKeywordCacheService.match((Object)config.getMarketPlanId(), text);
        return this.keywordReplyHelper.groupKeyword(result);
    }
}

