/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.debug;

import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.logic.service.client.PushMsgService;
import com.kuaike.skynet.logic.service.client.utils.PushMsgBuilder;
import com.kuaike.skynet.logic.service.debug.DebugEntrance;
import com.kuaike.skynet.logic.service.debug.dto.DebugResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DebugReplyHandler {
    private static final Logger log = LoggerFactory.getLogger(DebugReplyHandler.class);
    @Autowired
    private DebugEntrance debugEntrance;
    @Autowired
    private PushMsgService pushMsgService;

    public boolean recvText(WechatMessage wechatMessage) {
        String from = wechatMessage.getWechatId();
        String to = wechatMessage.getTalkerId();
        PushMsgBuilder builder = PushMsgBuilder.builder().to(to).wId(from).control(false);
        try {
            DebugResult result = this.debugEntrance.process(wechatMessage);
            if (result != null && result.isValid()) {
                if (result.getCode() == 0) {
                    this.pushMsgService.pushMessage(builder.text(result.getMsg()).build());
                } else {
                    this.pushMsgService.pushMessage(builder.text("error code: " + result.getCode() + "\n" + result.getMsg()).build());
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Debug failed", (Throwable)e);
            DebugResult result = DebugResult.exception((Throwable)e);
            this.pushMsgService.pushMessage(builder.text(result.getMsg()).build());
            return true;
        }
        return false;
    }
}

