/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.common;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.kuaike.skynet.link.service.dto.WechatStatusInfo;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.wechat.dto.ChatRoomMember;
import com.kuaike.skynet.logic.dal.wechat.entity.WechatContact;
import com.kuaike.skynet.logic.dal.wechat.enums.WechatAccountType;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatChatRoomRelationMapper;
import com.kuaike.skynet.logic.dal.wechat.mapper.WechatContactMapper;
import com.kuaike.skynet.logic.handler.common.MsgDigestHelper;
import com.kuaike.skynet.logic.service.cache.ReplyOptionCacheService;
import com.kuaike.skynet.logic.service.cache.WechatAccountCacheService;
import com.kuaike.skynet.logic.service.cache.dto.CachedReplyMsg;
import com.kuaike.skynet.logic.service.client.PushMsgService;
import com.kuaike.skynet.logic.service.common.SettingService;
import com.kuaike.skynet.logic.service.common.dto.CommonMessage;
import com.kuaike.skynet.logic.service.common.dto.ReplyMessageDto;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.reply.ReplyMessageDtoService;
import com.kuaike.skynet.logic.service.reply.enums.AutoReplyMessageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplyMsgSendHelper {
    private static final Logger log = LoggerFactory.getLogger(ReplyMsgSendHelper.class);
    @Autowired
    private MsgDigestHelper msgDigestHelper;
    @Autowired
    private ReplyMessageDtoService replyMessageDtoService;
    @Autowired
    private ReplyOptionCacheService replyOptionCacheService;
    @Autowired
    private PushMsgService pushMsgService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private WechatAccountCacheService wechatAccountCacheService;
    @Autowired
    private WechatChatRoomRelationMapper wechatChatRoomRelationMapper;
    @Autowired
    private WechatContactMapper wechatContactMapper;
    public static String REF_FORMAT = "\u300c %s: %s \u300d\n- - - - - - - - - - - - - - -";

    public boolean sendFriendOption(String text, List<CachedReplyMsg> matched) {
        log.info("send reply options with matched reply={}", matched);
        ReplyContext ctx = ReplyContextUtil.get();
        String wechatId = ctx.getWechatId();
        String talkerId = ctx.getTalkerId();
        Long businessCustomerId = ctx.getBusinessCustomerId();
        String content = this.replyOptionCacheService.buildOptions("\u4ee5\u4e0b\u5185\u5bb9\u662f\u5426\u80fd\u591f\u5e2e\u52a9\u5230\u60a8\uff1f\u60a8\u53ef\u4ee5\u56de\u590d\u6570\u5b57\u9009\u62e9\uff1a", matched);
        String digest = SHA1Utils.digest((String)content);
        if (this.msgDigestHelper.isCached(digest)) {
            return true;
        }
        this.replyOptionCacheService.clearCache(ctx.getBusinessCustomerId(), ctx.getWechatId(), ctx.getTalkerId());
        try {
            this.pushMsgService.pushMessage(wechatId, talkerId, AutoReplyMessageType.TEXT.getValue(), content, null);
        }
        catch (Exception e) {
            log.error("send message failed, requestId={}, message={}", new Object[]{ctx.getRequestId(), content, e});
            return false;
        }
        String redisKey = this.replyOptionCacheService.getReplyOptionKey(businessCustomerId, wechatId, talkerId);
        this.replyOptionCacheService.cache(redisKey, wechatId, businessCustomerId, text, matched);
        this.msgDigestHelper.cache(digest);
        return true;
    }

    public boolean sendFriendMsg(String question, String keyword, CachedReplyMsg cachedReplyMsg) {
        String ref;
        ReplyContext ctx = ReplyContextUtil.get();
        String wechatId = ctx.getWechatId();
        String talkerId = ctx.getTalkerId();
        Long businessCustomerId = ctx.getBusinessCustomerId();
        String digest = keyword;
        if (digest == null) {
            digest = cachedReplyMsg.getDigest();
        }
        if (this.msgDigestHelper.isCached(digest)) {
            return true;
        }
        String replyMessage = cachedReplyMsg.getMsg();
        ReplyMessageDto replyMessageDto = this.replyMessageDtoService.toReplyMessageDto(replyMessage);
        List replyMsgList = replyMessageDto.getReplyMessage();
        if (CollectionUtils.isEmpty((Collection)replyMsgList)) {
            log.warn("No reply message found: result={}", (Object)replyMessage);
            return false;
        }
        boolean isReferText = this.settingService.isReferFriendText(businessCustomerId);
        if (isReferText && StringUtils.isNotBlank((CharSequence)(ref = this.buildFriendRefText(wechatId, talkerId, question)))) {
            this.addReferText(ref, replyMsgList);
        }
        boolean flag = false;
        int size = replyMsgList.size();
        for (int i = 0; i < size; ++i) {
            CommonMessage item = (CommonMessage)replyMsgList.get(i);
            Integer type = item.getType();
            boolean pushed = false;
            try {
                pushed = this.pushMsgService.pushMessage(wechatId, talkerId, type, item.getContent(), null);
                if (!flag && pushed) {
                    flag = true;
                }
            }
            catch (Exception e) {
                log.error("send message failed, requestId={}, message={}", new Object[]{ctx.getRequestId(), item, e});
                e.printStackTrace();
            }
            if (!pushed || i >= size - 1) continue;
            this.pushMsgService.sleep();
        }
        this.msgDigestHelper.cache(digest);
        return flag;
    }

    private String buildFriendRefText(String wechatId, String talkerId, String question) {
        if (StringUtils.isBlank((CharSequence)question)) {
            return null;
        }
        WechatContact contact = this.wechatContactMapper.getContact(wechatId, talkerId);
        if (contact == null) {
            log.warn("Wechat contact not found, wechatId={}, talkerId={}", (Object)wechatId, (Object)talkerId);
            return null;
        }
        String nickname = contact.getNickname();
        return String.format(REF_FORMAT, nickname, question);
    }

    public boolean sendGroupOption(List<String> preferredWechatIds, String text, List<CachedReplyMsg> matched) {
        String title;
        String content;
        String digest;
        log.info("send reply options with matched reply={}", matched);
        ReplyContext ctx = ReplyContextUtil.get();
        String wechatId = ctx.getWechatId();
        String chatroomId = ctx.getChatroomId();
        String chatroomTalkerId = ctx.getTalkerId();
        Long businessCustomerId = ctx.getBusinessCustomerId();
        List<String> memberIds = null;
        if (this.settingService.isAtMember(businessCustomerId)) {
            memberIds = Collections.singletonList(chatroomTalkerId);
        }
        if (this.msgDigestHelper.isCached(digest = SHA1Utils.digest((String)(content = this.replyOptionCacheService.buildOptions(title = this.settingService.needAtRobot(businessCustomerId) ? "\u4ee5\u4e0b\u5185\u5bb9\u662f\u5426\u80fd\u591f\u5e2e\u52a9\u5230\u60a8\uff1f\u60a8\u53ef\u4ee5@\u6211\u5e76\u56de\u590d\u4ee5\u4e0b\u6570\u5b57\u9009\u62e9\uff1a" : "\u4ee5\u4e0b\u5185\u5bb9\u662f\u5426\u80fd\u591f\u5e2e\u52a9\u5230\u60a8\uff1f\u60a8\u53ef\u4ee5\u56de\u590d\u4ee5\u4e0b\u6570\u5b57\u9009\u62e9\uff1a", matched))))) {
            return true;
        }
        String wId = this.getAvailableBot(businessCustomerId, preferredWechatIds, wechatId);
        if (wId == null) {
            log.info("Need @robot, but not found any online bots.", preferredWechatIds);
            return false;
        }
        this.replyOptionCacheService.clearCache(ctx.getBusinessCustomerId(), chatroomId, chatroomTalkerId);
        try {
            this.pushMsgService.pushMessage(wId, chatroomId, AutoReplyMessageType.TEXT.getValue(), content, memberIds);
        }
        catch (Exception e) {
            log.error("send message failed, requestId={}, message={}", new Object[]{ctx.getRequestId(), content, e});
            return false;
        }
        String redisKey = this.replyOptionCacheService.getReplyOptionKey(businessCustomerId, chatroomId, chatroomTalkerId);
        this.replyOptionCacheService.cache(redisKey, wId, businessCustomerId, text, matched);
        this.msgDigestHelper.cache(digest);
        return true;
    }

    public boolean sendGroupMsg(List<String> preferredWechatIds, String question, String keyword, CachedReplyMsg cachedReplyMsg) {
        String referText;
        ReplyContext ctx = ReplyContextUtil.get();
        String wechatId = ctx.getWechatId();
        String chatroomId = ctx.getChatroomId();
        String memberId = ctx.getTalkerId();
        Long businessCustomerId = ctx.getBusinessCustomerId();
        String digest = keyword;
        if (digest == null) {
            digest = cachedReplyMsg.getDigest();
        }
        if (this.msgDigestHelper.isCached(digest)) {
            return true;
        }
        String replyMessage = cachedReplyMsg.getMsg();
        String wid = this.getAvailableBot(businessCustomerId, preferredWechatIds, wechatId);
        if (wid == null) {
            log.info("Need @robot, but not found any online bots.", preferredWechatIds);
            return false;
        }
        ReplyMessageDto replyMessageDto = this.replyMessageDtoService.toReplyMessageDto(replyMessage);
        List replyMsgList = replyMessageDto.getReplyMessage();
        if (CollectionUtils.isEmpty((Collection)replyMsgList)) {
            log.warn("No reply message found: result={}", (Object)cachedReplyMsg);
            return false;
        }
        boolean isReferText = this.settingService.isReferText(businessCustomerId);
        if (isReferText && StringUtils.isNotBlank((CharSequence)(referText = this.buildGroupRefText(chatroomId, memberId, question)))) {
            this.addReferText(referText, replyMsgList);
        }
        boolean isAtMember = this.settingService.isAtMember(businessCustomerId);
        ArrayList memberIds = null;
        if (isAtMember) {
            memberIds = Lists.newArrayList((Object[])new String[]{memberId});
        }
        boolean flag = false;
        int size = replyMsgList.size();
        for (int i = 0; i < size; ++i) {
            CommonMessage message = (CommonMessage)replyMsgList.get(i);
            Integer type = message.getType();
            String content = message.getContent();
            boolean pushed = false;
            try {
                pushed = this.pushMsgService.pushMessage(wid, chatroomId, type, content, memberIds);
                if (!flag && pushed) {
                    flag = true;
                }
            }
            catch (Exception e) {
                log.error("send message failed, requestId={}, message={}", new Object[]{ctx.getRequestId(), message, e});
                e.printStackTrace();
            }
            if (pushed && memberIds != null) {
                memberIds = null;
            }
            if (!pushed || i >= size - 1) continue;
            this.pushMsgService.sleep();
        }
        this.msgDigestHelper.cache(digest);
        return flag;
    }

    private void addReferText(String refText, List<CommonMessage> replyMsgList) {
        CommonMessage firstMsg = replyMsgList.get(0);
        if (Objects.equal((Object)firstMsg.getType(), (Object)AutoReplyMessageType.TEXT.getValue())) {
            firstMsg.setContent(refText + "\n" + firstMsg.getContent());
        } else {
            CommonMessage msg = new CommonMessage();
            msg.setType(Integer.valueOf(AutoReplyMessageType.TEXT.getValue()));
            msg.setContent(refText);
            msg.setSeq(Integer.valueOf(0));
            replyMsgList.add(0, msg);
        }
    }

    private String buildGroupRefText(String chatroomId, String memberId, String question) {
        ChatRoomMember member = this.wechatChatRoomRelationMapper.getChatRoomMember(chatroomId, memberId);
        if (member == null) {
            log.warn("Chatroom member not found, chatroomId={}, memberId={}", (Object)chatroomId, (Object)memberId);
            return null;
        }
        String nickname = member.getNickname();
        return String.format(REF_FORMAT, nickname, question);
    }

    public String getAvailableBot(Long businessCustomerId, List<String> preferredWechatIds, String wechatId) {
        boolean needAtRobot = this.settingService.needAtRobot(businessCustomerId);
        if (needAtRobot) {
            wechatId = null;
        }
        if (CollectionUtils.isEmpty((Collection)(preferredWechatIds = this.wechatAccountCacheService.queryRobotWechatIds(businessCustomerId, preferredWechatIds)))) {
            return wechatId;
        }
        this.wechatAccountCacheService.removeByType((Collection)preferredWechatIds, WechatAccountType.ATMOSPHERE_ROBOT);
        if (CollectionUtils.isEmpty((Collection)preferredWechatIds)) {
            return wechatId;
        }
        List<WechatStatusInfo> result = this.pushMsgService.queryWechatStatus(preferredWechatIds);
        if (CollectionUtils.isEmpty(result)) {
            return wechatId;
        }
        Optional<WechatStatusInfo> frist = result.stream().filter(it -> it.isOnline()).findFirst();
        if (frist.isPresent()) {
            String preferred = frist.get().getWId();
            log.info("use preferred wechatId={}", (Object)preferred);
            return preferred;
        }
        return wechatId;
    }
}

