/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessage;
import com.kuaike.skynet.logic.dal.reply.entity.LogicIntervalSendMessageMember;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicIntervalSendMessageMapper;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicIntervalSendMessageMemberMapper;
import com.kuaike.skynet.logic.service.common.enums.IntervalMessageReplyTypeEnum;
import com.kuaike.skynet.logic.service.common.enums.MessageSendStatusEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupJoinReplyHelper {
    private static final Logger log = LoggerFactory.getLogger(GroupJoinReplyHelper.class);
    @Autowired
    private LogicIntervalSendMessageMapper logicIntervalSendMessageMapper;
    @Autowired
    private LogicIntervalSendMessageMemberMapper logicIntervalSendMessageMemberMapper;

    public LogicIntervalSendMessage get(String chatRoomId, IntervalMessageReplyTypeEnum replyType) {
        return this.logicIntervalSendMessageMapper.getChatRoomMsg(chatRoomId, replyType.getValue(), MessageSendStatusEnum.WAIT_SEND.getValue());
    }

    public LogicIntervalSendMessage newJoinGroupMessage(String wechatId, String chatRoomId, String message, Date sendTime, Integer memberInterval) {
        LogicIntervalSendMessage sendMessage = new LogicIntervalSendMessage();
        sendMessage.setWechatId(wechatId);
        sendMessage.setWechatRoomName(chatRoomId);
        sendMessage.setMessage(message);
        sendMessage.setReplyType(Integer.valueOf(IntervalMessageReplyTypeEnum.JOIN_GROUP.getValue()));
        sendMessage.setSendTime(sendTime);
        sendMessage.setMemberInterval(memberInterval);
        this.logicIntervalSendMessageMapper.insertSelective((Object)sendMessage);
        log.info("Save join group logic interval send message with id={}, wechatId={}, chatroomId={}, sendTime={}, memberInterval={}, message={}", new Object[]{sendMessage.getId(), wechatId, chatRoomId, sendTime, memberInterval, message});
        return sendMessage;
    }

    public void saveMembers(Long id, String chatroomId, List<String> memberWechatIdList) {
        List memberIds = this.logicIntervalSendMessageMemberMapper.getMemberIds(id);
        HashSet exists = Sets.newHashSet((Iterable)memberIds);
        ArrayList remove = Lists.newArrayList();
        ArrayList add = Lists.newArrayList();
        ArrayList members = Lists.newArrayList();
        for (String memberWechatId : memberWechatIdList) {
            if (exists.contains(memberWechatId)) {
                remove.add(memberWechatId);
                continue;
            }
            add.add(memberWechatId);
            LogicIntervalSendMessageMember member = new LogicIntervalSendMessageMember();
            member.setIntervalSendMessageId(id);
            member.setWechatRoomName(chatroomId);
            member.setMemberWechatId(memberWechatId);
            members.add(member);
        }
        if (CollectionUtils.isNotEmpty((Collection)remove)) {
            log.info("Ingore exists member, reply.id={}, memberIds={}", (Object)id, (Object)remove);
        }
        if (CollectionUtils.isNotEmpty((Collection)members)) {
            log.info("Save members, reply.id={}, memberIds={}", (Object)id, (Object)add);
            this.logicIntervalSendMessageMemberMapper.batchInsert((List)members);
        }
    }

    public static Date getRandSendTime(Integer min, Integer max) {
        int minInterval = min == null ? 30 : min;
        int maxInterval = max == null ? 50 : max;
        int interval = new Double((double)minInterval + Math.random() * (double)(maxInterval - minInterval)).intValue();
        return new Date(System.currentTimeMillis() + (long)interval * 1000L);
    }

    public static int memberInterval(Integer memberInterval) {
        return memberInterval == null ? 3 : memberInterval;
    }
}

