/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.biz;

import com.google.common.collect.Lists;
import com.kuaike.skynet.logic.handler.marketing.MarketingTrafficLevelHelper;
import com.kuaike.skynet.logic.service.reply.dto.label.LabelItemDto;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FriendTagLabelCommonService {
    private static final Logger log = LoggerFactory.getLogger(FriendTagLabelCommonService.class);
    @Autowired
    private MarketingTrafficLevelHelper marketingTrafficLevelHelper;

    public boolean tagLabel(Set<LabelItemDto> labelItemDtos) {
        if (CollectionUtils.isEmpty(labelItemDtos)) {
            return false;
        }
        HashMap<Long, List> levelIdMap = new HashMap<Long, List>();
        for (LabelItemDto itemDto : labelItemDtos) {
            List list2 = levelIdMap.computeIfAbsent(itemDto.getFlowLevelId(), t -> Lists.newArrayList());
            list2.add(itemDto.getLabelId());
        }
        levelIdMap.forEach((levelId, list) -> this.marketingTrafficLevelHelper.onFriendIsJoined((Long)levelId, (List<Long>)list));
        return true;
    }
}

