/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.biz;

import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.handler.biz.FriendTagLabelCommonService;
import com.kuaike.skynet.logic.service.cache.FriendKeywordTagLabelCacheService;
import com.kuaike.skynet.logic.service.cache.dto.MatchedResult;
import com.kuaike.skynet.logic.service.reply.dto.label.LabelItemDto;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FriendKeywordTagLabelHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendKeywordTagLabelHandler.class);
    @Autowired
    private FriendKeywordTagLabelCacheService friendKeywordCacheService;
    @Autowired
    private FriendTagLabelCommonService friendTagLabelCommonService;

    public boolean recvText() {
        try {
            return this.recvTextInternal();
        }
        catch (Exception e) {
            log.error("recvText", (Throwable)e);
            return false;
        }
    }

    public boolean recvTextInternal() {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("friend keyword reply, requestId={}", (Object)ctx.getRequestId());
        MatchedResult result = this.friendKeywordCacheService.match(ctx.getBusinessCustomerId(), ctx.getWechatId(), ctx.getPureMsg());
        if (result.isEmpty()) {
            return false;
        }
        Set<LabelItemDto> labelItemDtos = result.getHits().stream().flatMap(t -> t.getLabelItemDtoSet().stream()).collect(Collectors.toSet());
        this.friendTagLabelCommonService.tagLabel(labelItemDtos);
        return true;
    }
}

