/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.biz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.label.entity.LogicAutoWechatLabel;
import com.kuaike.skynet.logic.dal.label.mapper.LogicAutoWechatLabelMapper;
import com.kuaike.skynet.logic.handler.biz.FriendTagLabelCommonService;
import com.kuaike.skynet.logic.service.reply.dto.label.LabelItemDto;
import com.kuaike.skynet.logic.service.reply.enums.FriendMsgReplyType;
import com.kuaike.skynet.logic.service.util.KeywordUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FriendKeywordTagLabelDefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendKeywordTagLabelDefaultHandler.class);
    @Autowired
    private LogicAutoWechatLabelMapper logicAutoWechatLabelMapper;
    @Autowired
    private FriendTagLabelCommonService friendTagLabelCommonService;

    public boolean recvImage() {
        return this.tagLabel(FriendMsgReplyType.IMAGE);
    }

    public boolean recvVideo() {
        return this.tagLabel(FriendMsgReplyType.VIDEO);
    }

    public boolean recvVoice() {
        return this.tagLabel(FriendMsgReplyType.VOICE);
    }

    public boolean recvFile() {
        return this.tagLabel(FriendMsgReplyType.FILE);
    }

    public boolean recvLink() {
        return this.tagLabel(FriendMsgReplyType.LINK_CARD);
    }

    public boolean recvProgram() {
        return this.tagLabel(FriendMsgReplyType.MINI_PROGRAM);
    }

    private boolean tagLabel(FriendMsgReplyType msgType) {
        long begin = System.currentTimeMillis();
        try {
            return this.tagLabelInternal(msgType);
        }
        catch (Exception e) {
            log.error("tagLabel error", (Throwable)e);
            log.info("tag label time:{}", (Object)(System.currentTimeMillis() - begin));
            return true;
        }
    }

    private boolean tagLabelInternal(FriendMsgReplyType msgType) {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("default tag label on msgType={}, requestId={}", (Object)msgType, (Object)ctx.getRequestId());
        String wechatId = ctx.getWechatId();
        String text = ctx.getPureMsg();
        Long businessCustomerId = ctx.getBusinessCustomerId();
        LogicAutoWechatLabel wechatLabel = this.logicAutoWechatLabelMapper.selectByWechatIdAndBizId(wechatId, businessCustomerId);
        if (Objects.isNull(wechatLabel)) {
            log.info("not config tag label requestId={}", (Object)ctx.getRequestId());
            return false;
        }
        if (StringUtils.isBlank((CharSequence)wechatLabel.getLabelIds())) {
            log.warn("not config label:{}, requestId={}", (Object)JSON.toJSONString((Object)wechatLabel), (Object)ctx.getRequestId());
            return false;
        }
        if (StringUtils.isBlank((CharSequence)wechatLabel.getRtypesStr())) {
            log.warn("not config rtypes:{}, requestId={}", (Object)JSON.toJSONString((Object)wechatLabel), (Object)ctx.getRequestId());
            return false;
        }
        Set rtypes = KeywordUtil.strToIdsStr((String)wechatLabel.getRtypesStr()).stream().map(Integer::valueOf).collect(Collectors.toSet());
        rtypes.remove(FriendMsgReplyType.KEYWORD.getValue());
        log.info("config rtypes:{}", rtypes);
        if (!rtypes.contains(msgType.getValue())) {
            log.info("not support msgType:{}", (Object)msgType);
        }
        List labelItemDtos = null;
        try {
            labelItemDtos = JSONArray.parseArray((String)wechatLabel.getLabelIds(), LabelItemDto.class);
        }
        catch (Exception e) {
            log.error("parseArray error: LabelIdsConfig:{}", (Object)wechatLabel.getLabelIds(), (Object)e);
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)labelItemDtos)) {
            log.warn("conig label illegal:{}", (Object)JSON.toJSONString((Object)wechatLabel));
            return false;
        }
        this.friendTagLabelCommonService.tagLabel(labelItemDtos.stream().collect(Collectors.toSet()));
        return true;
    }
}

