/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.biz;

import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoReply;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.skynet.logic.handler.common.ReplyMsgSendHelper;
import com.kuaike.skynet.logic.service.cache.dto.CachedReplyMsg;
import com.kuaike.skynet.logic.service.common.utils.SHA1Utils;
import com.kuaike.skynet.logic.service.reply.enums.FriendMsgReplyType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FriendDefaultReplyHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendDefaultReplyHandler.class);
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private ReplyMsgSendHelper replyMsgSendHelper;

    public boolean defaultReply() {
        return this.reply(FriendMsgReplyType.DEFAULT);
    }

    public boolean recvImage() {
        return this.reply(FriendMsgReplyType.IMAGE);
    }

    public boolean recvVideo() {
        return this.reply(FriendMsgReplyType.VIDEO);
    }

    public boolean recvVoice() {
        return this.reply(FriendMsgReplyType.VOICE);
    }

    public boolean recvFile() {
        return this.reply(FriendMsgReplyType.FILE);
    }

    private boolean reply(FriendMsgReplyType msgType) {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("default reply on msgType={}, requestId={}", (Object)msgType, (Object)ctx.getRequestId());
        String wechatId = ctx.getWechatId();
        String text = ctx.getPureMsg();
        Long businessCustomerId = ctx.getBusinessCustomerId();
        LogicAutoReply reply = this.logicAutoReplyMapper.selectFriendDefaultReply(wechatId, businessCustomerId, msgType.getDesc());
        if (reply == null) {
            return false;
        }
        if (reply.getEnabled() == null || reply.getEnabled() == 0) {
            log.info("Auto reply is disabled for businessCustomerId={}, wechatId={}", (Object)businessCustomerId, (Object)wechatId);
            return false;
        }
        String message = reply.getMessage();
        if (StringUtils.isBlank((CharSequence)message)) {
            log.warn("Auto reply message is blank, replyId={}", (Object)reply.getId());
            return false;
        }
        CachedReplyMsg dto = new CachedReplyMsg();
        dto.setReplyId(reply.getId());
        dto.setMsg(reply.getMessage());
        if (StringUtils.isNotBlank((CharSequence)reply.getMessage())) {
            dto.setDigest(reply.getDigest());
        } else {
            dto.setDigest(SHA1Utils.digest((String)reply.getMessage()));
        }
        return this.replyMsgSendHelper.sendFriendMsg(text, null, dto);
    }
}

