/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler.biz;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.skynet.link.service.WechatOpService;
import com.kuaike.skynet.link.service.common.BaseResponse;
import com.kuaike.skynet.link.service.dto.NoteWechatRequestS;
import com.kuaike.skynet.logic.dal.reply.entity.LogicAutoRemarkFriendConfig;
import com.kuaike.skynet.logic.dal.reply.mapper.LogicAutoRemarkFriendConfigMapper;
import com.kuaike.skynet.logic.handler.dto.WaitJoinFriendDto;
import com.kuaike.skynet.logic.service.cache.WechatAccountCacheService;
import com.kuaike.skynet.logic.wechat.msg.WaitJoinFriendEvent;
import com.kuaike.skynet.logic.wechat.utils.MsgUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class FriendAutoRemarkHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendAutoRemarkHandler.class);
    public static final String NICKNAME = "${nickname}";
    public static final String CONTENT = "${content}";
    public static final String DATE = "${date}";
    public static final String SEX = "${sex}";
    public static final String NICKNAME_PLACE_HOLDER = "#nick#";
    public static final int MAX_COMMENT_LENGTH = 50;
    protected XmlMapper xmlMapper;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
    @Autowired
    private WechatAccountCacheService wechatAccountCacheService;
    @Autowired
    private WechatOpService wechatOpService;
    @Autowired
    private LogicAutoRemarkFriendConfigMapper logicAutoRemarkFriendConfigMapper;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.autoRemarkFriendFormat}")
    private String autoRemarkFriendFormat;
    @Value(value="${autoRemarkFriendDelayMs:2000}")
    private Long autoRemarkFriendDelayMs;

    public FriendAutoRemarkHandler() {
        this.xmlMapper = new XmlMapper();
        this.xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public void onWaitJoinFriendEvent(WechatMessage wechatMessage) {
        log.info("Record join friend content, requestId={}, wechatId={}, talkerId={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getWechatId(), wechatMessage.getTalkerId()});
        String format = this.getFormat(wechatMessage.getWechatId());
        if (format == null) {
            log.info("\u672a\u80fd\u83b7\u53d6\u53ef\u7528\u7684\u597d\u53cb\u81ea\u52a8\u5907\u6ce8\u914d\u7f6e\uff0c\u4e0d\u6267\u884c\u540e\u7eed\u64cd\u4f5c\u3002requestId={}, wechatId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getWechatId());
            return;
        }
        WaitJoinFriendEvent event = null;
        try {
            String message = wechatMessage.getMessage();
            event = (WaitJoinFriendEvent)this.xmlMapper.readValue(message, WaitJoinFriendEvent.class);
            log.info("\u7533\u8bf7\u6dfb\u52a0\u4e3a\u597d\u53cb, \u7528\u6237\u6635\u79f0:{}, \u5907\u6ce8\u4fe1\u606f:{}", (Object)event.getFromNickname(), (Object)event.getContent());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u6dfb\u52a0\u597d\u53cb\u4e8b\u4ef6\u5931\u8d25", (Throwable)e);
            return;
        }
        String key = this.getKey(wechatMessage.getWechatId(), wechatMessage.getTalkerId());
        WaitJoinFriendDto data = new WaitJoinFriendDto();
        data.setNickname(event.getFromNickname());
        data.setContent(event.getContent());
        String value = JacksonUtil.obj2Str((Object)data);
        Duration timeout = Duration.ofHours(24L);
        try {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, timeout);
            log.info("\u7f13\u5b58\u7533\u8bf7\u6dfb\u52a0\u597d\u53cb\u7684\u5907\u6ce8\u4fe1\u606f. key={}, value={}, timeout={}", new Object[]{key, value, timeout});
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u7533\u8bf7\u6dfb\u52a0\u597d\u53cb\u7684\u5907\u6ce8\u4fe1\u606f\u5931\u8d25. key={}, value={}", new Object[]{key, value, e});
            e.printStackTrace();
        }
    }

    public boolean onFriendIsJoinedEvent(WechatMessage wechatMessage) {
        return this.onFriendJoined(wechatMessage);
    }

    public boolean onJoinedByFriendEvent(WechatMessage wechatMessage) {
        return this.onFriendJoined(wechatMessage);
    }

    public boolean onFriendJoined(WechatMessage wechatMessage) {
        log.info("Auto remark on friend is joined, requestID={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
        String wechatId = wechatMessage.getWechatId();
        String talkerId = wechatMessage.getTalkerId();
        String key = this.getKey(wechatId, talkerId);
        String format = this.getFormat(wechatId);
        if (format == null) {
            log.info("No auto remark config founnd. requestId={}, wechatId={}", (Object)wechatMessage.getRequestId(), (Object)wechatId);
            this.redisTemplate.delete((Object)key);
            return false;
        }
        Map<String, String> model = this.getModel(format, wechatMessage, key);
        String comment = this.render(format, model);
        log.info("\u4e3a\u597d\u53cb {} \u751f\u6210\u5907\u6ce8\u5b57\u7b26\u4e32: {}", (Object)talkerId, (Object)format);
        if (this.note(wechatId, talkerId, comment)) {
            this.redisTemplate.delete((Object)key);
            return true;
        }
        return false;
    }

    private Map<String, String> getModel(String format, WechatMessage wechatMessage, String redisKey) {
        HashMap<String, String> model = new HashMap<String, String>();
        String content = "";
        String nickname = "";
        String date = "";
        if (format.contains(DATE)) {
            date = this.sdf.format(wechatMessage.getCreateTime());
            model.put(DATE, date);
        }
        if (format.contains(CONTENT)) {
            Object obj = this.redisTemplate.opsForValue().get((Object)redisKey);
            if (obj != null) {
                try {
                    WaitJoinFriendDto data = (WaitJoinFriendDto)JacksonUtil.str2Obj((String)obj.toString(), WaitJoinFriendDto.class);
                    content = data.getContent();
                    nickname = data.getNickname();
                }
                catch (IOException e) {
                    log.error("Failed getting user nickname from cache, value={}", obj, (Object)e);
                    e.printStackTrace();
                }
            }
            model.put(CONTENT, content);
        }
        if (format.contains(NICKNAME)) {
            if (StringUtils.isBlank((CharSequence)nickname)) {
                log.info("trying to get user nickname from message, message={}", (Object)wechatMessage.getMessage());
                nickname = MsgUtils.getJoinFriendNickName((String)wechatMessage.getMessage());
            }
            if (StringUtils.isBlank((CharSequence)nickname)) {
                log.info("trying to get user nickname from upload message, talkerNickName={}", (Object)wechatMessage.getTalkerNickName());
                nickname = wechatMessage.getTalkerNickName();
            }
            if (StringUtils.isBlank((CharSequence)nickname)) {
                log.warn("Failed getting user nickname, message={}", (Object)wechatMessage);
                nickname = NICKNAME_PLACE_HOLDER;
            }
            model.put(NICKNAME, nickname);
        }
        if (format.contains(SEX)) {
            String sexStr = "";
            Integer sex = wechatMessage.getTalkerSex();
            if (sex != null) {
                if (sex == 1) {
                    sexStr = "\u7537";
                } else if (sex == 2) {
                    sexStr = "\u5973";
                } else {
                    log.warn("unknown sex={}", (Object)sex);
                }
            }
            model.put(SEX, sexStr);
        }
        return model;
    }

    private boolean note(String wechatId, String talkerId, String comment) {
        log.info("Note friend with wechatId={}, talkderId={}, comment={}", new Object[]{wechatId, talkerId, comment});
        NoteWechatRequestS req = new NoteWechatRequestS();
        req.setWId(wechatId);
        req.setTargetWid(talkerId);
        req.setComment(comment);
        req.setDelayMs(this.getDelayMs());
        if (comment.length() > 50) {
            comment = comment.substring(0, 50);
            log.warn("Comment is too long, max comment length is {}, actal comment={}", (Object)comment);
        }
        log.info("\u53d1\u9001\u597d\u53cb\u5907\u6ce8\u8bf7\u6c42, req={}", (Object)req);
        try {
            BaseResponse resp = this.wechatOpService.noteWechat(req);
            if (resp.getCode() == 0L) {
                log.info("\u53d1\u9001\u5907\u6ce8\u8bf7\u6c42\u6210\u529f. requestId={}", (Object)resp.getRequestId());
                return true;
            }
            log.warn("\u53d1\u9001\u5907\u6ce8\u8bf7\u6c42\u5931\u8d25. resp={}", (Object)resp);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4fee\u6539\u5fae\u4fe1\u5907\u6ce8\u5931\u8d25.", (Throwable)e);
            e.printStackTrace();
        }
        return false;
    }

    private String render(String template, Map<String, String> model) {
        log.info("Render comment with template={}, model={}", (Object)template, model);
        String comment = template;
        Set<Map.Entry<String, String>> entries = model.entrySet();
        for (Map.Entry<String, String> e : entries) {
            String k = e.getKey();
            String v = e.getValue();
            String value = v == null ? "" : v;
            comment = FriendAutoRemarkHandler.replace(comment, k, value);
        }
        return comment;
    }

    private static String replace(String source, String placeHolder, String target) {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return source;
        }
        if (StringUtils.isEmpty((CharSequence)placeHolder)) {
            return source;
        }
        if (placeHolder.equals(target)) {
            return source;
        }
        while (source.contains(placeHolder)) {
            source = source.replace(placeHolder, target);
        }
        return source;
    }

    private String getKey(String wechatId, String talkerId) {
        return String.format(this.autoRemarkFriendFormat, wechatId, talkerId);
    }

    private String getFormat(String wechatId) {
        Long businessCustomerId = this.wechatAccountCacheService.getBusinessCustomerId(wechatId);
        LogicAutoRemarkFriendConfig config = this.logicAutoRemarkFriendConfigMapper.queryByWechatId(businessCustomerId, wechatId);
        if (config == null) {
            log.info("\u5fae\u4fe1 {} \u6ca1\u6709\u53ef\u7528\u7684\u597d\u53cb\u81ea\u52a8\u5907\u6ce8\u914d\u7f6e\u4fe1\u606f", (Object)wechatId);
            return null;
        }
        if (StringUtils.isBlank((CharSequence)config.getFormat())) {
            log.info("\u5fae\u4fe1 {} \u6ca1\u6709\u53ef\u7528\u7684\u597d\u53cb\u81ea\u52a8\u5907\u6ce8\u914d\u7f6e\u4fe1\u606f, config={}", (Object)wechatId, (Object)config);
            return null;
        }
        if (config.getEnabled() == 0) {
            log.info("\u5fae\u4fe1 {} \u7684\u597d\u53cb\u81ea\u52a8\u5907\u6ce8\u914d\u7f6e\u529f\u80fd\u5df2\u7981\u7528, config={}", (Object)wechatId, (Object)config);
            return null;
        }
        long now = System.currentTimeMillis();
        if (config.getStartTime() != null && now < config.getStartTime().getTime()) {
            log.info("\u5fae\u4fe1 {} \u7684\u597d\u53cb\u81ea\u52a8\u5907\u6ce8\u914d\u7f6e\u529f\u80fd\u4e0d\u5728\u751f\u6548\u671f\u51851, config={}", (Object)wechatId, (Object)config);
            return null;
        }
        if (config.getEndTime() != null && now > config.getEndTime().getTime()) {
            log.info("\u5fae\u4fe1 {} \u7684\u597d\u53cb\u81ea\u52a8\u5907\u6ce8\u914d\u7f6e\u529f\u80fd\u4e0d\u5728\u751f\u6548\u671f\u51852, config={}", (Object)wechatId, (Object)config);
            return null;
        }
        return config.getFormat();
    }

    private long getDelayMs() {
        long value = 0L;
        if (this.autoRemarkFriendDelayMs != null) {
            value = this.autoRemarkFriendDelayMs;
        }
        return value;
    }
}

