/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.handler;

import com.kuaike.common.entity.WechatMessage;
import com.kuaike.common.enums.WechatMsgType;
import com.kuaike.skynet.logic.context.ReplyContext;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.handler.biz.FriendAutoGroupHandler;
import com.kuaike.skynet.logic.handler.biz.FriendAutoRemarkHandler;
import com.kuaike.skynet.logic.handler.biz.FriendDefaultReplyHandler;
import com.kuaike.skynet.logic.handler.biz.FriendJoinedReplyHandler;
import com.kuaike.skynet.logic.handler.biz.FriendKeywordReplyHandler;
import com.kuaike.skynet.logic.handler.biz.FriendKeywordTagLabelDefaultHandler;
import com.kuaike.skynet.logic.handler.biz.FriendKeywordTagLabelHandler;
import com.kuaike.skynet.logic.handler.biz.ReplyOptionHandler;
import com.kuaike.skynet.logic.handler.debug.DebugReplyHandler;
import com.kuaike.skynet.logic.handler.marketing.DrainageFriendReplyHandler;
import com.kuaike.skynet.logic.handler.marketing.FissionFriendReplyHandler;
import com.kuaike.skynet.logic.handler.marketing.FissionGroupReplyHandler;
import com.kuaike.skynet.logic.service.cache.BlacklistCacheService;
import com.kuaike.skynet.logic.service.cache.WechatAccountCacheService;
import com.kuaike.skynet.logic.service.message.WechatMsgService;
import com.kuaike.skynet.logic.wechat.utils.AbstractMsgHandler;
import com.kuaike.skynet.logic.wechat.utils.MsgUtils;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class FriendMsgRecvHandler
extends AbstractMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendMsgRecvHandler.class);
    @Autowired
    private WechatMsgService wechatMsgService;
    @Autowired
    private WechatAccountCacheService wechatAccountCacheService;
    @Autowired
    private BlacklistCacheService blacklistCacheService;
    @Autowired
    private DrainageFriendReplyHandler drainageFriendReplyHandler;
    @Autowired
    private FissionFriendReplyHandler fissionFriendReplyHandler;
    @Autowired
    private FissionGroupReplyHandler fissionGroupReplyHandler;
    @Autowired
    private FriendKeywordReplyHandler friendKeywordReplyHandler;
    @Autowired
    private ReplyOptionHandler replyOptionHandler;
    @Autowired
    private FriendAutoRemarkHandler friendAutoRemarkHandler;
    @Autowired
    private FriendJoinedReplyHandler friendJoinedReplyHandler;
    @Autowired
    private FriendDefaultReplyHandler friendDefaultReplyHandler;
    @Autowired
    private FriendKeywordTagLabelDefaultHandler friendKeywordTagLabelDefaultHandler;
    @Autowired
    private FriendKeywordTagLabelHandler friendKeywordTagLabelHandler;
    @Autowired
    private DebugReplyHandler debugOptionHanlder;
    @Autowired
    private FriendAutoGroupHandler friendAutoGroupHandler;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${spring.redis.key.msgSyncLock.format:msg_sync_lock:%s}")
    private String msgSyncLock;
    @Value(value="${spring.redis.key.msgSyncLock.expire:600}")
    private long msgSyncLockExpireTime;

    public void dispatch(WechatMessage wechatMessage) {
        String wechatId = wechatMessage.getWechatId();
        String talkerId = wechatMessage.getTalkerId();
        ReplyContext ctx = ReplyContextUtil.get();
        ctx.setTalkerId(talkerId);
        if (talkerId.equals(wechatId)) {
            return;
        }
        if (MsgUtils.OFFICIAL_ACCOUNT_ID.matcher(talkerId).matches()) {
            log.info("Ignore message from official account, requestId={}", (Object)ctx.getRequestId());
            return;
        }
        if (MsgUtils.WEWORK_ID.matcher(talkerId).matches()) {
            log.info("Ignore message from wework, requestId={}", (Object)ctx.getRequestId());
            return;
        }
        if (MsgUtils.FILTER_OFFICAL_ACCOUNT.contains(talkerId)) {
            log.info("Ignore message from wechat official, requestId={}", (Object)ctx.getRequestId());
            return;
        }
        if (this.blacklistCacheService.inBlacklist(ctx.getBusinessCustomerId(), talkerId)) {
            log.info("Ignore wechat contact in black list, businessCustomerId={}, talkerId={}", (Object)ctx.getBusinessCustomerId(), (Object)talkerId);
            return;
        }
        if (this.wechatAccountCacheService.isRobot(talkerId)) {
            log.info("Ignore robot, talkerId={}", (Object)talkerId);
            return;
        }
        if (!this.wechatMsgService.isServiceTime()) {
            return;
        }
        if (!this.locked(ctx.getBusinessCustomerId(), wechatMessage.getMsgSvrId())) {
            log.info("Not locked, requestId={}", (Object)ctx.getRequestId());
            return;
        }
        super.dispatch(wechatMessage);
    }

    private boolean locked(Long buId, String msgSvrId) {
        String content = String.format(this.msgSyncLock, buId + ":" + msgSvrId);
        String lockKey = this.redisKeyPrefix + content;
        try {
            Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"", this.msgSyncLockExpireTime, TimeUnit.SECONDS);
            log.debug("locked={}, key={}", (Object)locked, (Object)lockKey);
            if (locked == null) {
                return false;
            }
            return locked;
        }
        catch (Exception e) {
            log.error("Failed lock msg msgSrvId={}", (Object)msgSvrId, (Object)e);
            return false;
        }
    }

    public void text(WechatMessage wechatMessage) {
        log.info("Receive text from friend, requestId={}, talkerId={}, message={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getTalkerId(), wechatMessage.getMessage()});
        if ("\u6211\u901a\u8fc7\u4e86\u4f60\u7684\u670b\u53cb\u9a8c\u8bc1\u8bf7\u6c42\uff0c\u73b0\u5728\u6211\u4eec\u53ef\u4ee5\u5f00\u59cb\u804a\u5929\u4e86".equals(wechatMessage.getMessage())) {
            log.info("addFriendByMobile reveived requestId:{}", (Object)wechatMessage.getRequestId());
            this.onFriendIsJoinedEvent(wechatMessage);
            return;
        }
        String text = wechatMessage.getMessage();
        ReplyContextUtil.get().setMsg(text);
        text = MsgUtils.removeReferredText((String)text);
        ReplyContextUtil.get().setPureMsg(text);
        this.friendKeywordTagLabelHandler.recvText();
        if (this.debugOptionHanlder.recvText(wechatMessage)) {
            return;
        }
        if (this.replyOptionHandler.recvFriendText()) {
            return;
        }
        if (this.fissionGroupReplyHandler.recvFriendText()) {
            return;
        }
        if (this.friendKeywordReplyHandler.recvText()) {
            return;
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return;
        }
    }

    public void image(WechatMessage wechatMessage) {
        log.info("Receive image from friend, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
        this.friendKeywordTagLabelDefaultHandler.recvImage();
        if (this.fissionFriendReplyHandler.recvFriendImage(wechatMessage)) {
            return;
        }
        if (this.friendDefaultReplyHandler.recvImage()) {
            return;
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return;
        }
    }

    public void voice(WechatMessage wechatMessage) {
        this.friendKeywordTagLabelDefaultHandler.recvVoice();
        if (this.friendDefaultReplyHandler.recvVoice()) {
            return;
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return;
        }
    }

    public void video(WechatMessage wechatMessage) {
        this.friendKeywordTagLabelDefaultHandler.recvVideo();
        if (this.friendDefaultReplyHandler.recvVideo()) {
            return;
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return;
        }
    }

    public void file(WechatMessage wechatMessage) {
        this.friendKeywordTagLabelDefaultHandler.recvFile();
        if (this.friendDefaultReplyHandler.recvFile()) {
            return;
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return;
        }
    }

    public void gif(WechatMessage wechatMessage) {
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return;
        }
    }

    public void appUrl(WechatMessage wechatMessage) {
        if (WechatMsgType.LINK_CARD.getValue() == wechatMessage.getType().intValue()) {
            this.friendKeywordTagLabelDefaultHandler.recvLink();
        }
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return;
        }
    }

    public void miniProgram(WechatMessage wechatMessage) {
        this.friendKeywordTagLabelDefaultHandler.recvProgram();
        if (this.friendDefaultReplyHandler.defaultReply()) {
            return;
        }
    }

    public void onWaitJoinFriendEvent(WechatMessage wechatMessage) {
        log.info("Receive wait add frient event, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
        this.friendAutoRemarkHandler.onWaitJoinFriendEvent(wechatMessage);
        this.drainageFriendReplyHandler.onWaitJoinFriendEvent(wechatMessage);
        this.fissionFriendReplyHandler.onWaitJoinFriendEvent(wechatMessage);
    }

    public void onFriendIsJoinedEvent(WechatMessage wechatMessage) {
        log.info("Receive FriendIsJoinedEvent, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
        this.friendAutoRemarkHandler.onFriendIsJoinedEvent(wechatMessage);
        this.friendAutoGroupHandler.handleActiveAddFriend(wechatMessage);
        if (this.drainageFriendReplyHandler.onFriendIsJoined(wechatMessage)) {
            return;
        }
        if (this.fissionFriendReplyHandler.onFriendIsJoined(wechatMessage)) {
            return;
        }
        if (this.friendJoinedReplyHandler.handle(wechatMessage)) {
            return;
        }
    }

    public void onJoinedByFriendEvent(WechatMessage wechatMessage) {
        log.info("Receive JoinedByFriendEvent, requestId={}, talkerId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getTalkerId());
        this.friendAutoRemarkHandler.onFriendIsJoinedEvent(wechatMessage);
        this.friendAutoGroupHandler.handlePassiveAddFriend(wechatMessage);
        if (this.drainageFriendReplyHandler.onFriendIsJoined(wechatMessage)) {
            return;
        }
        if (this.fissionFriendReplyHandler.onFriendIsJoined(wechatMessage)) {
            return;
        }
        if (this.friendJoinedReplyHandler.handle(wechatMessage)) {
            return;
        }
    }
}

