/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.dispatcher;

import com.google.common.base.Preconditions;
import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.logic.context.ReplyContextUtil;
import com.kuaike.skynet.logic.handler.FriendMsgRecvHandler;
import com.kuaike.skynet.logic.handler.GroupMsgRecvHandler;
import com.kuaike.skynet.logic.service.cache.WechatAccountCacheService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WechatMessageDispatcher {
    private static final Logger log = LoggerFactory.getLogger(WechatMessageDispatcher.class);
    @Value(value="${wechatMessage.expireTime.friend:7200}")
    private long friendMsgExpiredTime;
    @Value(value="${wechatMessage.expireTime.group:600}")
    private long groupMsgExpiredTime;
    @Autowired
    private WechatAccountCacheService wechatAccountCacheService;
    @Autowired
    private FriendMsgRecvHandler friendMsgRecvHandler;
    @Autowired
    private GroupMsgRecvHandler groupMsgRecvHandler;

    public long expired(WechatMessage wechatMessage) {
        Preconditions.checkArgument((wechatMessage != null ? 1 : 0) != 0, (Object)"wechatMessage is null");
        Preconditions.checkArgument((wechatMessage.getCreateTime() != null ? 1 : 0) != 0, (Object)"createTime is null");
        Preconditions.checkArgument((wechatMessage.getTalkerType() != null ? 1 : 0) != 0, (Object)"talkerType is null");
        int talkerType = wechatMessage.getTalkerType();
        long expiredTime = talkerType == 1 ? this.friendMsgExpiredTime : this.groupMsgExpiredTime;
        Date createTime = wechatMessage.getCreateTime();
        long time = createTime.getTime();
        long cur = System.currentTimeMillis();
        long last = (cur - time) / 1000L;
        return last - expiredTime;
    }

    public void dispatch(WechatMessage wechatMessage) {
        log.info("handle message requestId={}, msgSvrId={}, wechatId={}, talkerId={}, talkerType={}, isSend={}, createTime={}", new Object[]{wechatMessage.getRequestId(), wechatMessage.getMsgSvrId(), wechatMessage.getWechatId(), wechatMessage.getTalkerId(), wechatMessage.getTalkerType(), wechatMessage.getIsSend(), wechatMessage.getCreateTime()});
        Integer talkerType = wechatMessage.getTalkerType();
        if (talkerType == null) {
            log.warn("Invalid talkerType, requestId={}", (Object)wechatMessage.getRequestId());
            return;
        }
        boolean isSend = wechatMessage.getIsSend();
        if (isSend) {
            log.info("Ignore message send by BOT, requestId={}, wechatId={}", (Object)wechatMessage.getRequestId(), (Object)wechatMessage.getWechatId());
            return;
        }
        long expiredTime = this.expired(wechatMessage);
        if (expiredTime > 0L) {
            log.warn("Ignore expired message. requestId={}, expired={}", (Object)wechatMessage.getRequestId(), (Object)WechatMessageDispatcher.formatExpireTime(expiredTime));
            return;
        }
        Long businessCustomerId = this.wechatAccountCacheService.getBusinessCustomerId(wechatMessage.getWechatId());
        if (businessCustomerId == null) {
            log.warn("businessCustomerId is null, ignore this message. wechatId={}", (Object)wechatMessage.getWechatId());
            return;
        }
        ReplyContextUtil.get().setBusinessCustomerId(businessCustomerId);
        switch (talkerType) {
            case 1: {
                this.friendMsgRecvHandler.dispatch(wechatMessage);
                break;
            }
            case 2: {
                this.groupMsgRecvHandler.dispatch(wechatMessage);
                break;
            }
            default: {
                log.warn("Invalid talkerType, requestId={}, talkerType={}", (Object)wechatMessage.getRequestId(), (Object)talkerType);
            }
        }
    }

    private static String formatExpireTime(long sec) {
        StringBuilder sb = new StringBuilder();
        if (sec >= 86400L) {
            long days = sec / 86400L;
            sec -= days * 86400L;
            sb.append(days).append("day");
        }
        if (sec >= 3600L) {
            long hours = sec / 3600L;
            sec -= hours * 3600L;
            sb.append(hours).append("hour");
        }
        if (sec >= 60L) {
            long minutes = sec / 60L;
            sec -= minutes * 60L;
            sb.append(minutes).append("min");
        }
        if (sec > 0L) {
            sb.append(sec).append("sec");
        }
        return sb.toString();
    }
}

