/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.dispatcher;

import com.kuaike.common.entity.WechatMessage;
import com.kuaike.skynet.logic.handler.biz.AcceptFriendHandler;
import com.kuaike.skynet.logic.service.common.utils.NamedThreadFactory;
import com.kuaike.skynet.logic.service.common.utils.ThreadPoolMonitorUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AcceptFriendDispatcher {
    private static final Logger log = LoggerFactory.getLogger(AcceptFriendDispatcher.class);
    @Autowired
    private AcceptFriendHandler acceptFriendHandler;
    private ExecutorService executors = Executors.newFixedThreadPool(4, (ThreadFactory)new NamedThreadFactory("acceptFriendMsgPool"));

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executors);
    }

    public boolean isAcceptFriendMessage(WechatMessage wechatMessage) {
        String contentValueStr = wechatMessage.getMessage();
        return contentValueStr != null && contentValueStr.contains("ticket") && contentValueStr.contains("opcode") && contentValueStr.contains("scene");
    }

    public void dispatchMessage(WechatMessage wechatMessage) {
        log.info("dispatch acceptFriendMsg {}", (Object)wechatMessage);
        this.executors.submit(() -> {
            try {
                this.acceptFriendHandler.handler(wechatMessage);
            }
            catch (Exception e) {
                log.error("execute with error", (Throwable)e);
            }
        });
    }
}

