/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.manager.common.dto.wechat;

import com.google.common.base.Preconditions;
import com.kuaike.skynet.manager.common.dto.GroupAssistantMsgContentDto;
import com.kuaike.skynet.manager.common.dto.wechat.MultiSelectWechatContactListReqDto;
import com.kuaike.skynet.manager.common.enums.SendType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AddGroupSendAssistantReq
implements Serializable {
    private static final long serialVersionUID = -6169303253793169165L;
    private Long taskId;
    private Set<MultiSelectWechatContactListReqDto> groupSendWechatContact;
    private Integer sendType;
    private Date sendTime;
    private String taskName;
    private Integer groupSendWechatContactNum;
    private GroupAssistantMsgContentDto singleContent;

    public void validate(Map<String, Set<String>> wechatContactMap, Map<String, String> nickNameMap, int contactLimit, int taskLimit) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.taskName), (Object)"\u4efb\u52a1\u540d\u79f0\u4e3a\u7a7a");
        Preconditions.checkArgument((this.taskName.length() >= 1 && this.taskName.length() <= 20 ? 1 : 0) != 0, (Object)"\u4efb\u52a1\u540d\u79f01-20\u5b57\u7b26");
        SendType sendTypeEnum = SendType.getType(this.sendType);
        Preconditions.checkArgument((boolean)Objects.nonNull((Object)sendTypeEnum), (Object)"\u53d1\u9001\u7c7b\u578b\u4e3a\u7a7a\u6216\u4e0d\u652f\u6301");
        if (sendTypeEnum.getValue() == SendType.TIMING.getValue()) {
            Preconditions.checkArgument((Objects.nonNull(this.sendTime) && this.sendTime.after(new Date()) ? 1 : 0) != 0, (Object)"\u5b9a\u65f6\u53d1\u9001,\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (Objects.isNull(this.sendTime)) {
            this.sendTime = new Date();
        }
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(wechatContactMap), (Object)"\u672a\u9009\u62e9\u673a\u5668\u4eba");
        int total = 0;
        Set<Map.Entry<String, Set<String>>> entries = wechatContactMap.entrySet();
        for (Map.Entry<String, Set<String>> entry : entries) {
            String nickname = nickNameMap.getOrDefault(entry.getKey(), entry.getKey());
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)entry.getKey()), (Object)"\u673a\u5668\u4eba\u5fae\u4fe1id\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)entry.getValue()), (Object)("\u673a\u5668\u4eba: " + nickname + "\u672a\u9009\u62e9\u597d\u53cb"));
            Preconditions.checkArgument((entry.getValue().size() <= contactLimit ? 1 : 0) != 0, (Object)("\u673a\u5668\u4eba: " + nickname + "\u9009\u62e9\u7684\u597d\u53cb\u8d85\u8fc7\u5355\u6b21\u4efb\u52a1\u4e0a\u9650: " + contactLimit));
            total += entry.getValue().size();
        }
        Preconditions.checkArgument((total <= taskLimit ? 1 : 0) != 0, (Object)("\u9009\u62e9\u7684\u597d\u53cb\u8d85\u8fc7\u5355\u6b21\u4efb\u52a1\u4e0a\u9650: " + taskLimit));
        Preconditions.checkArgument((boolean)Objects.nonNull(this.singleContent), (Object)"\u53d1\u9001\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        this.singleContent.validate();
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public Set<MultiSelectWechatContactListReqDto> getGroupSendWechatContact() {
        return this.groupSendWechatContact;
    }

    public Integer getSendType() {
        return this.sendType;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Integer getGroupSendWechatContactNum() {
        return this.groupSendWechatContactNum;
    }

    public GroupAssistantMsgContentDto getSingleContent() {
        return this.singleContent;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setGroupSendWechatContact(Set<MultiSelectWechatContactListReqDto> groupSendWechatContact) {
        this.groupSendWechatContact = groupSendWechatContact;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setGroupSendWechatContactNum(Integer groupSendWechatContactNum) {
        this.groupSendWechatContactNum = groupSendWechatContactNum;
    }

    public void setSingleContent(GroupAssistantMsgContentDto singleContent) {
        this.singleContent = singleContent;
    }

    public String toString() {
        return "AddGroupSendAssistantReq(taskId=" + this.getTaskId() + ", groupSendWechatContact=" + this.getGroupSendWechatContact() + ", sendType=" + this.getSendType() + ", sendTime=" + this.getSendTime() + ", taskName=" + this.getTaskName() + ", groupSendWechatContactNum=" + this.getGroupSendWechatContactNum() + ", singleContent=" + this.getSingleContent() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddGroupSendAssistantReq)) {
            return false;
        }
        AddGroupSendAssistantReq other = (AddGroupSendAssistantReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$taskId = this.getTaskId();
        Long other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        Set<MultiSelectWechatContactListReqDto> this$groupSendWechatContact = this.getGroupSendWechatContact();
        Set<MultiSelectWechatContactListReqDto> other$groupSendWechatContact = other.getGroupSendWechatContact();
        if (this$groupSendWechatContact == null ? other$groupSendWechatContact != null : !((Object)this$groupSendWechatContact).equals(other$groupSendWechatContact)) {
            return false;
        }
        Integer this$sendType = this.getSendType();
        Integer other$sendType = other.getSendType();
        if (this$sendType == null ? other$sendType != null : !((Object)this$sendType).equals(other$sendType)) {
            return false;
        }
        Date this$sendTime = this.getSendTime();
        Date other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !((Object)this$sendTime).equals(other$sendTime)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        Integer this$groupSendWechatContactNum = this.getGroupSendWechatContactNum();
        Integer other$groupSendWechatContactNum = other.getGroupSendWechatContactNum();
        if (this$groupSendWechatContactNum == null ? other$groupSendWechatContactNum != null : !((Object)this$groupSendWechatContactNum).equals(other$groupSendWechatContactNum)) {
            return false;
        }
        GroupAssistantMsgContentDto this$singleContent = this.getSingleContent();
        GroupAssistantMsgContentDto other$singleContent = other.getSingleContent();
        return !(this$singleContent == null ? other$singleContent != null : !((Object)this$singleContent).equals(other$singleContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddGroupSendAssistantReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        Set<MultiSelectWechatContactListReqDto> $groupSendWechatContact = this.getGroupSendWechatContact();
        result = result * 59 + ($groupSendWechatContact == null ? 43 : ((Object)$groupSendWechatContact).hashCode());
        Integer $sendType = this.getSendType();
        result = result * 59 + ($sendType == null ? 43 : ((Object)$sendType).hashCode());
        Date $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 43 : ((Object)$sendTime).hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        Integer $groupSendWechatContactNum = this.getGroupSendWechatContactNum();
        result = result * 59 + ($groupSendWechatContactNum == null ? 43 : ((Object)$groupSendWechatContactNum).hashCode());
        GroupAssistantMsgContentDto $singleContent = this.getSingleContent();
        result = result * 59 + ($singleContent == null ? 43 : ((Object)$singleContent).hashCode());
        return result;
    }
}

