/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.skynet.logic.dal.wechat.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum WechatAccountType {
    REPAY_ROBOT(1, "\u95ee\u7b54\u673a\u5668\u4eba"),
    WORKER_ROBOT(2, "\u5de5\u4f5c\u673a\u5668\u4eba"),
    COLLECT_ROBOT(3, "\u91c7\u96c6\u673a\u5668\u4eba"),
    ATMOSPHERE_ROBOT(4, "\u6c1b\u56f4\u673a\u5668\u4eba");

    private Integer value;
    private String desc;
    private static Map<Integer, WechatAccountType> map;

    public static WechatAccountType getType(Integer type) {
        return map.get(type);
    }

    public static Integer getValueByDesc(String desc) {
        for (WechatAccountType type : WechatAccountType.values()) {
            if (!desc.equals(type.getDesc())) continue;
            return type.getValue();
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    private WechatAccountType(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    static {
        map = Maps.newHashMap();
        for (WechatAccountType type : WechatAccountType.values()) {
            map.put(type.value, type);
        }
    }
}

