/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.shop;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.FundGetOrderFlowListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.FundGetOrderFlowReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.FundGetScanWithdrawReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.FundGetWithdrawDetailReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.FundSetBankAccountReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.FundSubmitWithdrawReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.FundGetBalanceResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.FundGetOrderFlowListResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.FundGetOrderFlowResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.FundGetScanWithdrawResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.FundGetWithdrawResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.FundSubmitWithdrawResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxShopFundAPI {
    private static final Logger log = LoggerFactory.getLogger(WxShopFundAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.shop.funds.get_balance}")
    private String shopFundsGetBalanceUrl;
    @Value(value="${wx.shop.funds.get_order_flow}")
    private String shopFundGetOrderFlowUrl;
    @Value(value="${wx.shop.funds.scan_order_flow}")
    private String shopFundScanOrderFlowUrl;
    @Value(value="${wx.shop.funds.get_withdraw_detail}")
    private String shopFundGetWithdrawDetailUrl;
    @Value(value="${wx.shop.funds.scan_withdraw}")
    private String shopFundScanWithdrawUrl;
    @Value(value="${wx.shop.funds.set_bank_account}")
    private String shopFundSetBankAccountUrl;
    @Value(value="${wx.shop.funds.submit_withdraw}")
    private String shopFundSubmitWithdrawUrl;

    public FundGetBalanceResp getBalance(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("call getBalance");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap req = Maps.newHashMap();
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopFundsGetBalanceUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, FundGetBalanceResp.class, new Object[0]);
        FundGetBalanceResp result = (FundGetBalanceResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public FundGetOrderFlowResp getOrderFlow(@NonNull String accessToken, @NonNull FundGetOrderFlowReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("getOrderFlow with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopFundGetOrderFlowUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, FundGetOrderFlowResp.class, new Object[0]);
        FundGetOrderFlowResp result = (FundGetOrderFlowResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public FundGetOrderFlowListResp getOrderFlowList(@NonNull String accessToken, @NonNull FundGetOrderFlowListReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("getOrderFlowList with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopFundScanOrderFlowUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, FundGetOrderFlowListResp.class, new Object[0]);
        FundGetOrderFlowListResp result = (FundGetOrderFlowListResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public FundGetWithdrawResp getWithdrawDetail(@NonNull String accessToken, @NonNull FundGetWithdrawDetailReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("getWithdrawDetail with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopFundGetWithdrawDetailUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, FundGetWithdrawResp.class, new Object[0]);
        FundGetWithdrawResp result = (FundGetWithdrawResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public FundGetScanWithdrawResp scanWithdrawList(@NonNull String accessToken, @NonNull FundGetScanWithdrawReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("scanWithdrawList with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopFundScanWithdrawUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, FundGetScanWithdrawResp.class, new Object[0]);
        FundGetScanWithdrawResp result = (FundGetScanWithdrawResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode setBankAccount(@NonNull String accessToken, @NonNull FundSetBankAccountReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("setBankAccount with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        req.validate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopFundSetBankAccountUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public FundSubmitWithdrawResp submitWithdraw(@NonNull String accessToken, @NonNull FundSubmitWithdrawReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("submitWithdraw with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        req.validate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopFundSubmitWithdrawUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, FundSubmitWithdrawResp.class, new Object[0]);
        FundSubmitWithdrawResp result = (FundSubmitWithdrawResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

